"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.StaticWebsite = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cloudfront_1 = require("@aws-cdk/aws-cloudfront");
const aws_route53_targets_1 = require("@aws-cdk/aws-route53-targets");
const core_1 = require("@aws-cdk/core");
const website_alias_record_1 = require("./website-alias-record");
const website_bucket_1 = require("./website-bucket");
class StaticWebsite extends core_1.Construct {
    constructor(scope, id, props = {}) {
        super(scope, id);
        const { aliasConfiguration, bucketConfiguration, webACLId, disableIPv6, errorConfigurations } = props;
        const websiteBucket = new website_bucket_1.WebsiteBucket(this, 'Bucket', {
            ...bucketConfiguration,
        });
        const distibutionConfig = {
            webACLId,
            enableIpV6: !disableIPv6,
            originConfigs: [
                {
                    s3OriginSource: {
                        ...websiteBucket.s3OriginConfig,
                    },
                    behaviors: [{ isDefaultBehavior: true }],
                },
            ],
            aliasConfiguration,
            errorConfigurations,
        };
        this.distribution = new aws_cloudfront_1.CloudFrontWebDistribution(this, 'Distribution', distibutionConfig);
        if (aliasConfiguration) {
            new website_alias_record_1.WebsiteAliasRecord(this, 'AliasRecord', {
                domainName: aliasConfiguration.domainName,
                recordNames: aliasConfiguration.names,
                target: new aws_route53_targets_1.CloudFrontTarget(this.distribution),
                disableIPv6,
                privateZone: aliasConfiguration.privateZone,
                vpcId: aliasConfiguration.vpcId,
            });
        }
    }
    addLambdaFunctionAssociation(assosiation) {
        this.addLambdaFunctionAssociations([assosiation]);
    }
    addLambdaFunctionAssociations(assosiations) {
        const cfDist = this.distribution.node.findChild('CFDistribution');
        cfDist.addOverride('Properties.DistributionConfig.DefaultCacheBehavior.LambdaFunctionAssociations', assosiations.map((assosiation) => ({
            EventType: assosiation.eventType,
            LambdaFunctionARN: assosiation.lambdaFunction.functionArn,
        })));
    }
}
exports.StaticWebsite = StaticWebsite;
_a = JSII_RTTI_SYMBOL_1;
StaticWebsite[_a] = { fqn: "@cloudcomponents/cdk-static-website.StaticWebsite", version: "1.42.0" };
//# sourceMappingURL=data:application/json;base64,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