/**
 *  Copyright 2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
import * as kinesisfirehose from '@aws-cdk/aws-kinesisfirehose';
import { Construct } from '@aws-cdk/core';
import * as s3 from '@aws-cdk/aws-s3';
/**
 * The properties for the KinesisFirehoseToS3 class.
 */
export interface KinesisFirehoseToS3Props {
    /**
     * Optional user provided props to override the default props
     *
     * @default - Default props are used
     */
    readonly kinesisFirehoseProps?: kinesisfirehose.CfnDeliveryStreamProps | any;
    /**
     * Whether to create a S3 Bucket or use an existing S3 Bucket.
     * If set to false, you must provide S3 Bucket as `existingBucketObj`
     *
     * @default - true
     */
    readonly deployBucket?: boolean;
    /**
     * Existing instance of S3 Bucket object.
     * If `deployBucket` is set to false only then this property is required
     *
     * @default - None
     */
    readonly existingBucketObj?: s3.Bucket;
    /**
     * Optional user provided props to override the default props.
     * If `deploy` is set to true only then this property is required
     *
     * @default - Default props are used
     */
    readonly bucketProps?: s3.BucketProps;
}
export declare class KinesisFirehoseToS3 extends Construct {
    private firehose;
    private s3Bucket;
    /**
     * Constructs a new instance of the IotToLambda class.
     */
    constructor(scope: Construct, id: string, props: KinesisFirehoseToS3Props);
    /**
     * Returns an instance of kinesisfirehose.CfnDeliveryStream created by the construct
     */
    kinesisFirehose(): kinesisfirehose.CfnDeliveryStream;
    /**
     * Returns an instance of s3.Bucket created by the construct
     */
    bucket(): s3.Bucket;
}
