# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['pelican', 'pelican.plugins.render_math']

package_data = \
{'': ['*'], 'pelican.plugins.render_math': ['test_data/*']}

install_requires = \
['pelican>=4.5,<5.0', 'typogrify>=2.0.7,<3.0.0']

extras_require = \
{'markdown': ['markdown>=3.2.2,<4.0.0']}

setup_kwargs = {
    'name': 'pelican-render-math',
    'version': '1.0.1',
    'description': 'Render mathematics in Pelican site content',
    'long_description': 'Render Math Plugin for Pelican\n==============================\n\n[![Build Status](https://img.shields.io/github/workflow/status/pelican-plugins/render-math/build)](https://github.com/pelican-plugins/render-math/actions) [![PyPI Version](https://img.shields.io/pypi/v/pelican-render-math)](https://pypi.org/project/pelican-render-math/)\n\nThis plugin gives [Pelican][] the ability to render mathematics inside post\ncontent. It accomplishes this by using the [MathJax][] JavaScript engine.\n\nThe plugin also makes [Typogrify][] and recognized math play nicely together by\nensuring [Typogrify][] does not alter math content.\n\nBoth Markdown and reStructuredText are supported.\n\nRequirements\n------------\n\n* [Pelican][] version *4.5* or above is required.\n* [Typogrify][] version *2.0.7* or higher is needed for Typogrify to behave\n  properly with this plugin. If this version is not available, Typogrify will be\n  disabled for the entire site.\n* [BeautifulSoup][] 4+ is required to correct summaries. If BeautifulSoup is not\n  installed, summary processing will be ignored, even if specified in user\n  settings.\n\nInstallation\n------------\n\nThis plugin can be installed via:\n\n    python -m pip install pelican-render-math\n\nYour site should now be capable of rendering math using the MathJax JavaScript\nengine. No alterations to the template are needed — just use and enjoy!\n\nHowever, if you wish, you can set the `auto_insert` setting to `False` which\nwill disable the MathJax script from being automatically inserted into the\ncontent. You would only want to do this if you have control over the template\nand want to insert the script manually.\n\n### Typogrify\n\nIn the past, using [Typogrify][] would alter math content, resulting in math\nthat could not be rendered by [MathJax][]. The only option was to ensure that\n[Typogrify][] was disabled in the settings.\n\nThe problem has been rectified in this plugin, but it requires at a minimum\n[Typogrify][] version 2.0.7 or higher. If this version is not present, the\nplugin will disable Typogrify for the entire site.\n\n### BeautifulSoup\n\nPelican creates summaries by truncating the post content to a specified user\nlength. The truncation process is oblivious to any math and can therefore\ndestroy the math output in the summary.\n\nTo restore math, [BeautifulSoup][] is used. If it is not installed, no summary\nprocessing will happen.\n\nUsage\n-----\n\n### Templates\n\nNo template alteration is needed for this plugin to work. Just install the\nplugin and start writing your math.\n\n### Settings\n\nCertain MathJax rendering options can be set. These options are in a dictionary\nvariable called `MATH_JAX` in the Pelican settings file.\n\nThe dictionary can be set with the following keys:\n\n * `align`: [string] controls how displayed math will be aligned. Can be set to\n   either `\'left\'`, `\'right\'` or `\'center\'`. **Default Value**: `\'center\'`.\n * `auto_insert`: [boolean] will insert the MathJax script into content that it\n   is detected to have math in it. Setting it to false is not recommended.\n   **Default Value**: `True`\n * `indent`: [string] if `align` not set to `\'center\'`, then this controls the\n   indent level. **Default Value**: `\'0em\'`.\n * `show_menu`: [boolean] controls whether the MathJax contextual menu is\n   shown.  **Default Value**: `True`\n * `process_escapes`: [boolean] controls whether MathJax processes escape\n   sequences.  **Default Value**: `True`\n * `MathJax_font`: [string] will force MathJax to use the chosen font. Current\n   choices for the font is `sanserif`, `typewriter` or `fraktur`. If this is\n   not set, it will use the default font settings. **Default Value**: `default`\n * `latex_preview`: [string] controls the preview message users are shown while\n   MathJax is rendering LaTex. If set to `\'Tex\'`, then the TeX code is used as\n   the preview (which will be visible until it is processed by MathJax).\n   **Default Value**: `\'Tex\'`\n * `color`: [string] controls the color of the MathJax rendered font. **Default\n   Value**: `\'inherit\'`\n * `linebreak_automatic`: [boolean] If set, MathJax will try to *intelligently*\n   break up displayed math (Note: It will not work for inline math). This is\n   very useful for a responsive site. It is turned off by default due to it\n   potentially being CPU expensive. **Default Value**: `False`\n * `tex_extensions`: [list] a list of [latex\n   extensions](https://docs.mathjax.org/en/latest/input/tex/extensions.html)\n   accepted by MathJax. **Default Value**: `[]` (empty list)\n * `responsive`: [boolean] tries to make displayed math render responsively. It\n   does by determining if the width is less than `responsive_break` (see below)\n   and if so, sets `align` to `left`, `indent` to `0em` and\n   `linebreak_automatic` to `True`.  **Default Value**: `False` (defaults to\n   `False` for backward compatibility)\n * `responsive_break`: [integer] a number (in pixels) representing the width\n   breakpoint that is used when setting `responsive_align` to `True`. **Default\n   Value**: 768\n * `process_summary`: [boolean] ensures math will render in summaries and fixes\n   math in that were cut off. Requires [BeautifulSoup][] be installed. **Default\n   Value**: `True`\n * `message_style`: [string] This value controls the verbosity of the messages\n   in the lower left-hand corner. Set it to `None` to eliminate all messages.\n   **Default Value**: normal\n\n#### Settings Examples\n\nMake math render in blue and display math aligned to the left:\n\n    MATH_JAX = {\'color\':\'blue\',\'align\':left}\n\nUse the [color](https://docs.mathjax.org/en/latest/input/tex/extensions/color.html)\nand [mhchem](https://docs.mathjax.org/en/latest/input/tex/extensions/mhchem.html)\nextensions:\n\n    MATH_JAX = {\'tex_extensions\': [\'color.js\',\'mhchem.js\']}\n\n#### Resulting HTML\n\nInline math is wrapped in `span` tags, while displayed math is wrapped in\n`div` tags.  These tags will have a class attribute that is set to `math` which\ncan be used by template designers to alter the display of the math.\n\nMarkdown\n--------\n\nThis plugin implements a custom extension for Markdown resulting in math being\na "first class citizen" for Pelican.\n\n### Inline Math\n\nMath between `$`..`$`, for example, `$`x^2`$`, will be rendered inline with\nrespect to the current HTML block. Note: To use inline math, there must *not*\nbe any whitespace before the ending `$`. So for example:\n\n * **Relevant inline math**: `$e=mc^2$`\n * **Will not render as inline math**: `$40 vs $50`\n\n### Displayed Math\n\nMath between `$$`..`$$` will be rendered "block style", for example,\n`$$`x^2`$$`, will be rendered centered in a new paragraph.\n\n#### Other Latex Display Math Commands\n\nThe other LaTeX commands which usually invoke display math mode from text mode\nare supported, and are automatically treated like `$$`-style displayed math in\nthat they are rendered "block" style on their own lines.  For example,\n`\\begin{equation}` x^2 `\\end{equation}`, will be rendered in its own block with\na right justified equation number at the top of the block. This equation number\ncan be referenced in the document.  To do this, use a `label` inside of the\nequation format and then refer to that label using `ref`. For example:\n`\\begin{equation}` `\\label{eq}` X^2 `\\end{equation}`.  Now refer to that\nequation number by `$`\\ref{eq}`$`.\n\nreStructuredText\n----------------\n\nIf there is math detected in reStructuredText content, the plugin will\nautomatically set the\n[math_output](https://docutils.sourceforge.io/docs/user/config.html#math-output)\nconfiguration setting to `mathjax`.\n\n### Inline Math\n\nInline math needs to use the [math\nrole](https://docutils.sourceforge.io/docs/ref/rst/roles.html#math):\n\n```\nThe area of a circle is :math:`A_\\text{c} = (\\pi/4) d^2`.\n```\n\n### Displayed Math\n\nDisplayed math uses the [math block](https://docutils.sourceforge.io/docs/ref/rst/directives.html#math):\n\n```rst\n.. math::\n\n   α_t(i) = P(O_1, O_2, … O_t, q_t = S_i λ)\n```\n\nContributing\n------------\n\nContributions are welcome and much appreciated. Every little bit helps. You can contribute by improving the documentation, adding missing features, and fixing bugs. You can also help out by reviewing and commenting on [existing issues][].\n\nTo start contributing to this plugin, review the [Contributing to Pelican][] documentation, beginning with the **Contributing Code** section.\n\n\n[BeautifulSoup]: https://www.crummy.com/software/BeautifulSoup/\n[MathJax]: https://www.mathjax.org/\n[Pelican]: https://github.com/getpelican/pelican\n[Typogrify]: https://github.com/mintchaos/typogrify\n[existing issues]: https://github.com/pelican-plugins/render-math/issues\n[Contributing to Pelican]: https://docs.getpelican.com/en/latest/contribute.html\n',
    'author': 'Pelican Dev Team',
    'author_email': 'authors@getpelican.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/pelican-plugins/render-math',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
