# AUTOGENERATED! DO NOT EDIT! File to edit: utils.ipynb (unless otherwise specified).

__all__ = ['softmax', 'calc_prob', 'one_hot']

# Cell
import numpy as np

def softmax(x):
    e_x = np.exp(x - np.max(x, axis=-1, keepdims=True))
    return e_x / e_x.sum(axis=-1, keepdims=True)

# Cell
def calc_prob(n=1000, s=2.5, dim=3):
    "s = 'scale': how strongly to 'push' the points towards the ends"
    logits = (np.random.rand(n,dim)*2-1)*s
    prob = softmax(logits)
    targ = np.argmax(prob, axis=1)  # target values
    return prob, targ

# Cell
def one_hot(targs):
    """convert array of single target values to set of one-hot vectors"""
    out = np.zeros((targs.size, targs.max()+1))
    out[np.arange(targs.size),targs] = 1
    return out