from .communicationport import *
from .serialport import SerialPort
from .usbport import USBPort
from .diagnostics import USBParameters, DeviceCommand, USBDeviceDescription
from .debugport import DebugPort
from .echoport import DebugEchoPort
import usb.backend.libusb1
import platform
from pathlib import *
import os

def validateUSBBackend(verbose=False):
    backend = usb.backend.libusb1.get_backend()
    if backend is not None:
        try:
            usb.core.find(backend=backend)
            return backend
        except:
            if verbose:
                print("The default backend search of PyUSB does not find a libusb backend")

    libusbPath = None
    candidates = []
    if platform.system() == 'Windows':
        rootHardwareLibrary = PureWindowsPath(os.path.abspath(__file__)).parents[1]
        candidates = [rootHardwareLibrary.joinpath('communication/libusb/MS64/libusb-1.0.dll'),
                         rootHardwareLibrary.joinpath('communication/libusb/MS32/libusb-1.0.dll')]
    elif platform.system() == 'Darwin':
        rootHardwareLibrary = PurePosixPath(os.path.abspath(__file__)).parents[1]
        candidates = [rootHardwareLibrary.joinpath('communication/libusb/Darwin/libusb-1.0.0.dylib')]
    else:
        if verbose:
            otherDir = rootHardwareLibrary.joinpath('communication/libusb/other')
            print("""Platform not recognized {1} and default PyUSB backend not found. You should try installing libusb.
            If it does not work out of the box, you can try copying the library in the {0} directory""".format(otherDir, platform.system()))
        candidates = os.listdir(otherDir)

    for libpath in candidates:
        if os.path.exists(libpath):
            backend = usb.backend.libusb1.get_backend(find_library=lambda x: "{0}".format(libpath))
            if backend is not None:
                try:
                    usb.core.find(backend=backend)
                    return backend
                except:
                    pass
        else:
            if verbose:
                print("Library candidate {0} does not exist".format(libpath))

    return None

validateUSBBackend()