/*
 * Decompiled with CFR 0.152.
 */
package shaded.alink.kafka011.org.apache.kafka.common.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.alink.kafka011.org.apache.kafka.common.utils.Utils;

public abstract class Shell {
    private static final Logger LOG = LoggerFactory.getLogger(Shell.class);
    private final long timeout;
    private int exitCode;
    private Process process;
    private volatile AtomicBoolean completed;

    protected abstract String[] execString();

    protected abstract void parseExecResult(BufferedReader var1) throws IOException;

    public Shell(long timeout) {
        this.timeout = timeout;
    }

    public int exitCode() {
        return this.exitCode;
    }

    public Process process() {
        return this.process;
    }

    protected void run() throws IOException {
        this.exitCode = 0;
        this.runCommand();
    }

    private void runCommand() throws IOException {
        ProcessBuilder builder = new ProcessBuilder(this.execString());
        Timer timeoutTimer = null;
        this.completed = new AtomicBoolean(false);
        this.process = builder.start();
        if (this.timeout > -1L) {
            timeoutTimer = new Timer();
            timeoutTimer.schedule((TimerTask)new ShellTimeoutTimerTask(this), this.timeout);
        }
        final BufferedReader errReader = new BufferedReader(new InputStreamReader(this.process.getErrorStream(), StandardCharsets.UTF_8));
        BufferedReader inReader = new BufferedReader(new InputStreamReader(this.process.getInputStream(), StandardCharsets.UTF_8));
        final StringBuffer errMsg = new StringBuffer();
        Thread errThread = Utils.newThread("kafka-shell-thread", new Runnable(){

            @Override
            public void run() {
                try {
                    String line = errReader.readLine();
                    while (line != null && !Thread.currentThread().isInterrupted()) {
                        errMsg.append(line);
                        errMsg.append(System.getProperty("line.separator"));
                        line = errReader.readLine();
                    }
                }
                catch (IOException ioe) {
                    LOG.warn("Error reading the error stream", ioe);
                }
            }
        }, false);
        errThread.start();
        try {
            this.parseExecResult(inReader);
            this.exitCode = this.process.waitFor();
            try {
                errThread.join();
            }
            catch (InterruptedException ie) {
                LOG.warn("Interrupted while reading the error stream", ie);
            }
            this.completed.set(true);
            if (this.exitCode != 0) {
                throw new ExitCodeException(this.exitCode, errMsg.toString());
            }
        }
        catch (InterruptedException ie) {
            throw new IOException(ie.toString());
        }
        finally {
            if (timeoutTimer != null) {
                timeoutTimer.cancel();
            }
            try {
                inReader.close();
            }
            catch (IOException ioe) {
                LOG.warn("Error while closing the input stream", ioe);
            }
            if (!this.completed.get()) {
                errThread.interrupt();
            }
            try {
                errReader.close();
            }
            catch (IOException ioe) {
                LOG.warn("Error while closing the error stream", ioe);
            }
            this.process.destroy();
        }
    }

    public static String execCommand(String ... cmd) throws IOException {
        return Shell.execCommand(cmd, -1L);
    }

    public static String execCommand(String[] cmd, long timeout) throws IOException {
        ShellCommandExecutor exec = new ShellCommandExecutor(cmd, timeout);
        exec.execute();
        return exec.output();
    }

    private static class ShellTimeoutTimerTask
    extends TimerTask {
        private final Shell shell;

        public ShellTimeoutTimerTask(Shell shell) {
            this.shell = shell;
        }

        @Override
        public void run() {
            block2: {
                Process p = this.shell.process();
                try {
                    p.exitValue();
                }
                catch (Exception e) {
                    if (p == null || this.shell.completed.get()) break block2;
                    p.destroy();
                }
            }
        }
    }

    public static class ShellCommandExecutor
    extends Shell {
        private final String[] command;
        private StringBuffer output;

        public ShellCommandExecutor(String[] execString, long timeout) {
            super(timeout);
            this.command = (String[])execString.clone();
        }

        public void execute() throws IOException {
            this.run();
        }

        @Override
        protected String[] execString() {
            return this.command;
        }

        @Override
        protected void parseExecResult(BufferedReader reader) throws IOException {
            int nRead;
            this.output = new StringBuffer();
            char[] buf = new char[512];
            while ((nRead = reader.read(buf, 0, buf.length)) > 0) {
                this.output.append(buf, 0, nRead);
            }
        }

        public String output() {
            return this.output == null ? "" : this.output.toString();
        }

        public String toString() {
            String[] args;
            StringBuilder builder = new StringBuilder();
            for (String s : args = this.execString()) {
                if (s.indexOf(32) >= 0) {
                    builder.append('\"').append(s).append('\"');
                } else {
                    builder.append(s);
                }
                builder.append(' ');
            }
            return builder.toString();
        }
    }

    public static class ExitCodeException
    extends IOException {
        int exitCode;

        public ExitCodeException(int exitCode, String message) {
            super(message);
            this.exitCode = exitCode;
        }

        public int getExitCode() {
            return this.exitCode;
        }
    }
}

