/*
 * Decompiled with CFR 0.152.
 */
package shaded.alink.kafka011.org.apache.kafka.clients.consumer.internals;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import shaded.alink.kafka011.org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import shaded.alink.kafka011.org.apache.kafka.clients.consumer.OffsetAndMetadata;
import shaded.alink.kafka011.org.apache.kafka.clients.consumer.OffsetResetStrategy;
import shaded.alink.kafka011.org.apache.kafka.common.TopicPartition;
import shaded.alink.kafka011.org.apache.kafka.common.internals.PartitionStates;
import shaded.alink.kafka011.org.apache.kafka.common.requests.IsolationLevel;

public class SubscriptionState {
    private static final String SUBSCRIPTION_EXCEPTION_MESSAGE = "Subscription to topics, partitions and pattern are mutually exclusive";
    private SubscriptionType subscriptionType;
    private Pattern subscribedPattern;
    private Set<String> subscription;
    private final Set<String> groupSubscription;
    private final PartitionStates<TopicPartitionState> assignment;
    private boolean needsFetchCommittedOffsets;
    private final OffsetResetStrategy defaultResetStrategy;
    private ConsumerRebalanceListener listener;
    private List<Listener> listeners = new ArrayList<Listener>();

    public SubscriptionState(OffsetResetStrategy defaultResetStrategy) {
        this.defaultResetStrategy = defaultResetStrategy;
        this.subscription = Collections.emptySet();
        this.assignment = new PartitionStates();
        this.groupSubscription = new HashSet<String>();
        this.needsFetchCommittedOffsets = true;
        this.subscribedPattern = null;
        this.subscriptionType = SubscriptionType.NONE;
    }

    private void setSubscriptionType(SubscriptionType type) {
        if (this.subscriptionType == SubscriptionType.NONE) {
            this.subscriptionType = type;
        } else if (this.subscriptionType != type) {
            throw new IllegalStateException(SUBSCRIPTION_EXCEPTION_MESSAGE);
        }
    }

    public void subscribe(Set<String> topics, ConsumerRebalanceListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("RebalanceListener cannot be null");
        }
        this.setSubscriptionType(SubscriptionType.AUTO_TOPICS);
        this.listener = listener;
        this.changeSubscription(topics);
    }

    public void subscribeFromPattern(Set<String> topics) {
        if (this.subscriptionType != SubscriptionType.AUTO_PATTERN) {
            throw new IllegalArgumentException("Attempt to subscribe from pattern while subscription type set to " + (Object)((Object)this.subscriptionType));
        }
        this.changeSubscription(topics);
    }

    private void changeSubscription(Set<String> topicsToSubscribe) {
        if (!this.subscription.equals(topicsToSubscribe)) {
            this.subscription = topicsToSubscribe;
            this.groupSubscription.addAll(topicsToSubscribe);
        }
    }

    public void groupSubscribe(Collection<String> topics) {
        if (this.subscriptionType == SubscriptionType.USER_ASSIGNED) {
            throw new IllegalStateException(SUBSCRIPTION_EXCEPTION_MESSAGE);
        }
        this.groupSubscription.addAll(topics);
    }

    public void resetGroupSubscription() {
        this.groupSubscription.retainAll(this.subscription);
    }

    public void assignFromUser(Set<TopicPartition> partitions) {
        this.setSubscriptionType(SubscriptionType.USER_ASSIGNED);
        if (!this.assignment.partitionSet().equals(partitions)) {
            this.fireOnAssignment(partitions);
            HashMap<TopicPartition, TopicPartitionState> partitionToState = new HashMap<TopicPartition, TopicPartitionState>();
            for (TopicPartition partition : partitions) {
                TopicPartitionState state = this.assignment.stateValue(partition);
                if (state == null) {
                    state = new TopicPartitionState();
                }
                partitionToState.put(partition, state);
            }
            this.assignment.set(partitionToState);
            this.needsFetchCommittedOffsets = true;
        }
    }

    public void assignFromSubscribed(Collection<TopicPartition> assignments) {
        if (!this.partitionsAutoAssigned()) {
            throw new IllegalArgumentException("Attempt to dynamically assign partitions while manual assignment in use");
        }
        Map<TopicPartition, TopicPartitionState> assignedPartitionStates = SubscriptionState.partitionToStateMap(assignments);
        this.fireOnAssignment(assignedPartitionStates.keySet());
        if (this.subscribedPattern != null) {
            for (TopicPartition tp : assignments) {
                if (this.subscribedPattern.matcher(tp.topic()).matches()) continue;
                throw new IllegalArgumentException("Assigned partition " + tp + " for non-subscribed topic regex pattern; subscription pattern is " + this.subscribedPattern);
            }
        } else {
            for (TopicPartition tp : assignments) {
                if (this.subscription.contains(tp.topic())) continue;
                throw new IllegalArgumentException("Assigned partition " + tp + " for non-subscribed topic; subscription is " + this.subscription);
            }
        }
        this.assignment.set(assignedPartitionStates);
        this.needsFetchCommittedOffsets = true;
    }

    public void subscribe(Pattern pattern, ConsumerRebalanceListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("RebalanceListener cannot be null");
        }
        this.setSubscriptionType(SubscriptionType.AUTO_PATTERN);
        this.listener = listener;
        this.subscribedPattern = pattern;
    }

    public boolean hasPatternSubscription() {
        return this.subscriptionType == SubscriptionType.AUTO_PATTERN;
    }

    public boolean hasNoSubscriptionOrUserAssignment() {
        return this.subscriptionType == SubscriptionType.NONE;
    }

    public void unsubscribe() {
        this.subscription = Collections.emptySet();
        this.assignment.clear();
        this.subscribedPattern = null;
        this.subscriptionType = SubscriptionType.NONE;
        this.fireOnAssignment(Collections.emptySet());
    }

    public Pattern subscribedPattern() {
        return this.subscribedPattern;
    }

    public Set<String> subscription() {
        return this.subscription;
    }

    public Set<TopicPartition> pausedPartitions() {
        HashSet<TopicPartition> paused = new HashSet<TopicPartition>();
        for (PartitionStates.PartitionState<TopicPartitionState> state : this.assignment.partitionStates()) {
            if (!state.value().paused) continue;
            paused.add(state.topicPartition());
        }
        return paused;
    }

    public Set<String> groupSubscription() {
        return this.groupSubscription;
    }

    private TopicPartitionState assignedState(TopicPartition tp) {
        TopicPartitionState state = this.assignment.stateValue(tp);
        if (state == null) {
            throw new IllegalStateException("No current assignment for partition " + tp);
        }
        return state;
    }

    public void committed(TopicPartition tp, OffsetAndMetadata offset) {
        this.assignedState(tp).committed(offset);
    }

    public OffsetAndMetadata committed(TopicPartition tp) {
        return this.assignedState(tp).committed;
    }

    public void needRefreshCommits() {
        this.needsFetchCommittedOffsets = true;
    }

    public boolean refreshCommitsNeeded() {
        return this.needsFetchCommittedOffsets;
    }

    public void commitsRefreshed() {
        this.needsFetchCommittedOffsets = false;
    }

    public void seek(TopicPartition tp, long offset) {
        this.assignedState(tp).seek(offset);
    }

    public Set<TopicPartition> assignedPartitions() {
        return this.assignment.partitionSet();
    }

    public List<TopicPartition> fetchablePartitions() {
        ArrayList<TopicPartition> fetchable = new ArrayList<TopicPartition>(this.assignment.size());
        for (PartitionStates.PartitionState<TopicPartitionState> state : this.assignment.partitionStates()) {
            if (!state.value().isFetchable()) continue;
            fetchable.add(state.topicPartition());
        }
        return fetchable;
    }

    public boolean partitionsAutoAssigned() {
        return this.subscriptionType == SubscriptionType.AUTO_TOPICS || this.subscriptionType == SubscriptionType.AUTO_PATTERN;
    }

    public void position(TopicPartition tp, long offset) {
        this.assignedState(tp).position(offset);
    }

    public Long position(TopicPartition tp) {
        return this.assignedState(tp).position;
    }

    public Long partitionLag(TopicPartition tp, IsolationLevel isolationLevel) {
        TopicPartitionState topicPartitionState = this.assignedState(tp);
        if (isolationLevel == IsolationLevel.READ_COMMITTED) {
            return topicPartitionState.lastStableOffset == null ? null : Long.valueOf(topicPartitionState.lastStableOffset - topicPartitionState.position);
        }
        return topicPartitionState.highWatermark == null ? null : Long.valueOf(topicPartitionState.highWatermark - topicPartitionState.position);
    }

    public void updateHighWatermark(TopicPartition tp, long highWatermark) {
        this.assignedState(tp).highWatermark = highWatermark;
    }

    public void updateLastStableOffset(TopicPartition tp, long lastStableOffset) {
        this.assignedState(tp).lastStableOffset = lastStableOffset;
    }

    public Map<TopicPartition, OffsetAndMetadata> allConsumed() {
        HashMap<TopicPartition, OffsetAndMetadata> allConsumed = new HashMap<TopicPartition, OffsetAndMetadata>();
        for (PartitionStates.PartitionState<TopicPartitionState> state : this.assignment.partitionStates()) {
            if (!state.value().hasValidPosition()) continue;
            allConsumed.put(state.topicPartition(), new OffsetAndMetadata(state.value().position));
        }
        return allConsumed;
    }

    public void needOffsetReset(TopicPartition partition, OffsetResetStrategy offsetResetStrategy) {
        this.assignedState(partition).awaitReset(offsetResetStrategy);
    }

    public void needOffsetReset(TopicPartition partition) {
        this.needOffsetReset(partition, this.defaultResetStrategy);
    }

    public boolean hasDefaultOffsetResetPolicy() {
        return this.defaultResetStrategy != OffsetResetStrategy.NONE;
    }

    public boolean isOffsetResetNeeded(TopicPartition partition) {
        return this.assignedState(partition).awaitingReset();
    }

    public OffsetResetStrategy resetStrategy(TopicPartition partition) {
        return this.assignedState(partition).resetStrategy;
    }

    public boolean hasAllFetchPositions(Collection<TopicPartition> partitions) {
        for (TopicPartition partition : partitions) {
            if (this.hasValidPosition(partition)) continue;
            return false;
        }
        return true;
    }

    public boolean hasAllFetchPositions() {
        return this.hasAllFetchPositions(this.assignedPartitions());
    }

    public Set<TopicPartition> missingFetchPositions() {
        HashSet<TopicPartition> missing = new HashSet<TopicPartition>();
        for (PartitionStates.PartitionState<TopicPartitionState> state : this.assignment.partitionStates()) {
            if (state.value().hasValidPosition()) continue;
            missing.add(state.topicPartition());
        }
        return missing;
    }

    public boolean isAssigned(TopicPartition tp) {
        return this.assignment.contains(tp);
    }

    public boolean isPaused(TopicPartition tp) {
        return this.isAssigned(tp) && this.assignedState(tp).paused;
    }

    public boolean isFetchable(TopicPartition tp) {
        return this.isAssigned(tp) && this.assignedState(tp).isFetchable();
    }

    public boolean hasValidPosition(TopicPartition tp) {
        return this.isAssigned(tp) && this.assignedState(tp).hasValidPosition();
    }

    public void pause(TopicPartition tp) {
        this.assignedState(tp).pause();
    }

    public void resume(TopicPartition tp) {
        this.assignedState(tp).resume();
    }

    public void movePartitionToEnd(TopicPartition tp) {
        this.assignment.moveToEnd(tp);
    }

    public ConsumerRebalanceListener listener() {
        return this.listener;
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void fireOnAssignment(Set<TopicPartition> assignment) {
        for (Listener listener : this.listeners) {
            listener.onAssignment(assignment);
        }
    }

    private static Map<TopicPartition, TopicPartitionState> partitionToStateMap(Collection<TopicPartition> assignments) {
        HashMap<TopicPartition, TopicPartitionState> map = new HashMap<TopicPartition, TopicPartitionState>(assignments.size());
        for (TopicPartition tp : assignments) {
            map.put(tp, new TopicPartitionState());
        }
        return map;
    }

    public static interface Listener {
        public void onAssignment(Set<TopicPartition> var1);
    }

    private static class TopicPartitionState {
        private Long position = null;
        private Long highWatermark = null;
        private Long lastStableOffset = null;
        private OffsetAndMetadata committed = null;
        private boolean paused = false;
        private OffsetResetStrategy resetStrategy = null;

        private void awaitReset(OffsetResetStrategy strategy) {
            this.resetStrategy = strategy;
            this.position = null;
        }

        public boolean awaitingReset() {
            return this.resetStrategy != null;
        }

        public boolean hasValidPosition() {
            return this.position != null;
        }

        private void seek(long offset) {
            this.position = offset;
            this.resetStrategy = null;
        }

        private void position(long offset) {
            if (!this.hasValidPosition()) {
                throw new IllegalStateException("Cannot set a new position without a valid current position");
            }
            this.position = offset;
        }

        private void committed(OffsetAndMetadata offset) {
            this.committed = offset;
        }

        private void pause() {
            this.paused = true;
        }

        private void resume() {
            this.paused = false;
        }

        private boolean isFetchable() {
            return !this.paused && this.hasValidPosition();
        }
    }

    private static enum SubscriptionType {
        NONE,
        AUTO_TOPICS,
        AUTO_PATTERN,
        USER_ASSIGNED;

    }
}

