/*
 * Decompiled with CFR 0.152.
 */
package shaded.alink.kafka011.org.apache.flink.streaming.connectors.kafka.internals;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.eventtime.WatermarkOutput;
import org.apache.flink.api.common.eventtime.WatermarkOutputMultiplexer;
import org.apache.flink.api.common.eventtime.WatermarkStrategy;
import org.apache.flink.metrics.Gauge;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.streaming.api.functions.source.SourceFunction;
import org.apache.flink.streaming.runtime.tasks.ProcessingTimeCallback;
import org.apache.flink.streaming.runtime.tasks.ProcessingTimeService;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.SerializedValue;
import shaded.alink.kafka011.org.apache.flink.streaming.connectors.kafka.internals.ClosableBlockingQueue;
import shaded.alink.kafka011.org.apache.flink.streaming.connectors.kafka.internals.KafkaCommitCallback;
import shaded.alink.kafka011.org.apache.flink.streaming.connectors.kafka.internals.KafkaTopicPartition;
import shaded.alink.kafka011.org.apache.flink.streaming.connectors.kafka.internals.KafkaTopicPartitionState;
import shaded.alink.kafka011.org.apache.flink.streaming.connectors.kafka.internals.KafkaTopicPartitionStateSentinel;
import shaded.alink.kafka011.org.apache.flink.streaming.connectors.kafka.internals.KafkaTopicPartitionStateWithWatermarkGenerator;
import shaded.alink.kafka011.org.apache.flink.streaming.connectors.kafka.internals.SourceContextWatermarkOutputAdapter;

@Internal
public abstract class AbstractFetcher<T, KPH> {
    private static final int NO_TIMESTAMPS_WATERMARKS = 0;
    private static final int WITH_WATERMARK_GENERATOR = 1;
    protected final SourceFunction.SourceContext<T> sourceContext;
    protected final WatermarkOutput watermarkOutput;
    private final WatermarkOutputMultiplexer watermarkOutputMultiplexer;
    protected final Object checkpointLock;
    private final List<KafkaTopicPartitionState<T, KPH>> subscribedPartitionStates;
    protected final ClosableBlockingQueue<KafkaTopicPartitionState<T, KPH>> unassignedPartitionsQueue;
    private final int timestampWatermarkMode;
    private final SerializedValue<WatermarkStrategy<T>> watermarkStrategy;
    private final ClassLoader userCodeClassLoader;
    private final boolean useMetrics;
    private final MetricGroup consumerMetricGroup;
    @Deprecated
    private final MetricGroup legacyCurrentOffsetsMetricGroup;
    @Deprecated
    private final MetricGroup legacyCommittedOffsetsMetricGroup;

    protected AbstractFetcher(SourceFunction.SourceContext<T> sourceContext, Map<KafkaTopicPartition, Long> seedPartitionsWithInitialOffsets, SerializedValue<WatermarkStrategy<T>> watermarkStrategy, ProcessingTimeService processingTimeProvider, long autoWatermarkInterval, ClassLoader userCodeClassLoader, MetricGroup consumerMetricGroup, boolean useMetrics) throws Exception {
        this.sourceContext = (SourceFunction.SourceContext)Preconditions.checkNotNull(sourceContext);
        this.watermarkOutput = new SourceContextWatermarkOutputAdapter<T>(sourceContext);
        this.watermarkOutputMultiplexer = new WatermarkOutputMultiplexer(this.watermarkOutput);
        this.checkpointLock = sourceContext.getCheckpointLock();
        this.userCodeClassLoader = (ClassLoader)Preconditions.checkNotNull((Object)userCodeClassLoader);
        this.useMetrics = useMetrics;
        this.consumerMetricGroup = (MetricGroup)Preconditions.checkNotNull((Object)consumerMetricGroup);
        this.legacyCurrentOffsetsMetricGroup = consumerMetricGroup.addGroup("current-offsets");
        this.legacyCommittedOffsetsMetricGroup = consumerMetricGroup.addGroup("committed-offsets");
        this.watermarkStrategy = watermarkStrategy;
        this.timestampWatermarkMode = watermarkStrategy == null ? 0 : 1;
        this.unassignedPartitionsQueue = new ClosableBlockingQueue();
        this.subscribedPartitionStates = this.createPartitionStateHolders(seedPartitionsWithInitialOffsets, this.timestampWatermarkMode, watermarkStrategy, userCodeClassLoader);
        for (KafkaTopicPartitionState<T, KPH> partitionState : this.subscribedPartitionStates) {
            if (partitionState.isOffsetDefined()) continue;
            throw new IllegalArgumentException("The fetcher was assigned seed partitions with undefined initial offsets.");
        }
        for (KafkaTopicPartitionState<T, KPH> partition : this.subscribedPartitionStates) {
            this.unassignedPartitionsQueue.add(partition);
        }
        if (useMetrics) {
            this.registerOffsetMetrics(consumerMetricGroup, this.subscribedPartitionStates);
        }
        if (this.timestampWatermarkMode == 1 && autoWatermarkInterval > 0L) {
            PeriodicWatermarkEmitter<T, KPH> periodicEmitter = new PeriodicWatermarkEmitter<T, KPH>(this.checkpointLock, this.subscribedPartitionStates, this.watermarkOutputMultiplexer, processingTimeProvider, autoWatermarkInterval);
            periodicEmitter.start();
        }
    }

    public void addDiscoveredPartitions(List<KafkaTopicPartition> newPartitions) throws IOException, ClassNotFoundException {
        List<KafkaTopicPartitionState<T, KPH>> newPartitionStates = this.createPartitionStateHolders(newPartitions, -915623761775L, this.timestampWatermarkMode, this.watermarkStrategy, this.userCodeClassLoader);
        if (this.useMetrics) {
            this.registerOffsetMetrics(this.consumerMetricGroup, newPartitionStates);
        }
        for (KafkaTopicPartitionState<T, KPH> newPartitionState : newPartitionStates) {
            this.subscribedPartitionStates.add(newPartitionState);
            this.unassignedPartitionsQueue.add(newPartitionState);
        }
    }

    protected final List<KafkaTopicPartitionState<T, KPH>> subscribedPartitionStates() {
        return this.subscribedPartitionStates;
    }

    public abstract void runFetchLoop() throws Exception;

    public abstract void cancel();

    public final void commitInternalOffsetsToKafka(Map<KafkaTopicPartition, Long> offsets, @Nonnull KafkaCommitCallback commitCallback) throws Exception {
        this.doCommitInternalOffsetsToKafka(this.filterOutSentinels(offsets), commitCallback);
    }

    protected abstract void doCommitInternalOffsetsToKafka(Map<KafkaTopicPartition, Long> var1, @Nonnull KafkaCommitCallback var2) throws Exception;

    private Map<KafkaTopicPartition, Long> filterOutSentinels(Map<KafkaTopicPartition, Long> offsets) {
        return offsets.entrySet().stream().filter(entry -> !KafkaTopicPartitionStateSentinel.isSentinel((Long)entry.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    protected abstract KPH createKafkaPartitionHandle(KafkaTopicPartition var1);

    public HashMap<KafkaTopicPartition, Long> snapshotCurrentState() {
        assert (Thread.holdsLock(this.checkpointLock));
        HashMap<KafkaTopicPartition, Long> state = new HashMap<KafkaTopicPartition, Long>(this.subscribedPartitionStates.size());
        for (KafkaTopicPartitionState<T, KPH> partition : this.subscribedPartitionStates) {
            state.put(partition.getKafkaTopicPartition(), partition.getOffset());
        }
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void emitRecordsWithTimestamps(Queue<T> records, KafkaTopicPartitionState<T, KPH> partitionState, long offset, long kafkaEventTimestamp) {
        Object object = this.checkpointLock;
        synchronized (object) {
            T record;
            while ((record = records.poll()) != null) {
                long timestamp = partitionState.extractTimestamp(record, kafkaEventTimestamp);
                this.sourceContext.collectWithTimestamp(record, timestamp);
                partitionState.onEvent(record, timestamp);
            }
            partitionState.setOffset(offset);
        }
    }

    private List<KafkaTopicPartitionState<T, KPH>> createPartitionStateHolders(Map<KafkaTopicPartition, Long> partitionsToInitialOffsets, int timestampWatermarkMode, SerializedValue<WatermarkStrategy<T>> watermarkStrategy, ClassLoader userCodeClassLoader) throws IOException, ClassNotFoundException {
        CopyOnWriteArrayList<KafkaTopicPartitionState<T, KPH>> partitionStates = new CopyOnWriteArrayList<KafkaTopicPartitionState<T, KPH>>();
        switch (timestampWatermarkMode) {
            case 0: {
                for (Map.Entry<KafkaTopicPartition, Long> partitionEntry : partitionsToInitialOffsets.entrySet()) {
                    KPH kafkaHandle = this.createKafkaPartitionHandle(partitionEntry.getKey());
                    KafkaTopicPartitionState partitionState = new KafkaTopicPartitionState(partitionEntry.getKey(), kafkaHandle);
                    partitionState.setOffset(partitionEntry.getValue());
                    partitionStates.add(partitionState);
                }
                return partitionStates;
            }
            case 1: {
                for (Map.Entry<KafkaTopicPartition, Long> partitionEntry : partitionsToInitialOffsets.entrySet()) {
                    KafkaTopicPartition kafkaTopicPartition = partitionEntry.getKey();
                    KPH kafkaHandle = this.createKafkaPartitionHandle(kafkaTopicPartition);
                    WatermarkStrategy deserializedWatermarkStrategy = (WatermarkStrategy)watermarkStrategy.deserializeValue(userCodeClassLoader);
                    String partitionId = kafkaTopicPartition.getTopic() + '-' + kafkaTopicPartition.getPartition();
                    this.watermarkOutputMultiplexer.registerNewOutput(partitionId);
                    WatermarkOutput immediateOutput = this.watermarkOutputMultiplexer.getImmediateOutput(partitionId);
                    WatermarkOutput deferredOutput = this.watermarkOutputMultiplexer.getDeferredOutput(partitionId);
                    KafkaTopicPartitionStateWithWatermarkGenerator partitionState = new KafkaTopicPartitionStateWithWatermarkGenerator(partitionEntry.getKey(), kafkaHandle, deserializedWatermarkStrategy.createTimestampAssigner(() -> this.consumerMetricGroup), deserializedWatermarkStrategy.createWatermarkGenerator(() -> this.consumerMetricGroup), immediateOutput, deferredOutput);
                    partitionState.setOffset(partitionEntry.getValue());
                    partitionStates.add(partitionState);
                }
                return partitionStates;
            }
        }
        throw new RuntimeException();
    }

    private List<KafkaTopicPartitionState<T, KPH>> createPartitionStateHolders(List<KafkaTopicPartition> partitions, long initialOffset, int timestampWatermarkMode, SerializedValue<WatermarkStrategy<T>> watermarkStrategy, ClassLoader userCodeClassLoader) throws IOException, ClassNotFoundException {
        HashMap<KafkaTopicPartition, Long> partitionsToInitialOffset = new HashMap<KafkaTopicPartition, Long>(partitions.size());
        for (KafkaTopicPartition partition : partitions) {
            partitionsToInitialOffset.put(partition, initialOffset);
        }
        return this.createPartitionStateHolders(partitionsToInitialOffset, timestampWatermarkMode, watermarkStrategy, userCodeClassLoader);
    }

    private void registerOffsetMetrics(MetricGroup consumerMetricGroup, List<KafkaTopicPartitionState<T, KPH>> partitionOffsetStates) {
        for (KafkaTopicPartitionState<T, KPH> ktp : partitionOffsetStates) {
            MetricGroup topicPartitionGroup = consumerMetricGroup.addGroup("topic", ktp.getTopic()).addGroup("partition", Integer.toString(ktp.getPartition()));
            topicPartitionGroup.gauge("currentOffsets", (Gauge)new OffsetGauge(ktp, OffsetGaugeType.CURRENT_OFFSET));
            topicPartitionGroup.gauge("committedOffsets", (Gauge)new OffsetGauge(ktp, OffsetGaugeType.COMMITTED_OFFSET));
            this.legacyCurrentOffsetsMetricGroup.gauge(AbstractFetcher.getLegacyOffsetsMetricsGaugeName(ktp), (Gauge)new OffsetGauge(ktp, OffsetGaugeType.CURRENT_OFFSET));
            this.legacyCommittedOffsetsMetricGroup.gauge(AbstractFetcher.getLegacyOffsetsMetricsGaugeName(ktp), (Gauge)new OffsetGauge(ktp, OffsetGaugeType.COMMITTED_OFFSET));
        }
    }

    private static String getLegacyOffsetsMetricsGaugeName(KafkaTopicPartitionState<?, ?> ktp) {
        return ktp.getTopic() + "-" + ktp.getPartition();
    }

    private static class PeriodicWatermarkEmitter<T, KPH>
    implements ProcessingTimeCallback {
        private final Object checkpointLock;
        private final List<KafkaTopicPartitionState<T, KPH>> allPartitions;
        private final WatermarkOutputMultiplexer watermarkOutputMultiplexer;
        private final ProcessingTimeService timerService;
        private final long interval;

        PeriodicWatermarkEmitter(Object checkpointLock, List<KafkaTopicPartitionState<T, KPH>> allPartitions, WatermarkOutputMultiplexer watermarkOutputMultiplexer, ProcessingTimeService timerService, long autoWatermarkInterval) {
            this.checkpointLock = checkpointLock;
            this.allPartitions = (List)Preconditions.checkNotNull(allPartitions);
            this.watermarkOutputMultiplexer = watermarkOutputMultiplexer;
            this.timerService = (ProcessingTimeService)Preconditions.checkNotNull((Object)timerService);
            this.interval = autoWatermarkInterval;
        }

        public void start() {
            this.timerService.registerTimer(this.timerService.getCurrentProcessingTime() + this.interval, (ProcessingTimeCallback)this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onProcessingTime(long timestamp) {
            Object object = this.checkpointLock;
            synchronized (object) {
                for (KafkaTopicPartitionState<T, KPH> state : this.allPartitions) {
                    state.onPeriodicEmit();
                }
                this.watermarkOutputMultiplexer.onPeriodicEmit();
            }
            this.timerService.registerTimer(this.timerService.getCurrentProcessingTime() + this.interval, (ProcessingTimeCallback)this);
        }
    }

    private static class OffsetGauge
    implements Gauge<Long> {
        private final KafkaTopicPartitionState<?, ?> ktp;
        private final OffsetGaugeType gaugeType;

        OffsetGauge(KafkaTopicPartitionState<?, ?> ktp, OffsetGaugeType gaugeType) {
            this.ktp = ktp;
            this.gaugeType = gaugeType;
        }

        public Long getValue() {
            switch (this.gaugeType) {
                case COMMITTED_OFFSET: {
                    return this.ktp.getCommittedOffset();
                }
                case CURRENT_OFFSET: {
                    return this.ktp.getOffset();
                }
            }
            throw new RuntimeException("Unknown gauge type: " + (Object)((Object)this.gaugeType));
        }
    }

    private static enum OffsetGaugeType {
        CURRENT_OFFSET,
        COMMITTED_OFFSET;

    }
}

