/*
 * Decompiled with CFR 0.152.
 */
package shaded.alink.kafka011.org.apache.flink.streaming.connectors.kafka;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.descriptors.DescriptorProperties;
import org.apache.flink.table.descriptors.KafkaValidator;
import org.apache.flink.table.descriptors.SchemaValidator;
import org.apache.flink.table.factories.DeserializationSchemaFactory;
import org.apache.flink.table.factories.SerializationSchemaFactory;
import org.apache.flink.table.factories.StreamTableSinkFactory;
import org.apache.flink.table.factories.StreamTableSourceFactory;
import org.apache.flink.table.factories.TableFactoryService;
import org.apache.flink.table.sinks.StreamTableSink;
import org.apache.flink.table.sources.RowtimeAttributeDescriptor;
import org.apache.flink.table.sources.StreamTableSource;
import org.apache.flink.table.utils.TableSchemaUtils;
import org.apache.flink.types.Row;
import org.apache.flink.util.InstantiationUtil;
import shaded.alink.kafka011.org.apache.flink.streaming.connectors.kafka.KafkaTableSinkBase;
import shaded.alink.kafka011.org.apache.flink.streaming.connectors.kafka.KafkaTableSourceBase;
import shaded.alink.kafka011.org.apache.flink.streaming.connectors.kafka.config.StartupMode;
import shaded.alink.kafka011.org.apache.flink.streaming.connectors.kafka.internals.KafkaTopicPartition;
import shaded.alink.kafka011.org.apache.flink.streaming.connectors.kafka.partitioner.FlinkFixedPartitioner;
import shaded.alink.kafka011.org.apache.flink.streaming.connectors.kafka.partitioner.FlinkKafkaPartitioner;

public abstract class KafkaTableSourceSinkFactoryBase
implements StreamTableSourceFactory<Row>,
StreamTableSinkFactory<Row> {
    public Map<String, String> requiredContext() {
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("connector.type", "kafka");
        context.put("connector.version", this.kafkaVersion());
        context.put("connector.property-version", "1");
        return context;
    }

    public List<String> supportedProperties() {
        ArrayList<String> properties = new ArrayList<String>();
        properties.add("update-mode");
        properties.add("connector.topic");
        properties.add("connector.properties");
        properties.add("connector.properties.#.key");
        properties.add("connector.properties.#.value");
        properties.add("connector.properties.*");
        properties.add("connector.startup-mode");
        properties.add("connector.specific-offsets");
        properties.add("connector.specific-offsets.#.partition");
        properties.add("connector.specific-offsets.#.offset");
        properties.add("connector.startup-timestamp-millis");
        properties.add("connector.sink-partitioner");
        properties.add("connector.sink-partitioner-class");
        properties.add("schema.#.data-type");
        properties.add("schema.#.type");
        properties.add("schema.#.name");
        properties.add("schema.#.from");
        properties.add("schema.#.expr");
        properties.add("schema.#.proctime");
        properties.add("schema.#.rowtime.timestamps.type");
        properties.add("schema.#.rowtime.timestamps.from");
        properties.add("schema.#.rowtime.timestamps.class");
        properties.add("schema.#.rowtime.timestamps.serialized");
        properties.add("schema.#.rowtime.watermarks.type");
        properties.add("schema.#.rowtime.watermarks.class");
        properties.add("schema.#.rowtime.watermarks.serialized");
        properties.add("schema.#.rowtime.watermarks.delay");
        properties.add("schema.watermark.#.rowtime");
        properties.add("schema.watermark.#.strategy.expr");
        properties.add("schema.watermark.#.strategy.data-type");
        properties.add("schema.primary-key.name");
        properties.add("schema.primary-key.columns");
        properties.add("format.*");
        return properties;
    }

    public StreamTableSource<Row> createStreamTableSource(Map<String, String> properties) {
        DescriptorProperties descriptorProperties = this.getValidatedProperties(properties);
        String topic = descriptorProperties.getString("connector.topic");
        DeserializationSchema<Row> deserializationSchema = this.getDeserializationSchema(properties);
        StartupOptions startupOptions = this.getStartupOptions(descriptorProperties, topic);
        return this.createKafkaTableSource(TableSchemaUtils.getPhysicalSchema((TableSchema)descriptorProperties.getTableSchema("schema")), SchemaValidator.deriveProctimeAttribute((DescriptorProperties)descriptorProperties), SchemaValidator.deriveRowtimeAttributes((DescriptorProperties)descriptorProperties), SchemaValidator.deriveFieldMapping((DescriptorProperties)descriptorProperties, Optional.of(deserializationSchema.getProducedType())), topic, this.getKafkaProperties(descriptorProperties), deserializationSchema, startupOptions.startupMode, startupOptions.specificOffsets, startupOptions.startupTimestampMillis);
    }

    public StreamTableSink<Row> createStreamTableSink(Map<String, String> properties) {
        DescriptorProperties descriptorProperties = this.getValidatedProperties(properties);
        TableSchema schema = TableSchemaUtils.getPhysicalSchema((TableSchema)descriptorProperties.getTableSchema("schema"));
        String topic = descriptorProperties.getString("connector.topic");
        Optional proctime = SchemaValidator.deriveProctimeAttribute((DescriptorProperties)descriptorProperties);
        List rowtimeAttributeDescriptors = SchemaValidator.deriveRowtimeAttributes((DescriptorProperties)descriptorProperties);
        if (proctime.isPresent() || !rowtimeAttributeDescriptors.isEmpty() || this.checkForCustomFieldMapping(descriptorProperties, schema)) {
            throw new TableException("Time attributes and custom field mappings are not supported yet.");
        }
        return this.createKafkaTableSink(schema, topic, this.getKafkaProperties(descriptorProperties), this.getFlinkKafkaPartitioner(descriptorProperties), this.getSerializationSchema(properties));
    }

    protected abstract String kafkaVersion();

    protected abstract boolean supportsKafkaTimestamps();

    protected abstract KafkaTableSourceBase createKafkaTableSource(TableSchema var1, Optional<String> var2, List<RowtimeAttributeDescriptor> var3, Map<String, String> var4, String var5, Properties var6, DeserializationSchema<Row> var7, StartupMode var8, Map<KafkaTopicPartition, Long> var9, long var10);

    protected abstract KafkaTableSinkBase createKafkaTableSink(TableSchema var1, String var2, Properties var3, Optional<FlinkKafkaPartitioner<Row>> var4, SerializationSchema<Row> var5);

    private DescriptorProperties getValidatedProperties(Map<String, String> properties) {
        DescriptorProperties descriptorProperties = new DescriptorProperties(true);
        descriptorProperties.putProperties(properties);
        new SchemaValidator(true, this.supportsKafkaTimestamps(), false).validate(descriptorProperties);
        new KafkaValidator().validate(descriptorProperties);
        return descriptorProperties;
    }

    private DeserializationSchema<Row> getDeserializationSchema(Map<String, String> properties) {
        DeserializationSchemaFactory formatFactory = (DeserializationSchemaFactory)TableFactoryService.find(DeserializationSchemaFactory.class, properties, (ClassLoader)this.getClass().getClassLoader());
        return formatFactory.createDeserializationSchema(properties);
    }

    private SerializationSchema<Row> getSerializationSchema(Map<String, String> properties) {
        SerializationSchemaFactory formatFactory = (SerializationSchemaFactory)TableFactoryService.find(SerializationSchemaFactory.class, properties, (ClassLoader)this.getClass().getClassLoader());
        return formatFactory.createSerializationSchema(properties);
    }

    private Properties getKafkaProperties(DescriptorProperties descriptorProperties) {
        Properties kafkaProperties = new Properties();
        if (KafkaValidator.hasConciseKafkaProperties(descriptorProperties)) {
            descriptorProperties.asMap().keySet().stream().filter(key -> key.startsWith("connector.properties")).forEach(key -> {
                String value = descriptorProperties.getString(key);
                String subKey = key.substring("connector.properties.".length());
                kafkaProperties.put(subKey, value);
            });
        } else {
            List propsList = descriptorProperties.getFixedIndexedProperties("connector.properties", Arrays.asList("key", "value"));
            propsList.forEach(kv -> kafkaProperties.put(descriptorProperties.getString((String)kv.get("key")), descriptorProperties.getString((String)kv.get("value"))));
        }
        return kafkaProperties;
    }

    private StartupOptions getStartupOptions(DescriptorProperties descriptorProperties, String topic) {
        HashMap specificOffsets = new HashMap();
        StartupMode startupMode = descriptorProperties.getOptionalString("connector.startup-mode").map(modeString -> {
            switch (modeString) {
                case "earliest-offset": {
                    return StartupMode.EARLIEST;
                }
                case "latest-offset": {
                    return StartupMode.LATEST;
                }
                case "group-offsets": {
                    return StartupMode.GROUP_OFFSETS;
                }
                case "specific-offsets": {
                    this.buildSpecificOffsets(descriptorProperties, topic, specificOffsets);
                    return StartupMode.SPECIFIC_OFFSETS;
                }
                case "timestamp": {
                    return StartupMode.TIMESTAMP;
                }
            }
            throw new TableException("Unsupported startup mode. Validator should have checked that.");
        }).orElse(StartupMode.GROUP_OFFSETS);
        StartupOptions options = new StartupOptions();
        options.startupMode = startupMode;
        options.specificOffsets = specificOffsets;
        if (startupMode == StartupMode.TIMESTAMP) {
            options.startupTimestampMillis = descriptorProperties.getLong("connector.startup-timestamp-millis");
        }
        return options;
    }

    private void buildSpecificOffsets(DescriptorProperties descriptorProperties, String topic, Map<KafkaTopicPartition, Long> specificOffsets) {
        if (descriptorProperties.containsKey("connector.specific-offsets")) {
            Map<Integer, Long> offsetMap = KafkaValidator.validateAndParseSpecificOffsetsString(descriptorProperties);
            offsetMap.forEach((partition, offset) -> {
                KafkaTopicPartition topicPartition = new KafkaTopicPartition(topic, (int)partition);
                specificOffsets.put(topicPartition, (Long)offset);
            });
        } else {
            List offsetList = descriptorProperties.getFixedIndexedProperties("connector.specific-offsets", Arrays.asList("partition", "offset"));
            offsetList.forEach(kv -> {
                int partition = descriptorProperties.getInt((String)kv.get("partition"));
                long offset = descriptorProperties.getLong((String)kv.get("offset"));
                KafkaTopicPartition topicPartition = new KafkaTopicPartition(topic, partition);
                specificOffsets.put(topicPartition, offset);
            });
        }
    }

    private Optional<FlinkKafkaPartitioner<Row>> getFlinkKafkaPartitioner(DescriptorProperties descriptorProperties) {
        return descriptorProperties.getOptionalString("connector.sink-partitioner").flatMap(partitionerString -> {
            switch (partitionerString) {
                case "fixed": {
                    return Optional.of(new FlinkFixedPartitioner());
                }
                case "round-robin": {
                    return Optional.empty();
                }
                case "custom": {
                    Class partitionerClass = descriptorProperties.getClass("connector.sink-partitioner-class", FlinkKafkaPartitioner.class);
                    return Optional.of((FlinkKafkaPartitioner)InstantiationUtil.instantiate((Class)partitionerClass));
                }
            }
            throw new TableException("Unsupported sink partitioner. Validator should have checked that.");
        });
    }

    private boolean checkForCustomFieldMapping(DescriptorProperties descriptorProperties, TableSchema schema) {
        Map fieldMapping = SchemaValidator.deriveFieldMapping((DescriptorProperties)descriptorProperties, Optional.of(schema.toRowType()));
        return fieldMapping.size() != schema.getFieldNames().length || !fieldMapping.entrySet().stream().allMatch(mapping -> ((String)mapping.getKey()).equals(mapping.getValue()));
    }

    private static class StartupOptions {
        private StartupMode startupMode;
        private Map<KafkaTopicPartition, Long> specificOffsets;
        private long startupTimestampMillis;

        private StartupOptions() {
        }
    }
}

