/*
 * Decompiled with CFR 0.152.
 */
package shaded.alink.kafka010.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import shaded.alink.kafka010.org.apache.kafka.common.protocol.ApiKeys;
import shaded.alink.kafka010.org.apache.kafka.common.protocol.ProtoUtils;
import shaded.alink.kafka010.org.apache.kafka.common.protocol.types.Schema;
import shaded.alink.kafka010.org.apache.kafka.common.protocol.types.Struct;
import shaded.alink.kafka010.org.apache.kafka.common.requests.AbstractResponse;

public class SaslHandshakeResponse
extends AbstractResponse {
    private static final Schema CURRENT_SCHEMA = ProtoUtils.currentResponseSchema(ApiKeys.SASL_HANDSHAKE.id);
    private static final String ERROR_CODE_KEY_NAME = "error_code";
    private static final String ENABLED_MECHANISMS_KEY_NAME = "enabled_mechanisms";
    private final short errorCode;
    private final List<String> enabledMechanisms;

    public SaslHandshakeResponse(short errorCode, Collection<String> enabledMechanisms) {
        super(new Struct(CURRENT_SCHEMA));
        this.struct.set(ERROR_CODE_KEY_NAME, (Object)errorCode);
        this.struct.set(ENABLED_MECHANISMS_KEY_NAME, (Object)enabledMechanisms.toArray());
        this.errorCode = errorCode;
        this.enabledMechanisms = new ArrayList<String>(enabledMechanisms);
    }

    public SaslHandshakeResponse(Struct struct) {
        super(struct);
        this.errorCode = struct.getShort(ERROR_CODE_KEY_NAME);
        Object[] mechanisms = struct.getArray(ENABLED_MECHANISMS_KEY_NAME);
        ArrayList<String> enabledMechanisms = new ArrayList<String>();
        for (Object mechanism : mechanisms) {
            enabledMechanisms.add((String)mechanism);
        }
        this.enabledMechanisms = enabledMechanisms;
    }

    public short errorCode() {
        return this.errorCode;
    }

    public List<String> enabledMechanisms() {
        return this.enabledMechanisms;
    }

    public static SaslHandshakeResponse parse(ByteBuffer buffer) {
        return new SaslHandshakeResponse(CURRENT_SCHEMA.read(buffer));
    }

    public static SaslHandshakeResponse parse(ByteBuffer buffer, int version) {
        return new SaslHandshakeResponse(ProtoUtils.parseResponse(ApiKeys.SASL_HANDSHAKE.id, version, buffer));
    }
}

