/*
 * Decompiled with CFR 0.152.
 */
package shaded.alink.kafka010.org.apache.kafka.common.record;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.GatheringByteChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.alink.kafka010.org.apache.kafka.common.TopicPartition;
import shaded.alink.kafka010.org.apache.kafka.common.record.AbstractRecords;
import shaded.alink.kafka010.org.apache.kafka.common.record.BufferSupplier;
import shaded.alink.kafka010.org.apache.kafka.common.record.ByteBufferLogInputStream;
import shaded.alink.kafka010.org.apache.kafka.common.record.ByteBufferOutputStream;
import shaded.alink.kafka010.org.apache.kafka.common.record.CompressionType;
import shaded.alink.kafka010.org.apache.kafka.common.record.LogEntry;
import shaded.alink.kafka010.org.apache.kafka.common.record.MemoryRecordsBuilder;
import shaded.alink.kafka010.org.apache.kafka.common.record.Record;
import shaded.alink.kafka010.org.apache.kafka.common.record.RecordsIterator;
import shaded.alink.kafka010.org.apache.kafka.common.record.TimestampType;

public class MemoryRecords
extends AbstractRecords {
    private static final Logger log = LoggerFactory.getLogger(MemoryRecords.class);
    public static final MemoryRecords EMPTY = MemoryRecords.readableRecords(ByteBuffer.allocate(0));
    private final ByteBuffer buffer;
    private final Iterable<ByteBufferLogInputStream.ByteBufferLogEntry> shallowEntries = new Iterable<ByteBufferLogInputStream.ByteBufferLogEntry>(){

        @Override
        public Iterator<ByteBufferLogInputStream.ByteBufferLogEntry> iterator() {
            return MemoryRecords.this.shallowIterator();
        }
    };
    private int validBytes = -1;

    private MemoryRecords(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    @Override
    public int sizeInBytes() {
        return this.buffer.limit();
    }

    @Override
    public long writeTo(GatheringByteChannel channel, long position, int length) throws IOException {
        if (position > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("position should not be greater than Integer.MAX_VALUE: " + position);
        }
        if (position + (long)length > (long)this.buffer.limit()) {
            throw new IllegalArgumentException("position+length should not be greater than buffer.limit(), position: " + position + ", length: " + length + ", buffer.limit(): " + this.buffer.limit());
        }
        int pos = (int)position;
        ByteBuffer dup = this.buffer.duplicate();
        dup.position(pos);
        dup.limit(pos + length);
        return channel.write(dup);
    }

    public int writeFullyTo(GatheringByteChannel channel) throws IOException {
        int written;
        this.buffer.mark();
        for (written = 0; written < this.sizeInBytes(); written += channel.write(this.buffer)) {
        }
        this.buffer.reset();
        return written;
    }

    public int validBytes() {
        if (this.validBytes >= 0) {
            return this.validBytes;
        }
        int bytes = 0;
        for (LogEntry logEntry : this.shallowEntries()) {
            bytes += logEntry.sizeInBytes();
        }
        this.validBytes = bytes;
        return bytes;
    }

    public FilterResult filterTo(TopicPartition partition, LogEntryFilter filter, ByteBuffer destinationBuffer, int maxRecordSize) {
        return MemoryRecords.filterTo(partition, this.shallowEntries(), filter, destinationBuffer, maxRecordSize);
    }

    private static FilterResult filterTo(TopicPartition partition, Iterable<ByteBufferLogInputStream.ByteBufferLogEntry> fromShallowEntries, LogEntryFilter filter, ByteBuffer destinationBuffer, int maxRecordSize) {
        long maxTimestamp = -1L;
        long maxOffset = -1L;
        long shallowOffsetOfMaxTimestamp = -1L;
        int messagesRead = 0;
        int bytesRead = 0;
        int messagesRetained = 0;
        int bytesRetained = 0;
        ByteBufferOutputStream bufferOutputStream = new ByteBufferOutputStream(destinationBuffer);
        for (ByteBufferLogInputStream.ByteBufferLogEntry shallowEntry : fromShallowEntries) {
            ByteBuffer outputBuffer;
            bytesRead += shallowEntry.sizeInBytes();
            Record shallowRecord = shallowEntry.record();
            byte shallowMagic = shallowRecord.magic();
            boolean writeOriginalEntry = true;
            ArrayList<LogEntry> retainedEntries = new ArrayList<LogEntry>();
            for (LogEntry deepEntry : shallowEntry) {
                Record deepRecord = deepEntry.record();
                ++messagesRead;
                if (filter.shouldRetain(deepEntry)) {
                    if (shallowMagic != deepRecord.magic()) {
                        writeOriginalEntry = false;
                    }
                    if (deepEntry.offset() > maxOffset) {
                        maxOffset = deepEntry.offset();
                    }
                    retainedEntries.add(deepEntry);
                    continue;
                }
                writeOriginalEntry = false;
            }
            if (writeOriginalEntry) {
                bufferOutputStream.write(shallowEntry.buffer());
                messagesRetained += retainedEntries.size();
                bytesRetained += shallowEntry.sizeInBytes();
                if (shallowRecord.timestamp() > maxTimestamp) {
                    maxTimestamp = shallowRecord.timestamp();
                    shallowOffsetOfMaxTimestamp = shallowEntry.offset();
                }
            } else if (!retainedEntries.isEmpty()) {
                LogEntry firstEntry = (LogEntry)retainedEntries.iterator().next();
                long firstOffset = firstEntry.offset();
                byte magic = firstEntry.record().magic();
                MemoryRecordsBuilder builder = new MemoryRecordsBuilder(bufferOutputStream, magic, shallowRecord.compressionType(), shallowRecord.timestampType(), firstOffset, shallowRecord.timestamp(), bufferOutputStream.buffer().remaining());
                for (LogEntry entry : retainedEntries) {
                    builder.appendWithOffset(entry.offset(), entry.record());
                }
                MemoryRecords records = builder.build();
                int filteredSizeInBytes = records.sizeInBytes();
                messagesRetained += retainedEntries.size();
                bytesRetained += records.sizeInBytes();
                if (filteredSizeInBytes > shallowEntry.sizeInBytes() && filteredSizeInBytes > maxRecordSize) {
                    log.warn("Record batch from {} with first offset {} exceeded max record size {} after cleaning (new size is {}). Consumers with version earlier than 0.10.1.0 may need to increase their fetch sizes.", partition, firstOffset, maxRecordSize, filteredSizeInBytes);
                }
                MemoryRecordsBuilder.RecordsInfo info = builder.info();
                if (info.maxTimestamp > maxTimestamp) {
                    maxTimestamp = info.maxTimestamp;
                    shallowOffsetOfMaxTimestamp = info.shallowOffsetOfMaxTimestamp;
                }
            }
            if ((outputBuffer = bufferOutputStream.buffer()) == destinationBuffer) continue;
            return new FilterResult(outputBuffer, messagesRead, bytesRead, messagesRetained, bytesRetained, maxOffset, maxTimestamp, shallowOffsetOfMaxTimestamp);
        }
        return new FilterResult(destinationBuffer, messagesRead, bytesRead, messagesRetained, bytesRetained, maxOffset, maxTimestamp, shallowOffsetOfMaxTimestamp);
    }

    public ByteBuffer buffer() {
        return this.buffer.duplicate();
    }

    public Iterable<ByteBufferLogInputStream.ByteBufferLogEntry> shallowEntries() {
        return this.shallowEntries;
    }

    private Iterator<ByteBufferLogInputStream.ByteBufferLogEntry> shallowIterator() {
        return RecordsIterator.shallowIterator(new ByteBufferLogInputStream(this.buffer.duplicate(), Integer.MAX_VALUE));
    }

    @Override
    public Iterable<LogEntry> deepEntries(BufferSupplier bufferSupplier) {
        return this.deepEntries(false, bufferSupplier);
    }

    @Override
    public Iterable<LogEntry> deepEntries() {
        return this.deepEntries(false, BufferSupplier.NO_CACHING);
    }

    public Iterable<LogEntry> deepEntries(final boolean ensureMatchingMagic, final BufferSupplier bufferSupplier) {
        return new Iterable<LogEntry>(){

            @Override
            public Iterator<LogEntry> iterator() {
                return MemoryRecords.this.deepIterator(ensureMatchingMagic, Integer.MAX_VALUE, bufferSupplier);
            }
        };
    }

    private Iterator<LogEntry> deepIterator(boolean ensureMatchingMagic, int maxMessageSize, BufferSupplier bufferSupplier) {
        return new RecordsIterator(new ByteBufferLogInputStream(this.buffer.duplicate(), maxMessageSize), false, ensureMatchingMagic, maxMessageSize, bufferSupplier);
    }

    public String toString() {
        Iterator<LogEntry> iter = this.deepEntries(BufferSupplier.NO_CACHING).iterator();
        StringBuilder builder = new StringBuilder();
        builder.append('[');
        while (iter.hasNext()) {
            LogEntry entry = iter.next();
            builder.append('(');
            builder.append("offset=");
            builder.append(entry.offset());
            builder.append(",");
            builder.append("record=");
            builder.append(entry.record());
            builder.append(")");
            if (!iter.hasNext()) continue;
            builder.append(", ");
        }
        builder.append(']');
        return builder.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MemoryRecords that = (MemoryRecords)o;
        return this.buffer.equals(that.buffer);
    }

    public int hashCode() {
        return this.buffer.hashCode();
    }

    public static MemoryRecordsBuilder builder(ByteBuffer buffer, CompressionType compressionType, TimestampType timestampType, int writeLimit) {
        return new MemoryRecordsBuilder(buffer, 1, compressionType, timestampType, 0L, System.currentTimeMillis(), writeLimit);
    }

    public static MemoryRecordsBuilder builder(ByteBuffer buffer, byte magic, CompressionType compressionType, TimestampType timestampType, long baseOffset, long logAppendTime) {
        return new MemoryRecordsBuilder(buffer, magic, compressionType, timestampType, baseOffset, logAppendTime, buffer.capacity());
    }

    public static MemoryRecordsBuilder builder(ByteBuffer buffer, CompressionType compressionType, TimestampType timestampType) {
        return MemoryRecords.builder(buffer, compressionType, timestampType, buffer.capacity());
    }

    public static MemoryRecordsBuilder builder(ByteBuffer buffer, byte magic, CompressionType compressionType, TimestampType timestampType) {
        return MemoryRecords.builder(buffer, magic, compressionType, timestampType, 0L);
    }

    public static MemoryRecordsBuilder builder(ByteBuffer buffer, CompressionType compressionType, TimestampType timestampType, long baseOffset) {
        return MemoryRecords.builder(buffer, (byte)1, compressionType, timestampType, baseOffset, System.currentTimeMillis());
    }

    public static MemoryRecordsBuilder builder(ByteBuffer buffer, byte magic, CompressionType compressionType, TimestampType timestampType, long baseOffset) {
        return MemoryRecords.builder(buffer, magic, compressionType, timestampType, baseOffset, System.currentTimeMillis());
    }

    public static MemoryRecords readableRecords(ByteBuffer buffer) {
        return new MemoryRecords(buffer);
    }

    public static MemoryRecords withLogEntries(CompressionType compressionType, List<LogEntry> entries) {
        return MemoryRecords.withLogEntries(TimestampType.CREATE_TIME, compressionType, System.currentTimeMillis(), entries);
    }

    public static MemoryRecords withLogEntries(LogEntry ... entries) {
        return MemoryRecords.withLogEntries(CompressionType.NONE, Arrays.asList(entries));
    }

    public static MemoryRecords withRecords(CompressionType compressionType, long initialOffset, List<Record> records) {
        return MemoryRecords.withRecords(initialOffset, TimestampType.CREATE_TIME, compressionType, System.currentTimeMillis(), records);
    }

    public static MemoryRecords withRecords(Record ... records) {
        return MemoryRecords.withRecords(CompressionType.NONE, 0L, Arrays.asList(records));
    }

    public static MemoryRecords withRecords(long initialOffset, Record ... records) {
        return MemoryRecords.withRecords(CompressionType.NONE, initialOffset, Arrays.asList(records));
    }

    public static MemoryRecords withRecords(CompressionType compressionType, Record ... records) {
        return MemoryRecords.withRecords(compressionType, 0L, Arrays.asList(records));
    }

    public static MemoryRecords withRecords(TimestampType timestampType, CompressionType compressionType, Record ... records) {
        return MemoryRecords.withRecords(0L, timestampType, compressionType, System.currentTimeMillis(), Arrays.asList(records));
    }

    public static MemoryRecords withRecords(long initialOffset, TimestampType timestampType, CompressionType compressionType, long logAppendTime, List<Record> records) {
        return MemoryRecords.withLogEntries(timestampType, compressionType, logAppendTime, MemoryRecords.buildLogEntries(initialOffset, records));
    }

    private static MemoryRecords withLogEntries(TimestampType timestampType, CompressionType compressionType, long logAppendTime, List<LogEntry> entries) {
        if (entries.isEmpty()) {
            return EMPTY;
        }
        return MemoryRecords.builderWithEntries(timestampType, compressionType, logAppendTime, entries).build();
    }

    private static List<LogEntry> buildLogEntries(long initialOffset, List<Record> records) {
        ArrayList<LogEntry> entries = new ArrayList<LogEntry>();
        for (Record record : records) {
            entries.add(LogEntry.create(initialOffset++, record));
        }
        return entries;
    }

    public static MemoryRecordsBuilder builderWithEntries(TimestampType timestampType, CompressionType compressionType, long logAppendTime, List<LogEntry> entries) {
        ByteBuffer buffer = ByteBuffer.allocate(MemoryRecords.estimatedSize(compressionType, entries));
        return MemoryRecords.builderWithEntries(buffer, timestampType, compressionType, logAppendTime, entries);
    }

    private static MemoryRecordsBuilder builderWithEntries(ByteBuffer buffer, TimestampType timestampType, CompressionType compressionType, long logAppendTime, List<LogEntry> entries) {
        if (entries.isEmpty()) {
            throw new IllegalArgumentException("entries must not be empty");
        }
        LogEntry firstEntry = entries.iterator().next();
        long firstOffset = firstEntry.offset();
        byte magic = firstEntry.record().magic();
        MemoryRecordsBuilder builder = MemoryRecords.builder(buffer, magic, compressionType, timestampType, firstOffset, logAppendTime);
        for (LogEntry entry : entries) {
            builder.appendWithOffset(entry.offset(), entry.record());
        }
        return builder;
    }

    public static class FilterResult {
        public final ByteBuffer output;
        public final int messagesRead;
        public final int bytesRead;
        public final int messagesRetained;
        public final int bytesRetained;
        public final long maxOffset;
        public final long maxTimestamp;
        public final long shallowOffsetOfMaxTimestamp;

        public FilterResult(ByteBuffer output, int messagesRead, int bytesRead, int messagesRetained, int bytesRetained, long maxOffset, long maxTimestamp, long shallowOffsetOfMaxTimestamp) {
            this.output = output;
            this.messagesRead = messagesRead;
            this.bytesRead = bytesRead;
            this.messagesRetained = messagesRetained;
            this.bytesRetained = bytesRetained;
            this.maxOffset = maxOffset;
            this.maxTimestamp = maxTimestamp;
            this.shallowOffsetOfMaxTimestamp = shallowOffsetOfMaxTimestamp;
        }
    }

    public static interface LogEntryFilter {
        public boolean shouldRetain(LogEntry var1);
    }
}

