/*
 * Decompiled with CFR 0.152.
 */
package shaded.alink.kafka010.org.apache.kafka.common.record;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Iterator;
import shaded.alink.kafka010.org.apache.kafka.common.record.BufferSupplier;
import shaded.alink.kafka010.org.apache.kafka.common.record.CompressionType;
import shaded.alink.kafka010.org.apache.kafka.common.record.Record;
import shaded.alink.kafka010.org.apache.kafka.common.record.RecordsIterator;

public abstract class LogEntry
implements Iterable<LogEntry> {
    public abstract long offset();

    public abstract Record record();

    public long firstOffset() {
        return this.iterator().next().offset();
    }

    public long nextOffset() {
        return this.offset() + 1L;
    }

    public byte magic() {
        return this.record().magic();
    }

    public String toString() {
        return "LogEntry(" + this.offset() + ", " + this.record() + ")";
    }

    public int sizeInBytes() {
        return this.record().sizeInBytes() + 12;
    }

    public boolean isCompressed() {
        return this.record().compressionType() != CompressionType.NONE;
    }

    public void writeTo(ByteBuffer buffer) {
        LogEntry.writeHeader(buffer, this.offset(), this.record().sizeInBytes());
        buffer.put(this.record().buffer().duplicate());
    }

    @Override
    public Iterator<LogEntry> iterator() {
        if (this.isCompressed()) {
            return new RecordsIterator.DeepRecordsIterator(this, false, Integer.MAX_VALUE, BufferSupplier.NO_CACHING);
        }
        return Collections.singletonList(this).iterator();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof LogEntry)) {
            return false;
        }
        LogEntry that = (LogEntry)o;
        if (this.offset() != that.offset()) {
            return false;
        }
        Record thisRecord = this.record();
        Record thatRecord = that.record();
        return thisRecord != null ? thisRecord.equals(thatRecord) : thatRecord == null;
    }

    public int hashCode() {
        long offset = this.offset();
        Record record = this.record();
        int result = (int)(offset ^ offset >>> 32);
        result = 31 * result + (record != null ? record.hashCode() : 0);
        return result;
    }

    public static void writeHeader(ByteBuffer buffer, long offset, int size) {
        buffer.putLong(offset);
        buffer.putInt(size);
    }

    public static void writeHeader(DataOutputStream out, long offset, int size) throws IOException {
        out.writeLong(offset);
        out.writeInt(size);
    }

    public static LogEntry create(long offset, Record record) {
        return new SimpleLogEntry(offset, record);
    }

    private static class SimpleLogEntry
    extends LogEntry {
        private final long offset;
        private final Record record;

        public SimpleLogEntry(long offset, Record record) {
            this.offset = offset;
            this.record = record;
        }

        @Override
        public long offset() {
            return this.offset;
        }

        @Override
        public Record record() {
            return this.record;
        }
    }
}

