/*
 * Decompiled with CFR 0.152.
 */
package shaded.alink.kafka010.org.apache.kafka.common.record;

import java.util.ArrayList;
import java.util.Iterator;
import shaded.alink.kafka010.org.apache.kafka.common.record.BufferSupplier;
import shaded.alink.kafka010.org.apache.kafka.common.record.CompressionType;
import shaded.alink.kafka010.org.apache.kafka.common.record.LogEntry;
import shaded.alink.kafka010.org.apache.kafka.common.record.MemoryRecords;
import shaded.alink.kafka010.org.apache.kafka.common.record.Record;
import shaded.alink.kafka010.org.apache.kafka.common.record.Records;

public abstract class AbstractRecords
implements Records {
    private final Iterable<Record> records = new Iterable<Record>(){

        @Override
        public Iterator<Record> iterator() {
            return new Iterator<Record>(){
                private final Iterator<? extends LogEntry> deepEntries;
                {
                    this.deepEntries = AbstractRecords.this.deepEntries(BufferSupplier.NO_CACHING).iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.deepEntries.hasNext();
                }

                @Override
                public Record next() {
                    return this.deepEntries.next().record();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("Removal not supported");
                }
            };
        }
    };

    @Override
    public boolean hasMatchingShallowMagic(byte magic) {
        for (LogEntry logEntry : this.shallowEntries()) {
            if (logEntry.magic() == magic) continue;
            return false;
        }
        return true;
    }

    @Override
    public Records toMessageFormat(byte toMagic) {
        ArrayList<LogEntry> converted = new ArrayList<LogEntry>();
        for (LogEntry entry : this.deepEntries(BufferSupplier.NO_CACHING)) {
            converted.add(LogEntry.create(entry.offset(), entry.record().convert(toMagic)));
        }
        if (converted.isEmpty()) {
            return this;
        }
        CompressionType compressionType = this.shallowEntries().iterator().next().record().compressionType();
        return MemoryRecords.withLogEntries(compressionType, converted);
    }

    public static int estimatedSize(CompressionType compressionType, Iterable<LogEntry> entries) {
        int size = 0;
        for (LogEntry entry : entries) {
            size += entry.sizeInBytes();
        }
        return compressionType == CompressionType.NONE ? size : Math.min(Math.max(size / 2, 1024), 65536);
    }

    public Iterable<Record> records() {
        return this.records;
    }
}

