/*
 * Decompiled with CFR 0.152.
 */
package shaded.alink.kafka010.org.apache.flink.streaming.connectors.kafka.table;

import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.connector.format.DecodingFormat;
import org.apache.flink.table.connector.format.EncodingFormat;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.factories.DeserializationFormatFactory;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.factories.DynamicTableSinkFactory;
import org.apache.flink.table.factories.DynamicTableSourceFactory;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.factories.SerializationFormatFactory;
import org.apache.flink.table.types.DataType;
import shaded.alink.kafka010.org.apache.flink.streaming.connectors.kafka.config.StartupMode;
import shaded.alink.kafka010.org.apache.flink.streaming.connectors.kafka.internals.KafkaTopicPartition;
import shaded.alink.kafka010.org.apache.flink.streaming.connectors.kafka.partitioner.FlinkKafkaPartitioner;
import shaded.alink.kafka010.org.apache.flink.streaming.connectors.kafka.table.KafkaDynamicSinkBase;
import shaded.alink.kafka010.org.apache.flink.streaming.connectors.kafka.table.KafkaDynamicSourceBase;
import shaded.alink.kafka010.org.apache.flink.streaming.connectors.kafka.table.KafkaOptions;

public abstract class KafkaDynamicTableFactoryBase
implements DynamicTableSourceFactory,
DynamicTableSinkFactory {
    public DynamicTableSource createDynamicTableSource(DynamicTableFactory.Context context) {
        FactoryUtil.TableFactoryHelper helper = FactoryUtil.createTableFactoryHelper((DynamicTableFactory)this, (DynamicTableFactory.Context)context);
        ReadableConfig tableOptions = helper.getOptions();
        String topic = (String)tableOptions.get(KafkaOptions.TOPIC);
        DecodingFormat decodingFormat = helper.discoverDecodingFormat(DeserializationFormatFactory.class, FactoryUtil.FORMAT);
        helper.validateExcept(new String[]{"properties."});
        KafkaOptions.validateTableOptions(tableOptions);
        DataType producedDataType = context.getCatalogTable().getSchema().toPhysicalRowDataType();
        KafkaOptions.StartupOptions startupOptions = KafkaOptions.getStartupOptions(tableOptions, topic);
        return this.createKafkaTableSource(producedDataType, topic, KafkaOptions.getKafkaProperties(context.getCatalogTable().getOptions()), (DecodingFormat<DeserializationSchema<RowData>>)decodingFormat, startupOptions.startupMode, startupOptions.specificOffsets, startupOptions.startupTimestampMillis);
    }

    public DynamicTableSink createDynamicTableSink(DynamicTableFactory.Context context) {
        FactoryUtil.TableFactoryHelper helper = FactoryUtil.createTableFactoryHelper((DynamicTableFactory)this, (DynamicTableFactory.Context)context);
        ReadableConfig tableOptions = helper.getOptions();
        String topic = (String)tableOptions.get(KafkaOptions.TOPIC);
        EncodingFormat encodingFormat = helper.discoverEncodingFormat(SerializationFormatFactory.class, FactoryUtil.FORMAT);
        helper.validateExcept(new String[]{"properties."});
        KafkaOptions.validateTableOptions(tableOptions);
        DataType consumedDataType = context.getCatalogTable().getSchema().toPhysicalRowDataType();
        return this.createKafkaTableSink(consumedDataType, topic, KafkaOptions.getKafkaProperties(context.getCatalogTable().getOptions()), KafkaOptions.getFlinkKafkaPartitioner(tableOptions, context.getClassLoader()), (EncodingFormat<SerializationSchema<RowData>>)encodingFormat);
    }

    protected abstract KafkaDynamicSourceBase createKafkaTableSource(DataType var1, String var2, Properties var3, DecodingFormat<DeserializationSchema<RowData>> var4, StartupMode var5, Map<KafkaTopicPartition, Long> var6, long var7);

    protected abstract KafkaDynamicSinkBase createKafkaTableSink(DataType var1, String var2, Properties var3, Optional<FlinkKafkaPartitioner<RowData>> var4, EncodingFormat<SerializationSchema<RowData>> var5);

    public Set<ConfigOption<?>> requiredOptions() {
        HashSet options = new HashSet();
        options.add(KafkaOptions.TOPIC);
        options.add(FactoryUtil.FORMAT);
        options.add(KafkaOptions.PROPS_BOOTSTRAP_SERVERS);
        return options;
    }

    public Set<ConfigOption<?>> optionalOptions() {
        HashSet options = new HashSet();
        options.add(KafkaOptions.PROPS_GROUP_ID);
        options.add(KafkaOptions.SCAN_STARTUP_MODE);
        options.add(KafkaOptions.SCAN_STARTUP_SPECIFIC_OFFSETS);
        options.add(KafkaOptions.SCAN_STARTUP_TIMESTAMP_MILLIS);
        options.add(KafkaOptions.SINK_PARTITIONER);
        return options;
    }
}

