/*
 * Decompiled with CFR 0.152.
 */
package shaded.alink.kafka010.org.apache.flink.streaming.connectors.kafka.table;

import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.format.DecodingFormat;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.connector.source.ScanTableSource;
import org.apache.flink.table.connector.source.SourceFunctionProvider;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.DataType;
import org.apache.flink.util.Preconditions;
import shaded.alink.kafka010.org.apache.flink.streaming.connectors.kafka.FlinkKafkaConsumerBase;
import shaded.alink.kafka010.org.apache.flink.streaming.connectors.kafka.config.StartupMode;
import shaded.alink.kafka010.org.apache.flink.streaming.connectors.kafka.internals.KafkaTopicPartition;

@Internal
public abstract class KafkaDynamicSourceBase
implements ScanTableSource {
    protected final DataType outputDataType;
    protected final DecodingFormat<DeserializationSchema<RowData>> decodingFormat;
    protected final String topic;
    protected final Properties properties;
    protected final StartupMode startupMode;
    protected final Map<KafkaTopicPartition, Long> specificStartupOffsets;
    protected final long startupTimestampMillis;
    private static final long DEFAULT_STARTUP_TIMESTAMP_MILLIS = 0L;

    protected KafkaDynamicSourceBase(DataType outputDataType, String topic, Properties properties, DecodingFormat<DeserializationSchema<RowData>> decodingFormat, StartupMode startupMode, Map<KafkaTopicPartition, Long> specificStartupOffsets, long startupTimestampMillis) {
        this.outputDataType = (DataType)Preconditions.checkNotNull((Object)outputDataType, (String)"Produced data type must not be null.");
        this.topic = (String)Preconditions.checkNotNull((Object)topic, (String)"Topic must not be null.");
        this.properties = (Properties)Preconditions.checkNotNull((Object)properties, (String)"Properties must not be null.");
        this.decodingFormat = (DecodingFormat)Preconditions.checkNotNull(decodingFormat, (String)"Decoding format must not be null.");
        this.startupMode = (StartupMode)((Object)Preconditions.checkNotNull((Object)((Object)startupMode), (String)"Startup mode must not be null."));
        this.specificStartupOffsets = (Map)Preconditions.checkNotNull(specificStartupOffsets, (String)"Specific offsets must not be null.");
        this.startupTimestampMillis = startupTimestampMillis;
    }

    public ChangelogMode getChangelogMode() {
        return this.decodingFormat.getChangelogMode();
    }

    public ScanTableSource.ScanRuntimeProvider getScanRuntimeProvider(ScanTableSource.ScanContext runtimeProviderContext) {
        DeserializationSchema deserializationSchema = (DeserializationSchema)this.decodingFormat.createRuntimeDecoder((DynamicTableSource.Context)runtimeProviderContext, this.outputDataType);
        FlinkKafkaConsumerBase<RowData> kafkaConsumer = this.getKafkaConsumer(this.topic, this.properties, (DeserializationSchema<RowData>)deserializationSchema);
        return SourceFunctionProvider.of(kafkaConsumer, (boolean)false);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KafkaDynamicSourceBase that = (KafkaDynamicSourceBase)o;
        return Objects.equals(this.outputDataType, that.outputDataType) && Objects.equals(this.topic, that.topic) && Objects.equals(this.properties, that.properties) && Objects.equals(this.decodingFormat, that.decodingFormat) && this.startupMode == that.startupMode && Objects.equals(this.specificStartupOffsets, that.specificStartupOffsets) && this.startupTimestampMillis == that.startupTimestampMillis;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.outputDataType, this.topic, this.properties, this.decodingFormat, this.startupMode, this.specificStartupOffsets, this.startupTimestampMillis});
    }

    protected abstract FlinkKafkaConsumerBase<RowData> createKafkaConsumer(String var1, Properties var2, DeserializationSchema<RowData> var3);

    protected FlinkKafkaConsumerBase<RowData> getKafkaConsumer(String topic, Properties properties, DeserializationSchema<RowData> deserializationSchema) {
        FlinkKafkaConsumerBase<RowData> kafkaConsumer = this.createKafkaConsumer(topic, properties, deserializationSchema);
        switch (this.startupMode) {
            case EARLIEST: {
                kafkaConsumer.setStartFromEarliest();
                break;
            }
            case LATEST: {
                kafkaConsumer.setStartFromLatest();
                break;
            }
            case GROUP_OFFSETS: {
                kafkaConsumer.setStartFromGroupOffsets();
                break;
            }
            case SPECIFIC_OFFSETS: {
                kafkaConsumer.setStartFromSpecificOffsets(this.specificStartupOffsets);
                break;
            }
            case TIMESTAMP: {
                kafkaConsumer.setStartFromTimestamp(this.startupTimestampMillis);
            }
        }
        kafkaConsumer.setCommitOffsetsOnCheckpoints(properties.getProperty("group.id") != null);
        return kafkaConsumer;
    }
}

