/*
 * Decompiled with CFR 0.152.
 */
package shaded.alink.kafka.org.apache.kafka.common.serialization;

import shaded.alink.kafka.org.apache.kafka.common.errors.SerializationException;
import shaded.alink.kafka.org.apache.kafka.common.serialization.Deserializer;

public class FloatDeserializer
implements Deserializer<Float> {
    @Override
    public Float deserialize(String topic, byte[] data) {
        if (data == null) {
            return null;
        }
        if (data.length != 4) {
            throw new SerializationException("Size of data received by Deserializer is not 4");
        }
        int value = 0;
        for (byte b : data) {
            value <<= 8;
            value |= b & 0xFF;
        }
        return Float.valueOf(Float.intBitsToFloat(value));
    }
}

