/*
 * Decompiled with CFR 0.152.
 */
package shaded.alink.kafka.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import shaded.alink.kafka.org.apache.kafka.common.errors.UnsupportedVersionException;
import shaded.alink.kafka.org.apache.kafka.common.message.SyncGroupRequestData;
import shaded.alink.kafka.org.apache.kafka.common.message.SyncGroupResponseData;
import shaded.alink.kafka.org.apache.kafka.common.protocol.ApiKeys;
import shaded.alink.kafka.org.apache.kafka.common.protocol.Errors;
import shaded.alink.kafka.org.apache.kafka.common.protocol.types.Struct;
import shaded.alink.kafka.org.apache.kafka.common.requests.AbstractRequest;
import shaded.alink.kafka.org.apache.kafka.common.requests.AbstractResponse;
import shaded.alink.kafka.org.apache.kafka.common.requests.SyncGroupResponse;

public class SyncGroupRequest
extends AbstractRequest {
    public final SyncGroupRequestData data;

    public SyncGroupRequest(SyncGroupRequestData data, short version) {
        super(ApiKeys.SYNC_GROUP, version);
        this.data = data;
    }

    public SyncGroupRequest(Struct struct, short version) {
        super(ApiKeys.SYNC_GROUP, version);
        this.data = new SyncGroupRequestData(struct, version);
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        short versionId = this.version();
        switch (versionId) {
            case 0: {
                return new SyncGroupResponse(new SyncGroupResponseData().setErrorCode(Errors.forException(e).code()).setAssignment(new byte[0]));
            }
            case 1: 
            case 2: 
            case 3: {
                return new SyncGroupResponse(new SyncGroupResponseData().setErrorCode(Errors.forException(e).code()).setAssignment(new byte[0]).setThrottleTimeMs(throttleTimeMs));
            }
        }
        throw new IllegalArgumentException(String.format("Version %d is not valid. Valid versions for %s are 0 to %d", versionId, this.getClass().getSimpleName(), ApiKeys.SYNC_GROUP.latestVersion()));
    }

    public Map<String, ByteBuffer> groupAssignments() {
        HashMap<String, ByteBuffer> groupAssignments = new HashMap<String, ByteBuffer>();
        for (SyncGroupRequestData.SyncGroupRequestAssignment assignment : this.data.assignments()) {
            groupAssignments.put(assignment.memberId(), ByteBuffer.wrap(assignment.assignment()));
        }
        return groupAssignments;
    }

    public static SyncGroupRequest parse(ByteBuffer buffer, short version) {
        return new SyncGroupRequest(ApiKeys.SYNC_GROUP.parseRequest(version, buffer), version);
    }

    @Override
    protected Struct toStruct() {
        return this.data.toStruct(this.version());
    }

    public static class Builder
    extends AbstractRequest.Builder<SyncGroupRequest> {
        private final SyncGroupRequestData data;

        public Builder(SyncGroupRequestData data) {
            super(ApiKeys.SYNC_GROUP);
            this.data = data;
        }

        @Override
        public SyncGroupRequest build(short version) {
            if (this.data.groupInstanceId() != null && version < 3) {
                throw new UnsupportedVersionException("The broker sync group protocol version " + version + " does not support usage of config group.instance.id.");
            }
            return new SyncGroupRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

