/*
 * Decompiled with CFR 0.152.
 */
package shaded.alink.kafka.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Map;
import shaded.alink.kafka.org.apache.kafka.common.message.SaslAuthenticateResponseData;
import shaded.alink.kafka.org.apache.kafka.common.protocol.ApiKeys;
import shaded.alink.kafka.org.apache.kafka.common.protocol.Errors;
import shaded.alink.kafka.org.apache.kafka.common.protocol.types.Struct;
import shaded.alink.kafka.org.apache.kafka.common.requests.AbstractResponse;

public class SaslAuthenticateResponse
extends AbstractResponse {
    private final SaslAuthenticateResponseData data;

    public SaslAuthenticateResponse(SaslAuthenticateResponseData data) {
        this.data = data;
    }

    public SaslAuthenticateResponse(Struct struct, short version) {
        this.data = new SaslAuthenticateResponseData(struct, version);
    }

    public Errors error() {
        return Errors.forCode(this.data.errorCode());
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        return Collections.singletonMap(Errors.forCode(this.data.errorCode()), 1);
    }

    public String errorMessage() {
        return this.data.errorMessage();
    }

    public long sessionLifetimeMs() {
        return this.data.sessionLifetimeMs();
    }

    public byte[] saslAuthBytes() {
        return this.data.authBytes();
    }

    @Override
    public Struct toStruct(short version) {
        return this.data.toStruct(version);
    }

    public static SaslAuthenticateResponse parse(ByteBuffer buffer, short version) {
        return new SaslAuthenticateResponse(ApiKeys.SASL_AUTHENTICATE.parseResponse(version, buffer), version);
    }
}

