/*
 * Decompiled with CFR 0.152.
 */
package shaded.alink.kafka.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import shaded.alink.kafka.org.apache.kafka.common.message.IncrementalAlterConfigsRequestData;
import shaded.alink.kafka.org.apache.kafka.common.message.IncrementalAlterConfigsResponseData;
import shaded.alink.kafka.org.apache.kafka.common.protocol.ApiKeys;
import shaded.alink.kafka.org.apache.kafka.common.protocol.types.Struct;
import shaded.alink.kafka.org.apache.kafka.common.requests.AbstractRequest;
import shaded.alink.kafka.org.apache.kafka.common.requests.AbstractResponse;
import shaded.alink.kafka.org.apache.kafka.common.requests.ApiError;
import shaded.alink.kafka.org.apache.kafka.common.requests.IncrementalAlterConfigsResponse;

public class IncrementalAlterConfigsRequest
extends AbstractRequest {
    private final IncrementalAlterConfigsRequestData data;
    private final short version;

    private IncrementalAlterConfigsRequest(IncrementalAlterConfigsRequestData data, short version) {
        super(ApiKeys.INCREMENTAL_ALTER_CONFIGS, version);
        this.data = data;
        this.version = version;
    }

    IncrementalAlterConfigsRequest(Struct struct, short version) {
        super(ApiKeys.INCREMENTAL_ALTER_CONFIGS, version);
        this.data = new IncrementalAlterConfigsRequestData(struct, version);
        this.version = version;
    }

    public static IncrementalAlterConfigsRequest parse(ByteBuffer buffer, short version) {
        return new IncrementalAlterConfigsRequest(ApiKeys.INCREMENTAL_ALTER_CONFIGS.parseRequest(version, buffer), version);
    }

    public IncrementalAlterConfigsRequestData data() {
        return this.data;
    }

    @Override
    protected Struct toStruct() {
        return this.data.toStruct(this.version);
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        IncrementalAlterConfigsResponseData response = new IncrementalAlterConfigsResponseData();
        ApiError apiError = ApiError.fromThrowable(e);
        for (IncrementalAlterConfigsRequestData.AlterConfigsResource resource : this.data.resources()) {
            response.responses().add(new IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse().setResourceName(resource.resourceName()).setResourceType(resource.resourceType()).setErrorCode(apiError.error().code()).setErrorMessage(apiError.message()));
        }
        return new IncrementalAlterConfigsResponse(response);
    }

    public static class Builder
    extends AbstractRequest.Builder<IncrementalAlterConfigsRequest> {
        private final IncrementalAlterConfigsRequestData data;

        public Builder(IncrementalAlterConfigsRequestData data) {
            super(ApiKeys.INCREMENTAL_ALTER_CONFIGS);
            this.data = data;
        }

        @Override
        public IncrementalAlterConfigsRequest build(short version) {
            return new IncrementalAlterConfigsRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

