/*
 * Decompiled with CFR 0.152.
 */
package shaded.alink.kafka.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import shaded.alink.kafka.org.apache.kafka.common.message.DescribeDelegationTokenResponseData;
import shaded.alink.kafka.org.apache.kafka.common.protocol.ApiKeys;
import shaded.alink.kafka.org.apache.kafka.common.protocol.Errors;
import shaded.alink.kafka.org.apache.kafka.common.protocol.types.Struct;
import shaded.alink.kafka.org.apache.kafka.common.requests.AbstractResponse;
import shaded.alink.kafka.org.apache.kafka.common.security.auth.KafkaPrincipal;
import shaded.alink.kafka.org.apache.kafka.common.security.token.delegation.DelegationToken;
import shaded.alink.kafka.org.apache.kafka.common.security.token.delegation.TokenInformation;

public class DescribeDelegationTokenResponse
extends AbstractResponse {
    private final DescribeDelegationTokenResponseData data;

    public DescribeDelegationTokenResponse(int throttleTimeMs, Errors error, List<DelegationToken> tokens) {
        List<DescribeDelegationTokenResponseData.DescribedDelegationToken> describedDelegationTokenList = tokens.stream().map(dt -> new DescribeDelegationTokenResponseData.DescribedDelegationToken().setTokenId(dt.tokenInfo().tokenId()).setPrincipalType(dt.tokenInfo().owner().getPrincipalType()).setPrincipalName(dt.tokenInfo().owner().getName()).setIssueTimestamp(dt.tokenInfo().issueTimestamp()).setMaxTimestamp(dt.tokenInfo().maxTimestamp()).setExpiryTimestamp(dt.tokenInfo().expiryTimestamp()).setHmac(dt.hmac()).setRenewers(dt.tokenInfo().renewers().stream().map(r -> new DescribeDelegationTokenResponseData.DescribedDelegationTokenRenewer().setPrincipalName(r.getName()).setPrincipalType(r.getPrincipalType())).collect(Collectors.toList()))).collect(Collectors.toList());
        this.data = new DescribeDelegationTokenResponseData().setThrottleTimeMs(throttleTimeMs).setErrorCode(error.code()).setTokens(describedDelegationTokenList);
    }

    public DescribeDelegationTokenResponse(int throttleTimeMs, Errors error) {
        this(throttleTimeMs, error, new ArrayList<DelegationToken>());
    }

    public DescribeDelegationTokenResponse(Struct struct, short version) {
        this.data = new DescribeDelegationTokenResponseData(struct, version);
    }

    public static DescribeDelegationTokenResponse parse(ByteBuffer buffer, short version) {
        return new DescribeDelegationTokenResponse(ApiKeys.DESCRIBE_DELEGATION_TOKEN.responseSchema(version).read(buffer), version);
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        return this.errorCounts(this.error());
    }

    @Override
    protected Struct toStruct(short version) {
        return this.data.toStruct(version);
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    public Errors error() {
        return Errors.forCode(this.data.errorCode());
    }

    public List<DelegationToken> tokens() {
        return this.data.tokens().stream().map(ddt -> new DelegationToken(new TokenInformation(ddt.tokenId(), new KafkaPrincipal(ddt.principalType(), ddt.principalName()), ddt.renewers().stream().map(ddtr -> new KafkaPrincipal(ddtr.principalType(), ddtr.principalName())).collect(Collectors.toList()), ddt.issueTimestamp(), ddt.maxTimestamp(), ddt.expiryTimestamp()), ddt.hmac())).collect(Collectors.toList());
    }

    public boolean hasError() {
        return this.error() != Errors.NONE;
    }

    @Override
    public boolean shouldClientThrottle(short version) {
        return version >= 1;
    }
}

