/*
 * Decompiled with CFR 0.152.
 */
package shaded.alink.kafka.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import shaded.alink.kafka.org.apache.kafka.common.message.DeleteTopicsRequestData;
import shaded.alink.kafka.org.apache.kafka.common.message.DeleteTopicsResponseData;
import shaded.alink.kafka.org.apache.kafka.common.protocol.ApiKeys;
import shaded.alink.kafka.org.apache.kafka.common.protocol.types.Struct;
import shaded.alink.kafka.org.apache.kafka.common.requests.AbstractRequest;
import shaded.alink.kafka.org.apache.kafka.common.requests.AbstractResponse;
import shaded.alink.kafka.org.apache.kafka.common.requests.ApiError;
import shaded.alink.kafka.org.apache.kafka.common.requests.DeleteTopicsResponse;

public class DeleteTopicsRequest
extends AbstractRequest {
    private DeleteTopicsRequestData data;
    private final short version;

    private DeleteTopicsRequest(DeleteTopicsRequestData data, short version) {
        super(ApiKeys.DELETE_TOPICS, version);
        this.data = data;
        this.version = version;
    }

    public DeleteTopicsRequest(Struct struct, short version) {
        super(ApiKeys.DELETE_TOPICS, version);
        this.data = new DeleteTopicsRequestData(struct, version);
        this.version = version;
    }

    @Override
    protected Struct toStruct() {
        return this.data.toStruct(this.version);
    }

    public DeleteTopicsRequestData data() {
        return this.data;
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        DeleteTopicsResponseData response = new DeleteTopicsResponseData();
        if (this.version >= 1) {
            response.setThrottleTimeMs(throttleTimeMs);
        }
        ApiError apiError = ApiError.fromThrowable(e);
        for (String topic : this.data.topicNames()) {
            response.responses().add(new DeleteTopicsResponseData.DeletableTopicResult().setName(topic).setErrorCode(apiError.error().code()));
        }
        return new DeleteTopicsResponse(response);
    }

    public static DeleteTopicsRequest parse(ByteBuffer buffer, short version) {
        return new DeleteTopicsRequest(ApiKeys.DELETE_TOPICS.parseRequest(version, buffer), version);
    }

    public static class Builder
    extends AbstractRequest.Builder<DeleteTopicsRequest> {
        private DeleteTopicsRequestData data;

        public Builder(DeleteTopicsRequestData data) {
            super(ApiKeys.DELETE_TOPICS);
            this.data = data;
        }

        @Override
        public DeleteTopicsRequest build(short version) {
            return new DeleteTopicsRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

