/*
 * Decompiled with CFR 0.152.
 */
package shaded.alink.kafka.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import shaded.alink.kafka.org.apache.kafka.common.message.DeleteGroupsRequestData;
import shaded.alink.kafka.org.apache.kafka.common.message.DeleteGroupsResponseData;
import shaded.alink.kafka.org.apache.kafka.common.protocol.ApiKeys;
import shaded.alink.kafka.org.apache.kafka.common.protocol.Errors;
import shaded.alink.kafka.org.apache.kafka.common.protocol.types.Struct;
import shaded.alink.kafka.org.apache.kafka.common.requests.AbstractRequest;
import shaded.alink.kafka.org.apache.kafka.common.requests.AbstractResponse;
import shaded.alink.kafka.org.apache.kafka.common.requests.DeleteGroupsResponse;

public class DeleteGroupsRequest
extends AbstractRequest {
    public final DeleteGroupsRequestData data;

    public DeleteGroupsRequest(DeleteGroupsRequestData data, short version) {
        super(ApiKeys.DELETE_GROUPS, version);
        this.data = data;
    }

    public DeleteGroupsRequest(Struct struct, short version) {
        super(ApiKeys.DELETE_GROUPS, version);
        this.data = new DeleteGroupsRequestData(struct, version);
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        Errors error = Errors.forException(e);
        DeleteGroupsResponseData.DeletableGroupResultCollection groupResults = new DeleteGroupsResponseData.DeletableGroupResultCollection();
        for (String groupId : this.data.groupsNames()) {
            groupResults.add(new DeleteGroupsResponseData.DeletableGroupResult().setGroupId(groupId).setErrorCode(error.code()));
        }
        return new DeleteGroupsResponse(new DeleteGroupsResponseData().setResults(groupResults).setThrottleTimeMs(throttleTimeMs));
    }

    public static DeleteGroupsRequest parse(ByteBuffer buffer, short version) {
        return new DeleteGroupsRequest(ApiKeys.DELETE_GROUPS.parseRequest(version, buffer), version);
    }

    @Override
    protected Struct toStruct() {
        return this.data.toStruct(this.version());
    }

    public static class Builder
    extends AbstractRequest.Builder<DeleteGroupsRequest> {
        private final DeleteGroupsRequestData data;

        public Builder(DeleteGroupsRequestData data) {
            super(ApiKeys.DELETE_GROUPS);
            this.data = data;
        }

        @Override
        public DeleteGroupsRequest build(short version) {
            return new DeleteGroupsRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

