/*
 * Decompiled with CFR 0.152.
 */
package shaded.alink.kafka.org.apache.kafka.common.record;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import shaded.alink.kafka.org.apache.kafka.common.InvalidRecordException;
import shaded.alink.kafka.org.apache.kafka.common.KafkaException;
import shaded.alink.kafka.org.apache.kafka.common.errors.CorruptRecordException;
import shaded.alink.kafka.org.apache.kafka.common.header.Header;
import shaded.alink.kafka.org.apache.kafka.common.record.AbstractRecordBatch;
import shaded.alink.kafka.org.apache.kafka.common.record.BufferSupplier;
import shaded.alink.kafka.org.apache.kafka.common.record.CompressionType;
import shaded.alink.kafka.org.apache.kafka.common.record.DefaultRecord;
import shaded.alink.kafka.org.apache.kafka.common.record.FileLogInputStream;
import shaded.alink.kafka.org.apache.kafka.common.record.FileRecords;
import shaded.alink.kafka.org.apache.kafka.common.record.MutableRecordBatch;
import shaded.alink.kafka.org.apache.kafka.common.record.Record;
import shaded.alink.kafka.org.apache.kafka.common.record.RecordBatch;
import shaded.alink.kafka.org.apache.kafka.common.record.SimpleRecord;
import shaded.alink.kafka.org.apache.kafka.common.record.TimestampType;
import shaded.alink.kafka.org.apache.kafka.common.utils.ByteBufferOutputStream;
import shaded.alink.kafka.org.apache.kafka.common.utils.ByteUtils;
import shaded.alink.kafka.org.apache.kafka.common.utils.CloseableIterator;
import shaded.alink.kafka.org.apache.kafka.common.utils.Crc32C;

public class DefaultRecordBatch
extends AbstractRecordBatch
implements MutableRecordBatch {
    static final int BASE_OFFSET_OFFSET = 0;
    static final int BASE_OFFSET_LENGTH = 8;
    static final int LENGTH_OFFSET = 8;
    static final int LENGTH_LENGTH = 4;
    static final int PARTITION_LEADER_EPOCH_OFFSET = 12;
    static final int PARTITION_LEADER_EPOCH_LENGTH = 4;
    static final int MAGIC_OFFSET = 16;
    static final int MAGIC_LENGTH = 1;
    static final int CRC_OFFSET = 17;
    static final int CRC_LENGTH = 4;
    static final int ATTRIBUTES_OFFSET = 21;
    static final int ATTRIBUTE_LENGTH = 2;
    public static final int LAST_OFFSET_DELTA_OFFSET = 23;
    static final int LAST_OFFSET_DELTA_LENGTH = 4;
    static final int FIRST_TIMESTAMP_OFFSET = 27;
    static final int FIRST_TIMESTAMP_LENGTH = 8;
    static final int MAX_TIMESTAMP_OFFSET = 35;
    static final int MAX_TIMESTAMP_LENGTH = 8;
    static final int PRODUCER_ID_OFFSET = 43;
    static final int PRODUCER_ID_LENGTH = 8;
    static final int PRODUCER_EPOCH_OFFSET = 51;
    static final int PRODUCER_EPOCH_LENGTH = 2;
    static final int BASE_SEQUENCE_OFFSET = 53;
    static final int BASE_SEQUENCE_LENGTH = 4;
    public static final int RECORDS_COUNT_OFFSET = 57;
    static final int RECORDS_COUNT_LENGTH = 4;
    static final int RECORDS_OFFSET = 61;
    public static final int RECORD_BATCH_OVERHEAD = 61;
    private static final byte COMPRESSION_CODEC_MASK = 7;
    private static final byte TRANSACTIONAL_FLAG_MASK = 16;
    private static final int CONTROL_FLAG_MASK = 32;
    private static final byte TIMESTAMP_TYPE_MASK = 8;
    private static final int MAX_SKIP_BUFFER_SIZE = 2048;
    private final ByteBuffer buffer;

    DefaultRecordBatch(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    @Override
    public byte magic() {
        return this.buffer.get(16);
    }

    @Override
    public void ensureValid() {
        if (this.sizeInBytes() < 61) {
            throw new CorruptRecordException("Record batch is corrupt (the size " + this.sizeInBytes() + " is smaller than the minimum allowed overhead " + 61 + ")");
        }
        if (!this.isValid()) {
            throw new CorruptRecordException("Record is corrupt (stored crc = " + this.checksum() + ", computed crc = " + this.computeChecksum() + ")");
        }
    }

    public long firstTimestamp() {
        return this.buffer.getLong(27);
    }

    @Override
    public long maxTimestamp() {
        return this.buffer.getLong(35);
    }

    @Override
    public TimestampType timestampType() {
        return (this.attributes() & 8) == 0 ? TimestampType.CREATE_TIME : TimestampType.LOG_APPEND_TIME;
    }

    @Override
    public long baseOffset() {
        return this.buffer.getLong(0);
    }

    @Override
    public long lastOffset() {
        return this.baseOffset() + (long)this.lastOffsetDelta();
    }

    @Override
    public long producerId() {
        return this.buffer.getLong(43);
    }

    @Override
    public short producerEpoch() {
        return this.buffer.getShort(51);
    }

    @Override
    public int baseSequence() {
        return this.buffer.getInt(53);
    }

    private int lastOffsetDelta() {
        return this.buffer.getInt(23);
    }

    @Override
    public int lastSequence() {
        int baseSequence = this.baseSequence();
        if (baseSequence == -1) {
            return -1;
        }
        return DefaultRecordBatch.incrementSequence(baseSequence, this.lastOffsetDelta());
    }

    @Override
    public CompressionType compressionType() {
        return CompressionType.forId(this.attributes() & 7);
    }

    @Override
    public int sizeInBytes() {
        return 12 + this.buffer.getInt(8);
    }

    private int count() {
        return this.buffer.getInt(57);
    }

    @Override
    public Integer countOrNull() {
        return this.count();
    }

    @Override
    public void writeTo(ByteBuffer buffer) {
        buffer.put(this.buffer.duplicate());
    }

    @Override
    public void writeTo(ByteBufferOutputStream outputStream) {
        outputStream.write(this.buffer.duplicate());
    }

    @Override
    public boolean isTransactional() {
        return (this.attributes() & 0x10) > 0;
    }

    @Override
    public boolean isControlBatch() {
        return (this.attributes() & 0x20) > 0;
    }

    @Override
    public int partitionLeaderEpoch() {
        return this.buffer.getInt(12);
    }

    private CloseableIterator<Record> compressedIterator(BufferSupplier bufferSupplier, boolean skipKeyValue) {
        ByteBuffer buffer = this.buffer.duplicate();
        buffer.position(61);
        final DataInputStream inputStream = new DataInputStream(this.compressionType().wrapForInput(buffer, this.magic(), bufferSupplier));
        if (skipKeyValue) {
            final byte[] skipArray = new byte[2048];
            return new StreamRecordIterator(inputStream){

                @Override
                protected Record doReadRecord(long baseOffset, long firstTimestamp, int baseSequence, Long logAppendTime) throws IOException {
                    return DefaultRecord.readPartiallyFrom(inputStream, skipArray, baseOffset, firstTimestamp, baseSequence, logAppendTime);
                }
            };
        }
        return new StreamRecordIterator(inputStream){

            @Override
            protected Record doReadRecord(long baseOffset, long firstTimestamp, int baseSequence, Long logAppendTime) throws IOException {
                return DefaultRecord.readFrom(inputStream, baseOffset, firstTimestamp, baseSequence, logAppendTime);
            }
        };
    }

    private CloseableIterator<Record> uncompressedIterator() {
        final ByteBuffer buffer = this.buffer.duplicate();
        buffer.position(61);
        return new RecordIterator(){

            @Override
            protected Record readNext(long baseOffset, long firstTimestamp, int baseSequence, Long logAppendTime) {
                try {
                    return DefaultRecord.readFrom(buffer, baseOffset, firstTimestamp, baseSequence, logAppendTime);
                }
                catch (BufferUnderflowException e) {
                    throw new InvalidRecordException("Incorrect declared batch size, premature EOF reached");
                }
            }

            @Override
            protected boolean ensureNoneRemaining() {
                return !buffer.hasRemaining();
            }

            @Override
            public void close() {
            }
        };
    }

    @Override
    public Iterator<Record> iterator() {
        if (this.count() == 0) {
            return Collections.emptyIterator();
        }
        if (!this.isCompressed()) {
            return this.uncompressedIterator();
        }
        try (CloseableIterator<Record> iterator = this.compressedIterator(BufferSupplier.NO_CACHING, false);){
            ArrayList records = new ArrayList(this.count());
            while (iterator.hasNext()) {
                records.add(iterator.next());
            }
            Iterator<Record> iterator2 = records.iterator();
            return iterator2;
        }
    }

    @Override
    public CloseableIterator<Record> skipKeyValueIterator(BufferSupplier bufferSupplier) {
        if (this.count() == 0) {
            return CloseableIterator.wrap(Collections.emptyIterator());
        }
        if (!this.isCompressed()) {
            return this.uncompressedIterator();
        }
        return this.compressedIterator(bufferSupplier, true);
    }

    @Override
    public CloseableIterator<Record> streamingIterator(BufferSupplier bufferSupplier) {
        if (this.isCompressed()) {
            return this.compressedIterator(bufferSupplier, false);
        }
        return this.uncompressedIterator();
    }

    @Override
    public void setLastOffset(long offset) {
        this.buffer.putLong(0, offset - (long)this.lastOffsetDelta());
    }

    @Override
    public void setMaxTimestamp(TimestampType timestampType, long maxTimestamp) {
        long currentMaxTimestamp = this.maxTimestamp();
        if (this.timestampType() == timestampType && currentMaxTimestamp == maxTimestamp) {
            return;
        }
        byte attributes = DefaultRecordBatch.computeAttributes(this.compressionType(), timestampType, this.isTransactional(), this.isControlBatch());
        this.buffer.putShort(21, attributes);
        this.buffer.putLong(35, maxTimestamp);
        long crc = this.computeChecksum();
        ByteUtils.writeUnsignedInt(this.buffer, 17, crc);
    }

    @Override
    public void setPartitionLeaderEpoch(int epoch) {
        this.buffer.putInt(12, epoch);
    }

    @Override
    public long checksum() {
        return ByteUtils.readUnsignedInt(this.buffer, 17);
    }

    @Override
    public boolean isValid() {
        return this.sizeInBytes() >= 61 && this.checksum() == this.computeChecksum();
    }

    private long computeChecksum() {
        return Crc32C.compute(this.buffer, 21, this.buffer.limit() - 21);
    }

    private byte attributes() {
        return (byte)this.buffer.getShort(21);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultRecordBatch that = (DefaultRecordBatch)o;
        return Objects.equals(this.buffer, that.buffer);
    }

    public int hashCode() {
        return this.buffer != null ? this.buffer.hashCode() : 0;
    }

    private static byte computeAttributes(CompressionType type, TimestampType timestampType, boolean isTransactional, boolean isControl) {
        byte attributes;
        if (timestampType == TimestampType.NO_TIMESTAMP_TYPE) {
            throw new IllegalArgumentException("Timestamp type must be provided to compute attributes for message format v2 and above");
        }
        byte by = attributes = isTransactional ? (byte)16 : 0;
        if (isControl) {
            attributes = (byte)(attributes | 0x20);
        }
        if (type.id > 0) {
            attributes = (byte)(attributes | 7 & type.id);
        }
        if (timestampType == TimestampType.LOG_APPEND_TIME) {
            attributes = (byte)(attributes | 8);
        }
        return attributes;
    }

    public static void writeEmptyHeader(ByteBuffer buffer, byte magic, long producerId, short producerEpoch, int baseSequence, long baseOffset, long lastOffset, int partitionLeaderEpoch, TimestampType timestampType, long timestamp, boolean isTransactional, boolean isControlRecord) {
        int offsetDelta = (int)(lastOffset - baseOffset);
        DefaultRecordBatch.writeHeader(buffer, baseOffset, offsetDelta, 61, magic, CompressionType.NONE, timestampType, -1L, timestamp, producerId, producerEpoch, baseSequence, isTransactional, isControlRecord, partitionLeaderEpoch, 0);
    }

    static void writeHeader(ByteBuffer buffer, long baseOffset, int lastOffsetDelta, int sizeInBytes, byte magic, CompressionType compressionType, TimestampType timestampType, long firstTimestamp, long maxTimestamp, long producerId, short epoch, int sequence, boolean isTransactional, boolean isControlBatch, int partitionLeaderEpoch, int numRecords) {
        if (magic < 2) {
            throw new IllegalArgumentException("Invalid magic value " + magic);
        }
        if (firstTimestamp < 0L && firstTimestamp != -1L) {
            throw new IllegalArgumentException("Invalid message timestamp " + firstTimestamp);
        }
        short attributes = DefaultRecordBatch.computeAttributes(compressionType, timestampType, isTransactional, isControlBatch);
        int position = buffer.position();
        buffer.putLong(position + 0, baseOffset);
        buffer.putInt(position + 8, sizeInBytes - 12);
        buffer.putInt(position + 12, partitionLeaderEpoch);
        buffer.put(position + 16, magic);
        buffer.putShort(position + 21, attributes);
        buffer.putLong(position + 27, firstTimestamp);
        buffer.putLong(position + 35, maxTimestamp);
        buffer.putInt(position + 23, lastOffsetDelta);
        buffer.putLong(position + 43, producerId);
        buffer.putShort(position + 51, epoch);
        buffer.putInt(position + 53, sequence);
        buffer.putInt(position + 57, numRecords);
        long crc = Crc32C.compute(buffer, 21, sizeInBytes - 21);
        buffer.putInt(position + 17, (int)crc);
        buffer.position(position + 61);
    }

    public String toString() {
        return "RecordBatch(magic=" + this.magic() + ", offsets=[" + this.baseOffset() + ", " + this.lastOffset() + "], compression=" + (Object)((Object)this.compressionType()) + ", timestampType=" + (Object)((Object)this.timestampType()) + ", crc=" + this.checksum() + ")";
    }

    public static int sizeInBytes(long baseOffset, Iterable<Record> records) {
        Iterator<Record> iterator = records.iterator();
        if (!iterator.hasNext()) {
            return 0;
        }
        int size = 61;
        Long firstTimestamp = null;
        while (iterator.hasNext()) {
            Record record = iterator.next();
            int offsetDelta = (int)(record.offset() - baseOffset);
            if (firstTimestamp == null) {
                firstTimestamp = record.timestamp();
            }
            long timestampDelta = record.timestamp() - firstTimestamp;
            size += DefaultRecord.sizeInBytes(offsetDelta, timestampDelta, record.key(), record.value(), record.headers());
        }
        return size;
    }

    public static int sizeInBytes(Iterable<SimpleRecord> records) {
        Iterator<SimpleRecord> iterator = records.iterator();
        if (!iterator.hasNext()) {
            return 0;
        }
        int size = 61;
        int offsetDelta = 0;
        Long firstTimestamp = null;
        while (iterator.hasNext()) {
            SimpleRecord record = iterator.next();
            if (firstTimestamp == null) {
                firstTimestamp = record.timestamp();
            }
            long timestampDelta = record.timestamp() - firstTimestamp;
            size += DefaultRecord.sizeInBytes(offsetDelta++, timestampDelta, record.key(), record.value(), record.headers());
        }
        return size;
    }

    static int estimateBatchSizeUpperBound(ByteBuffer key, ByteBuffer value, Header[] headers) {
        return 61 + DefaultRecord.recordSizeUpperBound(key, value, headers);
    }

    public static int incrementSequence(int sequence, int increment) {
        if (sequence > Integer.MAX_VALUE - increment) {
            return increment - (Integer.MAX_VALUE - sequence) - 1;
        }
        return sequence + increment;
    }

    public static int decrementSequence(int sequence, int decrement) {
        if (sequence < decrement) {
            return Integer.MAX_VALUE - (decrement - sequence) + 1;
        }
        return sequence - decrement;
    }

    static class DefaultFileChannelRecordBatch
    extends FileLogInputStream.FileChannelRecordBatch {
        DefaultFileChannelRecordBatch(long offset, byte magic, FileRecords fileRecords, int position, int batchSize) {
            super(offset, magic, fileRecords, position, batchSize);
        }

        @Override
        protected RecordBatch toMemoryRecordBatch(ByteBuffer buffer) {
            return new DefaultRecordBatch(buffer);
        }

        @Override
        public long baseOffset() {
            return this.offset;
        }

        @Override
        public long lastOffset() {
            return this.loadBatchHeader().lastOffset();
        }

        @Override
        public long producerId() {
            return this.loadBatchHeader().producerId();
        }

        @Override
        public short producerEpoch() {
            return this.loadBatchHeader().producerEpoch();
        }

        @Override
        public int baseSequence() {
            return this.loadBatchHeader().baseSequence();
        }

        @Override
        public int lastSequence() {
            return this.loadBatchHeader().lastSequence();
        }

        @Override
        public long checksum() {
            return this.loadBatchHeader().checksum();
        }

        @Override
        public Integer countOrNull() {
            return this.loadBatchHeader().countOrNull();
        }

        @Override
        public boolean isTransactional() {
            return this.loadBatchHeader().isTransactional();
        }

        @Override
        public boolean isControlBatch() {
            return this.loadBatchHeader().isControlBatch();
        }

        @Override
        public int partitionLeaderEpoch() {
            return this.loadBatchHeader().partitionLeaderEpoch();
        }

        @Override
        protected int headerSize() {
            return 61;
        }
    }

    private abstract class StreamRecordIterator
    extends RecordIterator {
        private final DataInputStream inputStream;

        StreamRecordIterator(DataInputStream inputStream) {
            this.inputStream = inputStream;
        }

        abstract Record doReadRecord(long var1, long var3, int var5, Long var6) throws IOException;

        @Override
        protected Record readNext(long baseOffset, long firstTimestamp, int baseSequence, Long logAppendTime) {
            try {
                return this.doReadRecord(baseOffset, firstTimestamp, baseSequence, logAppendTime);
            }
            catch (EOFException e) {
                throw new InvalidRecordException("Incorrect declared batch size, premature EOF reached");
            }
            catch (IOException e) {
                throw new KafkaException("Failed to decompress record stream", e);
            }
        }

        @Override
        protected boolean ensureNoneRemaining() {
            try {
                return this.inputStream.read() == -1;
            }
            catch (IOException e) {
                throw new KafkaException("Error checking for remaining bytes after reading batch", e);
            }
        }

        @Override
        public void close() {
            try {
                this.inputStream.close();
            }
            catch (IOException e) {
                throw new KafkaException("Failed to close record stream", e);
            }
        }
    }

    private abstract class RecordIterator
    implements CloseableIterator<Record> {
        private final Long logAppendTime;
        private final long baseOffset;
        private final long firstTimestamp;
        private final int baseSequence;
        private final int numRecords;
        private int readRecords = 0;

        RecordIterator() {
            this.logAppendTime = DefaultRecordBatch.this.timestampType() == TimestampType.LOG_APPEND_TIME ? Long.valueOf(DefaultRecordBatch.this.maxTimestamp()) : null;
            this.baseOffset = DefaultRecordBatch.this.baseOffset();
            this.firstTimestamp = DefaultRecordBatch.this.firstTimestamp();
            this.baseSequence = DefaultRecordBatch.this.baseSequence();
            int numRecords = DefaultRecordBatch.this.count();
            if (numRecords < 0) {
                throw new InvalidRecordException("Found invalid record count " + numRecords + " in magic v" + DefaultRecordBatch.this.magic() + " batch");
            }
            this.numRecords = numRecords;
        }

        @Override
        public boolean hasNext() {
            return this.readRecords < this.numRecords;
        }

        @Override
        public Record next() {
            if (this.readRecords >= this.numRecords) {
                throw new NoSuchElementException();
            }
            ++this.readRecords;
            Record rec = this.readNext(this.baseOffset, this.firstTimestamp, this.baseSequence, this.logAppendTime);
            if (this.readRecords == this.numRecords && !this.ensureNoneRemaining()) {
                throw new InvalidRecordException("Incorrect declared batch size, records still remaining in file");
            }
            return rec;
        }

        protected abstract Record readNext(long var1, long var3, int var5, Long var6);

        protected abstract boolean ensureNoneRemaining();

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

