/*
 * Decompiled with CFR 0.152.
 */
package shaded.alink.kafka.org.apache.kafka.common.protocol;

import java.nio.ByteBuffer;
import shaded.alink.kafka.org.apache.kafka.common.protocol.Readable;
import shaded.alink.kafka.org.apache.kafka.common.protocol.Writable;
import shaded.alink.kafka.org.apache.kafka.common.utils.ByteUtils;

public class ByteBufferAccessor
implements Readable,
Writable {
    private final ByteBuffer buf;

    public ByteBufferAccessor(ByteBuffer buf) {
        this.buf = buf;
    }

    @Override
    public byte readByte() {
        return this.buf.get();
    }

    @Override
    public short readShort() {
        return this.buf.getShort();
    }

    @Override
    public int readInt() {
        return this.buf.getInt();
    }

    @Override
    public long readLong() {
        return this.buf.getLong();
    }

    @Override
    public void readArray(byte[] arr) {
        this.buf.get(arr);
    }

    @Override
    public int readUnsignedVarint() {
        return ByteUtils.readUnsignedVarint(this.buf);
    }

    @Override
    public void writeByte(byte val) {
        this.buf.put(val);
    }

    @Override
    public void writeShort(short val) {
        this.buf.putShort(val);
    }

    @Override
    public void writeInt(int val) {
        this.buf.putInt(val);
    }

    @Override
    public void writeLong(long val) {
        this.buf.putLong(val);
    }

    @Override
    public void writeByteArray(byte[] arr) {
        this.buf.put(arr);
    }

    @Override
    public void writeUnsignedVarint(int i) {
        ByteUtils.writeUnsignedVarint(i, this.buf);
    }
}

