/*
 * Decompiled with CFR 0.152.
 */
package shaded.alink.kafka.org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import shaded.alink.kafka.org.apache.kafka.common.errors.UnsupportedVersionException;
import shaded.alink.kafka.org.apache.kafka.common.protocol.ApiMessage;
import shaded.alink.kafka.org.apache.kafka.common.protocol.ObjectSerializationCache;
import shaded.alink.kafka.org.apache.kafka.common.protocol.Readable;
import shaded.alink.kafka.org.apache.kafka.common.protocol.Writable;
import shaded.alink.kafka.org.apache.kafka.common.protocol.types.Field;
import shaded.alink.kafka.org.apache.kafka.common.protocol.types.RawTaggedField;
import shaded.alink.kafka.org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import shaded.alink.kafka.org.apache.kafka.common.protocol.types.Schema;
import shaded.alink.kafka.org.apache.kafka.common.protocol.types.Struct;
import shaded.alink.kafka.org.apache.kafka.common.protocol.types.Type;
import shaded.alink.kafka.org.apache.kafka.common.utils.ByteUtils;
import shaded.alink.kafka.org.apache.kafka.common.utils.Bytes;

public class SaslAuthenticateResponseData
implements ApiMessage {
    private short errorCode;
    private String errorMessage;
    private byte[] authBytes;
    private long sessionLifetimeMs;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("error_code", Type.INT16, "The error code, or 0 if there was no error."), new Field("error_message", Type.NULLABLE_STRING, "The error message, or null if there was no error."), new Field("auth_bytes", Type.BYTES, "The SASL authentication bytes from the server, as defined by the SASL mechanism."));
    public static final Schema SCHEMA_1 = new Schema(new Field("error_code", Type.INT16, "The error code, or 0 if there was no error."), new Field("error_message", Type.NULLABLE_STRING, "The error message, or null if there was no error."), new Field("auth_bytes", Type.BYTES, "The SASL authentication bytes from the server, as defined by the SASL mechanism."), new Field("session_lifetime_ms", Type.INT64, "The SASL authentication bytes from the server, as defined by the SASL mechanism."));
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};

    public SaslAuthenticateResponseData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public SaslAuthenticateResponseData(Struct struct, short _version) {
        this.fromStruct(struct, _version);
    }

    public SaslAuthenticateResponseData() {
        this.errorCode = 0;
        this.errorMessage = "";
        this.authBytes = Bytes.EMPTY;
        this.sessionLifetimeMs = 0L;
    }

    @Override
    public short apiKey() {
        return 36;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 1;
    }

    @Override
    public void read(Readable _readable, short _version) {
        this.errorCode = _readable.readShort();
        int length = _readable.readShort();
        if (length < 0) {
            this.errorMessage = null;
        } else {
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field errorMessage had invalid length " + length);
            }
            this.errorMessage = _readable.readString(length);
        }
        length = _readable.readInt();
        if (length < 0) {
            throw new RuntimeException("non-nullable field authBytes was serialized as null");
        }
        byte[] newBytes = new byte[length];
        _readable.readArray(newBytes);
        this.authBytes = newBytes;
        this.sessionLifetimeMs = _version >= 1 ? _readable.readLong() : 0L;
        this._unknownTaggedFields = null;
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _writable.writeShort(this.errorCode);
        if (this.errorMessage == null) {
            _writable.writeShort((short)-1);
        } else {
            byte[] _stringBytes = _cache.getSerializedValue(this.errorMessage);
            _writable.writeShort((short)_stringBytes.length);
            _writable.writeByteArray(_stringBytes);
        }
        _writable.writeInt(this.authBytes.length);
        _writable.writeByteArray(this.authBytes);
        if (_version >= 1) {
            _writable.writeLong(this.sessionLifetimeMs);
        } else if (this.sessionLifetimeMs != 0L) {
            throw new UnsupportedVersionException("Attempted to write a non-default sessionLifetimeMs at version " + _version);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    @Override
    public void fromStruct(Struct struct, short _version) {
        this._unknownTaggedFields = null;
        this.errorCode = struct.getShort("error_code");
        this.errorMessage = struct.getString("error_message");
        this.authBytes = struct.getByteArray("auth_bytes");
        this.sessionLifetimeMs = _version >= 1 ? struct.getLong("session_lifetime_ms") : 0L;
    }

    @Override
    public Struct toStruct(short _version) {
        Object _taggedFields = null;
        Struct struct = new Struct(SCHEMAS[_version]);
        struct.set("error_code", (Object)this.errorCode);
        struct.set("error_message", (Object)this.errorMessage);
        struct.setByteArray("auth_bytes", this.authBytes);
        if (_version >= 1) {
            struct.set("session_lifetime_ms", (Object)this.sessionLifetimeMs);
        }
        return struct;
    }

    @Override
    public int size(ObjectSerializationCache _cache, short _version) {
        int _size = 0;
        int _numTaggedFields = 0;
        _size += 2;
        if (this.errorMessage == null) {
            _size += 2;
        } else {
            byte[] _stringBytes = this.errorMessage.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'errorMessage' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.errorMessage, _stringBytes);
            _size += _stringBytes.length + 2;
        }
        int _bytesSize = this.authBytes.length;
        _size += (_bytesSize += 4);
        if (_version >= 1) {
            _size += 8;
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                _size += _field.size();
            }
        }
        if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
        return _size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SaslAuthenticateResponseData)) {
            return false;
        }
        SaslAuthenticateResponseData other = (SaslAuthenticateResponseData)obj;
        if (this.errorCode != other.errorCode) {
            return false;
        }
        if (this.errorMessage == null ? other.errorMessage != null : !this.errorMessage.equals(other.errorMessage)) {
            return false;
        }
        if (!Arrays.equals(this.authBytes, other.authBytes)) {
            return false;
        }
        return this.sessionLifetimeMs == other.sessionLifetimeMs;
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.errorCode;
        hashCode = 31 * hashCode + (this.errorMessage == null ? 0 : this.errorMessage.hashCode());
        hashCode = 31 * hashCode + Arrays.hashCode(this.authBytes);
        hashCode = 31 * hashCode + ((int)(this.sessionLifetimeMs >> 32) ^ (int)this.sessionLifetimeMs);
        return hashCode;
    }

    public String toString() {
        return "SaslAuthenticateResponseData(errorCode=" + this.errorCode + ", errorMessage=" + (this.errorMessage == null ? "null" : "'" + this.errorMessage.toString() + "'") + ", authBytes=" + Arrays.toString(this.authBytes) + ", sessionLifetimeMs=" + this.sessionLifetimeMs + ")";
    }

    public short errorCode() {
        return this.errorCode;
    }

    public String errorMessage() {
        return this.errorMessage;
    }

    public byte[] authBytes() {
        return this.authBytes;
    }

    public long sessionLifetimeMs() {
        return this.sessionLifetimeMs;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public SaslAuthenticateResponseData setErrorCode(short v) {
        this.errorCode = v;
        return this;
    }

    public SaslAuthenticateResponseData setErrorMessage(String v) {
        this.errorMessage = v;
        return this;
    }

    public SaslAuthenticateResponseData setAuthBytes(byte[] v) {
        this.authBytes = v;
        return this;
    }

    public SaslAuthenticateResponseData setSessionLifetimeMs(long v) {
        this.sessionLifetimeMs = v;
        return this;
    }
}

