/*
 * Decompiled with CFR 0.152.
 */
package shaded.alink.kafka.org.apache.kafka.common;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import shaded.alink.kafka.org.apache.kafka.common.ClusterResource;
import shaded.alink.kafka.org.apache.kafka.common.Node;
import shaded.alink.kafka.org.apache.kafka.common.PartitionInfo;
import shaded.alink.kafka.org.apache.kafka.common.TopicPartition;

public final class Cluster {
    private final boolean isBootstrapConfigured;
    private final List<Node> nodes;
    private final Set<String> unauthorizedTopics;
    private final Set<String> invalidTopics;
    private final Set<String> internalTopics;
    private final Node controller;
    private final Map<TopicPartition, PartitionInfo> partitionsByTopicPartition;
    private final Map<String, List<PartitionInfo>> partitionsByTopic;
    private final Map<String, List<PartitionInfo>> availablePartitionsByTopic;
    private final Map<Integer, List<PartitionInfo>> partitionsByNode;
    private final Map<Integer, Node> nodesById;
    private final ClusterResource clusterResource;

    public Cluster(String clusterId, Collection<Node> nodes, Collection<PartitionInfo> partitions, Set<String> unauthorizedTopics, Set<String> internalTopics) {
        this(clusterId, false, nodes, partitions, unauthorizedTopics, Collections.emptySet(), internalTopics, null);
    }

    public Cluster(String clusterId, Collection<Node> nodes, Collection<PartitionInfo> partitions, Set<String> unauthorizedTopics, Set<String> internalTopics, Node controller) {
        this(clusterId, false, nodes, partitions, unauthorizedTopics, Collections.emptySet(), internalTopics, controller);
    }

    public Cluster(String clusterId, Collection<Node> nodes, Collection<PartitionInfo> partitions, Set<String> unauthorizedTopics, Set<String> invalidTopics, Set<String> internalTopics, Node controller) {
        this(clusterId, false, nodes, partitions, unauthorizedTopics, invalidTopics, internalTopics, controller);
    }

    private Cluster(String clusterId, boolean isBootstrapConfigured, Collection<Node> nodes, Collection<PartitionInfo> partitions, Set<String> unauthorizedTopics, Set<String> invalidTopics, Set<String> internalTopics, Node controller) {
        this.isBootstrapConfigured = isBootstrapConfigured;
        this.clusterResource = new ClusterResource(clusterId);
        ArrayList<Node> copy = new ArrayList<Node>(nodes);
        Collections.shuffle(copy);
        this.nodes = Collections.unmodifiableList(copy);
        HashMap<Integer, Node> tmpNodesById = new HashMap<Integer, Node>();
        HashMap<Integer, List<Object>> tmpPartitionsByNode = new HashMap<Integer, List<Object>>(nodes.size());
        for (Node node : nodes) {
            tmpNodesById.put(node.id(), node);
            tmpPartitionsByNode.put(node.id(), new ArrayList());
        }
        this.nodesById = Collections.unmodifiableMap(tmpNodesById);
        HashMap<TopicPartition, PartitionInfo> tmpPartitionsByTopicPartition = new HashMap<TopicPartition, PartitionInfo>(partitions.size());
        HashMap<String, List<PartitionInfo>> tmpPartitionsByTopic = new HashMap<String, List<PartitionInfo>>();
        for (PartitionInfo partitionInfo : partitions) {
            tmpPartitionsByTopicPartition.put(new TopicPartition(partitionInfo.topic(), partitionInfo.partition()), partitionInfo);
            ArrayList<PartitionInfo> partitionsForTopic = (ArrayList<PartitionInfo>)tmpPartitionsByTopic.get(partitionInfo.topic());
            if (partitionsForTopic == null) {
                partitionsForTopic = new ArrayList<PartitionInfo>();
                tmpPartitionsByTopic.put(partitionInfo.topic(), partitionsForTopic);
            }
            partitionsForTopic.add(partitionInfo);
            if (partitionInfo.leader() == null) continue;
            List partitionsForNode = (List)Objects.requireNonNull(tmpPartitionsByNode.get(partitionInfo.leader().id()));
            partitionsForNode.add(partitionInfo);
        }
        for (Map.Entry entry : tmpPartitionsByNode.entrySet()) {
            tmpPartitionsByNode.put((Integer)entry.getKey(), Collections.unmodifiableList((List)entry.getValue()));
        }
        HashMap<String, List<PartitionInfo>> tmpAvailablePartitionsByTopic = new HashMap<String, List<PartitionInfo>>(tmpPartitionsByTopic.size());
        for (Map.Entry entry : tmpPartitionsByTopic.entrySet()) {
            List<PartitionInfo> availablePartitionsForTopic;
            String topic = (String)entry.getKey();
            List<PartitionInfo> partitionsForTopic = Collections.unmodifiableList((List)entry.getValue());
            tmpPartitionsByTopic.put(topic, partitionsForTopic);
            boolean foundUnavailablePartition = partitionsForTopic.stream().anyMatch(p -> p.leader() == null);
            if (foundUnavailablePartition) {
                availablePartitionsForTopic = new ArrayList<PartitionInfo>(partitionsForTopic.size());
                for (PartitionInfo p3 : partitionsForTopic) {
                    if (p3.leader() == null) continue;
                    availablePartitionsForTopic.add(p3);
                }
                availablePartitionsForTopic = Collections.unmodifiableList(availablePartitionsForTopic);
            } else {
                availablePartitionsForTopic = partitionsForTopic;
            }
            tmpAvailablePartitionsByTopic.put(topic, availablePartitionsForTopic);
        }
        this.partitionsByTopicPartition = Collections.unmodifiableMap(tmpPartitionsByTopicPartition);
        this.partitionsByTopic = Collections.unmodifiableMap(tmpPartitionsByTopic);
        this.availablePartitionsByTopic = Collections.unmodifiableMap(tmpAvailablePartitionsByTopic);
        this.partitionsByNode = Collections.unmodifiableMap(tmpPartitionsByNode);
        this.unauthorizedTopics = Collections.unmodifiableSet(unauthorizedTopics);
        this.invalidTopics = Collections.unmodifiableSet(invalidTopics);
        this.internalTopics = Collections.unmodifiableSet(internalTopics);
        this.controller = controller;
    }

    public static Cluster empty() {
        return new Cluster(null, new ArrayList<Node>(0), new ArrayList<PartitionInfo>(0), Collections.emptySet(), Collections.emptySet(), null);
    }

    public static Cluster bootstrap(List<InetSocketAddress> addresses) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        int nodeId = -1;
        for (InetSocketAddress address : addresses) {
            nodes.add(new Node(nodeId--, address.getHostString(), address.getPort()));
        }
        return new Cluster(null, true, nodes, new ArrayList<PartitionInfo>(0), Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), null);
    }

    public Cluster withPartitions(Map<TopicPartition, PartitionInfo> partitions) {
        HashMap<TopicPartition, PartitionInfo> combinedPartitions = new HashMap<TopicPartition, PartitionInfo>(this.partitionsByTopicPartition);
        combinedPartitions.putAll(partitions);
        return new Cluster(this.clusterResource.clusterId(), this.nodes, combinedPartitions.values(), new HashSet<String>(this.unauthorizedTopics), new HashSet<String>(this.invalidTopics), new HashSet<String>(this.internalTopics), this.controller);
    }

    public List<Node> nodes() {
        return this.nodes;
    }

    public Node nodeById(int id) {
        return this.nodesById.get(id);
    }

    public Optional<Node> nodeIfOnline(TopicPartition partition, int id) {
        Node node = this.nodeById(id);
        if (node != null && !Arrays.asList(this.partition(partition).offlineReplicas()).contains(node)) {
            return Optional.of(node);
        }
        return Optional.empty();
    }

    public Node leaderFor(TopicPartition topicPartition) {
        PartitionInfo info = this.partitionsByTopicPartition.get(topicPartition);
        if (info == null) {
            return null;
        }
        return info.leader();
    }

    public PartitionInfo partition(TopicPartition topicPartition) {
        return this.partitionsByTopicPartition.get(topicPartition);
    }

    public List<PartitionInfo> partitionsForTopic(String topic) {
        return this.partitionsByTopic.getOrDefault(topic, Collections.emptyList());
    }

    public Integer partitionCountForTopic(String topic) {
        List<PartitionInfo> partitions = this.partitionsByTopic.get(topic);
        return partitions == null ? null : Integer.valueOf(partitions.size());
    }

    public List<PartitionInfo> availablePartitionsForTopic(String topic) {
        return this.availablePartitionsByTopic.getOrDefault(topic, Collections.emptyList());
    }

    public List<PartitionInfo> partitionsForNode(int nodeId) {
        return this.partitionsByNode.getOrDefault(nodeId, Collections.emptyList());
    }

    public Set<String> topics() {
        return this.partitionsByTopic.keySet();
    }

    public Set<String> unauthorizedTopics() {
        return this.unauthorizedTopics;
    }

    public Set<String> invalidTopics() {
        return this.invalidTopics;
    }

    public Set<String> internalTopics() {
        return this.internalTopics;
    }

    public boolean isBootstrapConfigured() {
        return this.isBootstrapConfigured;
    }

    public ClusterResource clusterResource() {
        return this.clusterResource;
    }

    public Node controller() {
        return this.controller;
    }

    public String toString() {
        return "Cluster(id = " + this.clusterResource.clusterId() + ", nodes = " + this.nodes + ", partitions = " + this.partitionsByTopicPartition.values() + ", controller = " + this.controller + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Cluster cluster = (Cluster)o;
        return this.isBootstrapConfigured == cluster.isBootstrapConfigured && Objects.equals(this.nodes, cluster.nodes) && Objects.equals(this.unauthorizedTopics, cluster.unauthorizedTopics) && Objects.equals(this.invalidTopics, cluster.invalidTopics) && Objects.equals(this.internalTopics, cluster.internalTopics) && Objects.equals(this.controller, cluster.controller) && Objects.equals(this.partitionsByTopicPartition, cluster.partitionsByTopicPartition) && Objects.equals(this.clusterResource, cluster.clusterResource);
    }

    public int hashCode() {
        return Objects.hash(this.isBootstrapConfigured, this.nodes, this.unauthorizedTopics, this.invalidTopics, this.internalTopics, this.controller, this.partitionsByTopicPartition, this.clusterResource);
    }
}

