/*
 * Decompiled with CFR 0.152.
 */
package shaded.alink.kafka.org.apache.kafka.clients.producer.internals;

import java.util.Locale;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import shaded.alink.kafka.org.apache.kafka.common.errors.InterruptException;
import shaded.alink.kafka.org.apache.kafka.common.errors.TimeoutException;

public final class TransactionalRequestResult {
    private final CountDownLatch latch;
    private volatile RuntimeException error = null;
    private final String operation;

    public TransactionalRequestResult(String operation) {
        this(new CountDownLatch(1), operation);
    }

    private TransactionalRequestResult(CountDownLatch latch, String operation) {
        this.latch = latch;
        this.operation = operation;
    }

    public void setError(RuntimeException error) {
        this.error = error;
    }

    public void done() {
        this.latch.countDown();
    }

    public void await() {
        boolean completed = false;
        while (!completed) {
            try {
                this.latch.await();
                completed = true;
            }
            catch (InterruptedException interruptedException) {}
        }
        if (!this.isSuccessful()) {
            throw this.error();
        }
    }

    public void await(long timeout, TimeUnit unit) {
        try {
            boolean success = this.latch.await(timeout, unit);
            if (!this.isSuccessful()) {
                throw this.error();
            }
            if (!success) {
                throw new TimeoutException("Timeout expired after " + timeout + unit.name().toLowerCase(Locale.ROOT) + " while awaiting " + this.operation);
            }
        }
        catch (InterruptedException e) {
            throw new InterruptException("Received interrupt while awaiting " + this.operation, e);
        }
    }

    public RuntimeException error() {
        return this.error;
    }

    public boolean isSuccessful() {
        return this.error == null;
    }

    public boolean isCompleted() {
        return this.latch.getCount() == 0L;
    }
}

