/*
 * Decompiled with CFR 0.152.
 */
package shaded.alink.kafka.org.apache.kafka.clients.consumer.internals;

import shaded.alink.kafka.org.apache.kafka.clients.GroupRebalanceConfig;
import shaded.alink.kafka.org.apache.kafka.common.utils.Time;
import shaded.alink.kafka.org.apache.kafka.common.utils.Timer;

public final class Heartbeat {
    private final int maxPollIntervalMs;
    private final GroupRebalanceConfig rebalanceConfig;
    private final Time time;
    private final Timer heartbeatTimer;
    private final Timer sessionTimer;
    private final Timer pollTimer;
    private volatile long lastHeartbeatSend = 0L;

    public Heartbeat(GroupRebalanceConfig config, Time time) {
        if (config.heartbeatIntervalMs >= config.sessionTimeoutMs) {
            throw new IllegalArgumentException("Heartbeat must be set lower than the session timeout");
        }
        this.rebalanceConfig = config;
        this.time = time;
        this.heartbeatTimer = time.timer(config.heartbeatIntervalMs);
        this.sessionTimer = time.timer(config.sessionTimeoutMs);
        this.maxPollIntervalMs = config.rebalanceTimeoutMs;
        this.pollTimer = time.timer(this.maxPollIntervalMs);
    }

    private void update(long now) {
        this.heartbeatTimer.update(now);
        this.sessionTimer.update(now);
        this.pollTimer.update(now);
    }

    public void poll(long now) {
        this.update(now);
        this.pollTimer.reset(this.maxPollIntervalMs);
    }

    public void sentHeartbeat(long now) {
        this.lastHeartbeatSend = now;
        this.update(now);
        this.heartbeatTimer.reset(this.rebalanceConfig.heartbeatIntervalMs);
    }

    public void failHeartbeat() {
        this.update(this.time.milliseconds());
        this.heartbeatTimer.reset(this.rebalanceConfig.retryBackoffMs);
    }

    public void receiveHeartbeat() {
        this.update(this.time.milliseconds());
        this.sessionTimer.reset(this.rebalanceConfig.sessionTimeoutMs);
    }

    public boolean shouldHeartbeat(long now) {
        this.update(now);
        return this.heartbeatTimer.isExpired();
    }

    public long lastHeartbeatSend() {
        return this.lastHeartbeatSend;
    }

    public long timeToNextHeartbeat(long now) {
        this.update(now);
        return this.heartbeatTimer.remainingMs();
    }

    public boolean sessionTimeoutExpired(long now) {
        this.update(now);
        return this.sessionTimer.isExpired();
    }

    public void resetTimeouts() {
        this.update(this.time.milliseconds());
        this.sessionTimer.reset(this.rebalanceConfig.sessionTimeoutMs);
        this.pollTimer.reset(this.maxPollIntervalMs);
        this.heartbeatTimer.reset(this.rebalanceConfig.heartbeatIntervalMs);
    }

    public void resetSessionTimeout() {
        this.update(this.time.milliseconds());
        this.sessionTimer.reset(this.rebalanceConfig.sessionTimeoutMs);
    }

    public boolean pollTimeoutExpired(long now) {
        this.update(now);
        return this.pollTimer.isExpired();
    }

    public long lastPollTime() {
        return this.pollTimer.currentTimeMs();
    }
}

