/*
 * Decompiled with CFR 0.152.
 */
package shaded.alink.kafka.org.apache.kafka.clients.consumer.internals;

import org.slf4j.Logger;
import shaded.alink.kafka.org.apache.kafka.clients.ClientResponse;
import shaded.alink.kafka.org.apache.kafka.clients.consumer.internals.ConsumerNetworkClient;
import shaded.alink.kafka.org.apache.kafka.clients.consumer.internals.RequestFuture;
import shaded.alink.kafka.org.apache.kafka.clients.consumer.internals.RequestFutureAdapter;
import shaded.alink.kafka.org.apache.kafka.common.Node;
import shaded.alink.kafka.org.apache.kafka.common.requests.AbstractRequest;
import shaded.alink.kafka.org.apache.kafka.common.requests.AbstractResponse;
import shaded.alink.kafka.org.apache.kafka.common.utils.LogContext;

public abstract class AsyncClient<T1, Req extends AbstractRequest, Resp extends AbstractResponse, T2> {
    private final Logger log;
    private final ConsumerNetworkClient client;

    AsyncClient(ConsumerNetworkClient client, LogContext logContext) {
        this.client = client;
        this.log = logContext.logger(this.getClass());
    }

    public RequestFuture<T2> sendAsyncRequest(final Node node, final T1 requestData) {
        AbstractRequest.Builder<Req> requestBuilder = this.prepareRequest(node, requestData);
        return this.client.send(node, requestBuilder).compose(new RequestFutureAdapter<ClientResponse, T2>(){

            @Override
            public void onSuccess(ClientResponse value, RequestFuture<T2> future) {
                block4: {
                    AbstractResponse resp;
                    try {
                        resp = value.responseBody();
                    }
                    catch (ClassCastException cce) {
                        AsyncClient.this.log.error("Could not cast response body", cce);
                        future.raise(cce);
                        return;
                    }
                    AsyncClient.this.log.trace("Received {} {} from broker {}", resp.getClass().getSimpleName(), resp, node);
                    try {
                        future.complete(AsyncClient.this.handleResponse(node, requestData, resp));
                    }
                    catch (RuntimeException e) {
                        if (future.isDone()) break block4;
                        future.raise(e);
                    }
                }
            }

            @Override
            public void onFailure(RuntimeException e, RequestFuture<T2> future1) {
                future1.raise(e);
            }
        });
    }

    protected Logger logger() {
        return this.log;
    }

    protected abstract AbstractRequest.Builder<Req> prepareRequest(Node var1, T1 var2);

    protected abstract T2 handleResponse(Node var1, T1 var2, Resp var3);
}

