/*
 * Decompiled with CFR 0.152.
 */
package shaded.alink.kafka.org.apache.kafka.clients.consumer;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import shaded.alink.kafka.org.apache.kafka.clients.consumer.ConsumerGroupMetadata;
import shaded.alink.kafka.org.apache.kafka.clients.consumer.ConsumerPartitionAssignor;
import shaded.alink.kafka.org.apache.kafka.clients.consumer.internals.AbstractStickyAssignor;
import shaded.alink.kafka.org.apache.kafka.common.TopicPartition;
import shaded.alink.kafka.org.apache.kafka.common.protocol.types.ArrayOf;
import shaded.alink.kafka.org.apache.kafka.common.protocol.types.Field;
import shaded.alink.kafka.org.apache.kafka.common.protocol.types.Schema;
import shaded.alink.kafka.org.apache.kafka.common.protocol.types.Struct;
import shaded.alink.kafka.org.apache.kafka.common.protocol.types.Type;
import shaded.alink.kafka.org.apache.kafka.common.utils.CollectionUtils;

public class StickyAssignor
extends AbstractStickyAssignor {
    static final String TOPIC_PARTITIONS_KEY_NAME = "previous_assignment";
    static final String TOPIC_KEY_NAME = "topic";
    static final String PARTITIONS_KEY_NAME = "partitions";
    private static final String GENERATION_KEY_NAME = "generation";
    static final Schema TOPIC_ASSIGNMENT = new Schema(new Field("topic", Type.STRING), new Field("partitions", new ArrayOf(Type.INT32)));
    static final Schema STICKY_ASSIGNOR_USER_DATA_V0 = new Schema(new Field("previous_assignment", new ArrayOf(TOPIC_ASSIGNMENT)));
    private static final Schema STICKY_ASSIGNOR_USER_DATA_V1 = new Schema(new Field("previous_assignment", new ArrayOf(TOPIC_ASSIGNMENT)), new Field("generation", Type.INT32));
    private List<TopicPartition> memberAssignment = null;
    private int generation = -1;

    @Override
    public String name() {
        return "sticky";
    }

    @Override
    public void onAssignment(ConsumerPartitionAssignor.Assignment assignment, ConsumerGroupMetadata metadata) {
        this.memberAssignment = assignment.partitions();
        this.generation = metadata.generationId();
    }

    @Override
    public ByteBuffer subscriptionUserData(Set<String> topics) {
        if (this.memberAssignment == null) {
            return null;
        }
        return StickyAssignor.serializeTopicPartitionAssignment(new AbstractStickyAssignor.MemberData(this.memberAssignment, Optional.of(this.generation)));
    }

    @Override
    protected AbstractStickyAssignor.MemberData memberData(ConsumerPartitionAssignor.Subscription subscription) {
        ByteBuffer userData = subscription.userData();
        if (userData == null || !userData.hasRemaining()) {
            return new AbstractStickyAssignor.MemberData(Collections.emptyList(), Optional.empty());
        }
        return StickyAssignor.deserializeTopicPartitionAssignment(userData);
    }

    static ByteBuffer serializeTopicPartitionAssignment(AbstractStickyAssignor.MemberData memberData) {
        Struct struct = new Struct(STICKY_ASSIGNOR_USER_DATA_V1);
        ArrayList<Struct> topicAssignments = new ArrayList<Struct>();
        for (Map.Entry<String, List<Integer>> topicEntry : CollectionUtils.groupPartitionsByTopic(memberData.partitions).entrySet()) {
            Struct topicAssignment = new Struct(TOPIC_ASSIGNMENT);
            topicAssignment.set(TOPIC_KEY_NAME, (Object)topicEntry.getKey());
            topicAssignment.set(PARTITIONS_KEY_NAME, (Object)topicEntry.getValue().toArray());
            topicAssignments.add(topicAssignment);
        }
        struct.set(TOPIC_PARTITIONS_KEY_NAME, (Object)topicAssignments.toArray());
        if (memberData.generation.isPresent()) {
            struct.set(GENERATION_KEY_NAME, (Object)memberData.generation.get());
        }
        ByteBuffer buffer = ByteBuffer.allocate(STICKY_ASSIGNOR_USER_DATA_V1.sizeOf(struct));
        STICKY_ASSIGNOR_USER_DATA_V1.write(buffer, struct);
        buffer.flip();
        return buffer;
    }

    private static AbstractStickyAssignor.MemberData deserializeTopicPartitionAssignment(ByteBuffer buffer) {
        Struct struct;
        ByteBuffer copy = buffer.duplicate();
        try {
            struct = STICKY_ASSIGNOR_USER_DATA_V1.read(buffer);
        }
        catch (Exception e1) {
            try {
                struct = STICKY_ASSIGNOR_USER_DATA_V0.read(copy);
            }
            catch (Exception e2) {
                return new AbstractStickyAssignor.MemberData(Collections.emptyList(), Optional.of(-1));
            }
        }
        ArrayList<TopicPartition> partitions = new ArrayList<TopicPartition>();
        for (Object structObj : struct.getArray(TOPIC_PARTITIONS_KEY_NAME)) {
            Struct assignment = (Struct)structObj;
            String topic = assignment.getString(TOPIC_KEY_NAME);
            for (Object partitionObj : assignment.getArray(PARTITIONS_KEY_NAME)) {
                Integer partition = (Integer)partitionObj;
                partitions.add(new TopicPartition(topic, partition));
            }
        }
        Optional<Integer> generation = struct.hasField(GENERATION_KEY_NAME) ? Optional.of(struct.getInt(GENERATION_KEY_NAME)) : Optional.empty();
        return new AbstractStickyAssignor.MemberData(partitions, generation);
    }
}

