/*
 * Decompiled with CFR 0.152.
 */
package shaded.alink.kafka.org.apache.kafka.clients.admin;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import shaded.alink.kafka.org.apache.kafka.common.message.CreateTopicsRequestData;

public class NewTopic {
    private static final int NO_PARTITIONS = -1;
    private static final short NO_REPLICATION_FACTOR = -1;
    private final String name;
    private final Optional<Integer> numPartitions;
    private final Optional<Short> replicationFactor;
    private final Map<Integer, List<Integer>> replicasAssignments;
    private Map<String, String> configs = null;

    public NewTopic(String name, int numPartitions, short replicationFactor) {
        this(name, Optional.of(numPartitions), Optional.of(replicationFactor));
    }

    public NewTopic(String name, Optional<Integer> numPartitions, Optional<Short> replicationFactor) {
        this.name = name;
        this.numPartitions = numPartitions;
        this.replicationFactor = replicationFactor;
        this.replicasAssignments = null;
    }

    public NewTopic(String name, Map<Integer, List<Integer>> replicasAssignments) {
        this.name = name;
        this.numPartitions = Optional.empty();
        this.replicationFactor = Optional.empty();
        this.replicasAssignments = Collections.unmodifiableMap(replicasAssignments);
    }

    public String name() {
        return this.name;
    }

    public int numPartitions() {
        return this.numPartitions.orElse(-1);
    }

    public short replicationFactor() {
        return this.replicationFactor.orElse((short)-1);
    }

    public Map<Integer, List<Integer>> replicasAssignments() {
        return this.replicasAssignments;
    }

    public NewTopic configs(Map<String, String> configs) {
        this.configs = configs;
        return this;
    }

    public Map<String, String> configs() {
        return this.configs;
    }

    CreateTopicsRequestData.CreatableTopic convertToCreatableTopic() {
        CreateTopicsRequestData.CreatableTopic creatableTopic = new CreateTopicsRequestData.CreatableTopic().setName(this.name).setNumPartitions(this.numPartitions.orElse(-1)).setReplicationFactor(this.replicationFactor.orElse((short)-1));
        if (this.replicasAssignments != null) {
            for (Map.Entry<Object, Object> entry : this.replicasAssignments.entrySet()) {
                creatableTopic.assignments().add(new CreateTopicsRequestData.CreatableReplicaAssignment().setPartitionIndex((Integer)entry.getKey()).setBrokerIds((List)entry.getValue()));
            }
        }
        if (this.configs != null) {
            for (Map.Entry<Object, Object> entry : this.configs.entrySet()) {
                creatableTopic.configs().add(new CreateTopicsRequestData.CreateableTopicConfig().setName((String)entry.getKey()).setValue((String)entry.getValue()));
            }
        }
        return creatableTopic;
    }

    public String toString() {
        StringBuilder bld = new StringBuilder();
        bld.append("(name=").append(this.name).append(", numPartitions=").append(this.numPartitions.map(String::valueOf).orElse("default")).append(", replicationFactor=").append(this.replicationFactor.map(String::valueOf).orElse("default")).append(", replicasAssignments=").append(this.replicasAssignments).append(", configs=").append(this.configs).append(")");
        return bld.toString();
    }
}

