/*
 * Decompiled with CFR 0.152.
 */
package shaded.alink.kafka.org.apache.kafka.clients;

import java.io.Closeable;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.slf4j.Logger;
import shaded.alink.kafka.org.apache.kafka.clients.MetadataCache;
import shaded.alink.kafka.org.apache.kafka.common.Cluster;
import shaded.alink.kafka.org.apache.kafka.common.KafkaException;
import shaded.alink.kafka.org.apache.kafka.common.Node;
import shaded.alink.kafka.org.apache.kafka.common.PartitionInfo;
import shaded.alink.kafka.org.apache.kafka.common.TopicPartition;
import shaded.alink.kafka.org.apache.kafka.common.errors.InvalidMetadataException;
import shaded.alink.kafka.org.apache.kafka.common.errors.InvalidTopicException;
import shaded.alink.kafka.org.apache.kafka.common.errors.TopicAuthorizationException;
import shaded.alink.kafka.org.apache.kafka.common.internals.ClusterResourceListeners;
import shaded.alink.kafka.org.apache.kafka.common.protocol.Errors;
import shaded.alink.kafka.org.apache.kafka.common.requests.MetadataRequest;
import shaded.alink.kafka.org.apache.kafka.common.requests.MetadataResponse;
import shaded.alink.kafka.org.apache.kafka.common.utils.LogContext;

public class Metadata
implements Closeable {
    private final Logger log;
    private final long refreshBackoffMs;
    private final long metadataExpireMs;
    private int updateVersion;
    private int requestVersion;
    private long lastRefreshMs;
    private long lastSuccessfulRefreshMs;
    private KafkaException fatalException;
    private Set<String> invalidTopics;
    private Set<String> unauthorizedTopics;
    private MetadataCache cache = MetadataCache.empty();
    private boolean needUpdate;
    private final ClusterResourceListeners clusterResourceListeners;
    private boolean isClosed;
    private final Map<TopicPartition, Integer> lastSeenLeaderEpochs;

    public Metadata(long refreshBackoffMs, long metadataExpireMs, LogContext logContext, ClusterResourceListeners clusterResourceListeners) {
        this.log = logContext.logger(Metadata.class);
        this.refreshBackoffMs = refreshBackoffMs;
        this.metadataExpireMs = metadataExpireMs;
        this.lastRefreshMs = 0L;
        this.lastSuccessfulRefreshMs = 0L;
        this.requestVersion = 0;
        this.updateVersion = 0;
        this.needUpdate = false;
        this.clusterResourceListeners = clusterResourceListeners;
        this.isClosed = false;
        this.lastSeenLeaderEpochs = new HashMap<TopicPartition, Integer>();
        this.invalidTopics = Collections.emptySet();
        this.unauthorizedTopics = Collections.emptySet();
    }

    public synchronized Cluster fetch() {
        return this.cache.cluster();
    }

    public synchronized long timeToAllowUpdate(long nowMs) {
        return Math.max(this.lastRefreshMs + this.refreshBackoffMs - nowMs, 0L);
    }

    public synchronized long timeToNextUpdate(long nowMs) {
        long timeToExpire = this.needUpdate ? 0L : Math.max(this.lastSuccessfulRefreshMs + this.metadataExpireMs - nowMs, 0L);
        return Math.max(timeToExpire, this.timeToAllowUpdate(nowMs));
    }

    public long metadataExpireMs() {
        return this.metadataExpireMs;
    }

    public synchronized int requestUpdate() {
        this.needUpdate = true;
        return this.updateVersion;
    }

    public synchronized boolean updateLastSeenEpochIfNewer(TopicPartition topicPartition, int leaderEpoch) {
        Objects.requireNonNull(topicPartition, "TopicPartition cannot be null");
        return this.updateLastSeenEpoch(topicPartition, leaderEpoch, oldEpoch -> leaderEpoch > oldEpoch, true);
    }

    public Optional<Integer> lastSeenLeaderEpoch(TopicPartition topicPartition) {
        return Optional.ofNullable(this.lastSeenLeaderEpochs.get(topicPartition));
    }

    private synchronized boolean updateLastSeenEpoch(TopicPartition topicPartition, int epoch, Predicate<Integer> epochTest, boolean setRequestUpdateFlag) {
        Integer oldEpoch = this.lastSeenLeaderEpochs.get(topicPartition);
        this.log.trace("Determining if we should replace existing epoch {} with new epoch {}", (Object)oldEpoch, (Object)epoch);
        if (oldEpoch == null || epochTest.test(oldEpoch)) {
            this.log.debug("Updating last seen epoch from {} to {} for partition {}", oldEpoch, epoch, topicPartition);
            this.lastSeenLeaderEpochs.put(topicPartition, epoch);
            if (setRequestUpdateFlag) {
                this.needUpdate = true;
            }
            return true;
        }
        this.log.debug("Not replacing existing epoch {} with new epoch {} for partition {}", oldEpoch, epoch, topicPartition);
        return false;
    }

    public synchronized boolean updateRequested() {
        return this.needUpdate;
    }

    public synchronized Optional<MetadataCache.PartitionInfoAndEpoch> partitionInfoIfCurrent(TopicPartition topicPartition) {
        Integer epoch = this.lastSeenLeaderEpochs.get(topicPartition);
        if (epoch == null) {
            return this.cache.getPartitionInfo(topicPartition);
        }
        return this.cache.getPartitionInfoHavingEpoch(topicPartition, epoch);
    }

    public synchronized void bootstrap(List<InetSocketAddress> addresses) {
        this.needUpdate = true;
        ++this.updateVersion;
        this.cache = MetadataCache.bootstrap(addresses);
    }

    public synchronized void update(MetadataResponse response, long now) {
        this.update(this.requestVersion, response, now);
    }

    public synchronized void update(int requestVersion, MetadataResponse response, long now) {
        Objects.requireNonNull(response, "Metadata response cannot be null");
        if (this.isClosed()) {
            throw new IllegalStateException("Update requested after metadata close");
        }
        if (requestVersion == this.requestVersion) {
            this.needUpdate = false;
        } else {
            this.requestUpdate();
        }
        this.lastRefreshMs = now;
        this.lastSuccessfulRefreshMs = now;
        ++this.updateVersion;
        String previousClusterId = this.cache.cluster().clusterResource().clusterId();
        this.cache = this.handleMetadataResponse(response, topic -> this.retainTopic(topic.topic(), topic.isInternal(), now));
        Cluster cluster = this.cache.cluster();
        this.maybeSetMetadataError(cluster);
        this.lastSeenLeaderEpochs.keySet().removeIf(tp -> !this.retainTopic(tp.topic(), false, now));
        String newClusterId = this.cache.cluster().clusterResource().clusterId();
        if (!Objects.equals(previousClusterId, newClusterId)) {
            this.log.info("Cluster ID: {}", (Object)newClusterId);
        }
        this.clusterResourceListeners.onUpdate(this.cache.cluster().clusterResource());
        this.log.debug("Updated cluster metadata updateVersion {} to {}", (Object)this.updateVersion, (Object)this.cache);
    }

    private void maybeSetMetadataError(Cluster cluster) {
        this.clearRecoverableErrors();
        this.checkInvalidTopics(cluster);
        this.checkUnauthorizedTopics(cluster);
    }

    private void checkInvalidTopics(Cluster cluster) {
        if (!cluster.invalidTopics().isEmpty()) {
            this.log.error("Metadata response reported invalid topics {}", (Object)cluster.invalidTopics());
            this.invalidTopics = new HashSet<String>(cluster.invalidTopics());
        }
    }

    private void checkUnauthorizedTopics(Cluster cluster) {
        if (!cluster.unauthorizedTopics().isEmpty()) {
            this.log.error("Topic authorization failed for topics {}", (Object)cluster.unauthorizedTopics());
            this.unauthorizedTopics = new HashSet<String>(cluster.unauthorizedTopics());
        }
    }

    private MetadataCache handleMetadataResponse(MetadataResponse metadataResponse, Predicate<MetadataResponse.TopicMetadata> topicsToRetain) {
        HashSet<String> internalTopics = new HashSet<String>();
        ArrayList<MetadataCache.PartitionInfoAndEpoch> partitions = new ArrayList<MetadataCache.PartitionInfoAndEpoch>();
        Map<Integer, Node> brokersById = metadataResponse.brokersById();
        for (MetadataResponse.TopicMetadata metadata : metadataResponse.topicMetadata()) {
            if (!topicsToRetain.test(metadata)) continue;
            if (metadata.error() == Errors.NONE) {
                if (metadata.isInternal()) {
                    internalTopics.add(metadata.topic());
                }
                for (MetadataResponse.PartitionMetadata partitionMetadata : metadata.partitionMetadata()) {
                    this.updatePartitionInfo(metadata.topic(), partitionMetadata, metadataResponse.hasReliableLeaderEpochs(), partitionInfoAndEpoch -> {
                        Node leader = partitionInfoAndEpoch.partitionInfo().leader();
                        if (leader != null && !leader.equals(brokersById.get(leader.id()))) {
                            PartitionInfo partitionInfo = partitionInfoAndEpoch.partitionInfo();
                            PartitionInfo partitionInfoWithoutLeader = new PartitionInfo(partitionInfo.topic(), partitionInfo.partition(), (Node)brokersById.get(leader.id()), partitionInfo.replicas(), partitionInfo.inSyncReplicas(), partitionInfo.offlineReplicas());
                            partitions.add(new MetadataCache.PartitionInfoAndEpoch(partitionInfoWithoutLeader, partitionInfoAndEpoch.epoch()));
                        } else {
                            partitions.add((MetadataCache.PartitionInfoAndEpoch)partitionInfoAndEpoch);
                        }
                    });
                    if (!(partitionMetadata.error().exception() instanceof InvalidMetadataException)) continue;
                    this.log.debug("Requesting metadata update for partition {} due to error {}", (Object)new TopicPartition(metadata.topic(), partitionMetadata.partition()), (Object)partitionMetadata.error());
                    this.requestUpdate();
                }
                continue;
            }
            if (!(metadata.error().exception() instanceof InvalidMetadataException)) continue;
            this.log.debug("Requesting metadata update for topic {} due to error {}", (Object)metadata.topic(), (Object)metadata.error());
            this.requestUpdate();
        }
        return new MetadataCache(metadataResponse.clusterId(), brokersById.values(), partitions, metadataResponse.topicsByError(Errors.TOPIC_AUTHORIZATION_FAILED), metadataResponse.topicsByError(Errors.INVALID_TOPIC_EXCEPTION), internalTopics, metadataResponse.controller());
    }

    private void updatePartitionInfo(String topic, MetadataResponse.PartitionMetadata partitionMetadata, boolean hasReliableLeaderEpoch, Consumer<MetadataCache.PartitionInfoAndEpoch> partitionInfoConsumer) {
        TopicPartition tp = new TopicPartition(topic, partitionMetadata.partition());
        if (hasReliableLeaderEpoch && partitionMetadata.leaderEpoch().isPresent()) {
            int newEpoch = partitionMetadata.leaderEpoch().get();
            if (this.updateLastSeenEpoch(tp, newEpoch, oldEpoch -> newEpoch >= oldEpoch, false)) {
                PartitionInfo info = MetadataResponse.partitionMetaToInfo(topic, partitionMetadata);
                partitionInfoConsumer.accept(new MetadataCache.PartitionInfoAndEpoch(info, newEpoch));
            } else {
                this.cache.getPartitionInfo(tp).ifPresent(partitionInfoConsumer);
            }
        } else {
            this.lastSeenLeaderEpochs.remove(tp);
            PartitionInfo info = MetadataResponse.partitionMetaToInfo(topic, partitionMetadata);
            partitionInfoConsumer.accept(new MetadataCache.PartitionInfoAndEpoch(info, -1));
        }
    }

    public synchronized void maybeThrowAnyException() {
        this.clearErrorsAndMaybeThrowException(this::recoverableException);
    }

    public synchronized void maybeThrowFatalException() {
        KafkaException metadataException = this.fatalException;
        if (metadataException != null) {
            this.fatalException = null;
            throw metadataException;
        }
    }

    public synchronized void maybeThrowExceptionForTopic(String topic) {
        this.clearErrorsAndMaybeThrowException(() -> this.recoverableExceptionForTopic(topic));
    }

    private void clearErrorsAndMaybeThrowException(Supplier<KafkaException> recoverableExceptionSupplier) {
        KafkaException metadataException = Optional.ofNullable(this.fatalException).orElseGet(recoverableExceptionSupplier);
        this.fatalException = null;
        this.clearRecoverableErrors();
        if (metadataException != null) {
            throw metadataException;
        }
    }

    private KafkaException recoverableException() {
        if (!this.unauthorizedTopics.isEmpty()) {
            return new TopicAuthorizationException(this.unauthorizedTopics);
        }
        if (!this.invalidTopics.isEmpty()) {
            return new InvalidTopicException(this.invalidTopics);
        }
        return null;
    }

    private KafkaException recoverableExceptionForTopic(String topic) {
        if (this.unauthorizedTopics.contains(topic)) {
            return new TopicAuthorizationException(Collections.singleton(topic));
        }
        if (this.invalidTopics.contains(topic)) {
            return new InvalidTopicException(Collections.singleton(topic));
        }
        return null;
    }

    private void clearRecoverableErrors() {
        this.invalidTopics = Collections.emptySet();
        this.unauthorizedTopics = Collections.emptySet();
    }

    public synchronized void failedUpdate(long now) {
        this.lastRefreshMs = now;
    }

    public synchronized void fatalError(KafkaException exception) {
        this.fatalException = exception;
    }

    public synchronized int updateVersion() {
        return this.updateVersion;
    }

    public synchronized long lastSuccessfulUpdate() {
        return this.lastSuccessfulRefreshMs;
    }

    @Override
    public synchronized void close() {
        this.isClosed = true;
    }

    public synchronized boolean isClosed() {
        return this.isClosed;
    }

    public synchronized void requestUpdateForNewTopics() {
        this.lastRefreshMs = 0L;
        ++this.requestVersion;
        this.requestUpdate();
    }

    public synchronized MetadataRequestAndVersion newMetadataRequestAndVersion() {
        return new MetadataRequestAndVersion(this.newMetadataRequestBuilder(), this.requestVersion);
    }

    protected MetadataRequest.Builder newMetadataRequestBuilder() {
        return MetadataRequest.Builder.allTopics();
    }

    protected boolean retainTopic(String topic, boolean isInternal, long nowMs) {
        return true;
    }

    public synchronized LeaderAndEpoch leaderAndEpoch(TopicPartition tp) {
        return this.partitionInfoIfCurrent(tp).map(infoAndEpoch -> {
            Node leader = infoAndEpoch.partitionInfo().leader();
            return new LeaderAndEpoch(leader == null ? Node.noNode() : leader, Optional.of(infoAndEpoch.epoch()));
        }).orElse(new LeaderAndEpoch(Node.noNode(), this.lastSeenLeaderEpoch(tp)));
    }

    public static class LeaderAndEpoch {
        public static final LeaderAndEpoch NO_LEADER_OR_EPOCH = new LeaderAndEpoch(Node.noNode(), Optional.empty());
        public final Node leader;
        public final Optional<Integer> epoch;

        public LeaderAndEpoch(Node leader, Optional<Integer> epoch) {
            this.leader = Objects.requireNonNull(leader);
            this.epoch = Objects.requireNonNull(epoch);
        }

        public static LeaderAndEpoch noLeaderOrEpoch() {
            return NO_LEADER_OR_EPOCH;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LeaderAndEpoch that = (LeaderAndEpoch)o;
            if (!this.leader.equals(that.leader)) {
                return false;
            }
            return this.epoch.equals(that.epoch);
        }

        public int hashCode() {
            int result = this.leader.hashCode();
            result = 31 * result + this.epoch.hashCode();
            return result;
        }

        public String toString() {
            return "LeaderAndEpoch{leader=" + this.leader + ", epoch=" + this.epoch.map(Object::toString).orElse("absent") + '}';
        }
    }

    public static class MetadataRequestAndVersion {
        public final MetadataRequest.Builder requestBuilder;
        public final int requestVersion;

        private MetadataRequestAndVersion(MetadataRequest.Builder requestBuilder, int requestVersion) {
            this.requestBuilder = requestBuilder;
            this.requestVersion = requestVersion;
        }
    }
}

