/*
 * Decompiled with CFR 0.152.
 */
package shaded.alink.kafka.org.apache.flink.streaming.connectors.kafka.table;

import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.format.EncodingFormat;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.sink.SinkFunctionProvider;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.DataType;
import org.apache.flink.util.Preconditions;
import shaded.alink.kafka.org.apache.flink.streaming.connectors.kafka.partitioner.FlinkKafkaPartitioner;

@Internal
public abstract class KafkaDynamicSinkBase
implements DynamicTableSink {
    protected final DataType consumedDataType;
    protected final String topic;
    protected final Properties properties;
    protected final EncodingFormat<SerializationSchema<RowData>> encodingFormat;
    protected final Optional<FlinkKafkaPartitioner<RowData>> partitioner;

    protected KafkaDynamicSinkBase(DataType consumedDataType, String topic, Properties properties, Optional<FlinkKafkaPartitioner<RowData>> partitioner, EncodingFormat<SerializationSchema<RowData>> encodingFormat) {
        this.consumedDataType = (DataType)Preconditions.checkNotNull((Object)consumedDataType, (String)"Consumed data type must not be null.");
        this.topic = (String)Preconditions.checkNotNull((Object)topic, (String)"Topic must not be null.");
        this.properties = (Properties)Preconditions.checkNotNull((Object)properties, (String)"Properties must not be null.");
        this.partitioner = (Optional)Preconditions.checkNotNull(partitioner, (String)"Partitioner must not be null.");
        this.encodingFormat = (EncodingFormat)Preconditions.checkNotNull(encodingFormat, (String)"Encoding format must not be null.");
    }

    public ChangelogMode getChangelogMode(ChangelogMode requestedMode) {
        return this.encodingFormat.getChangelogMode();
    }

    public DynamicTableSink.SinkRuntimeProvider getSinkRuntimeProvider(DynamicTableSink.Context context) {
        SerializationSchema serializationSchema = (SerializationSchema)this.encodingFormat.createRuntimeEncoder(context, this.consumedDataType);
        SinkFunction<RowData> kafkaProducer = this.createKafkaProducer(this.topic, this.properties, (SerializationSchema<RowData>)serializationSchema, this.partitioner);
        return SinkFunctionProvider.of(kafkaProducer);
    }

    protected abstract SinkFunction<RowData> createKafkaProducer(String var1, Properties var2, SerializationSchema<RowData> var3, Optional<FlinkKafkaPartitioner<RowData>> var4);

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KafkaDynamicSinkBase that = (KafkaDynamicSinkBase)o;
        return Objects.equals(this.consumedDataType, that.consumedDataType) && Objects.equals(this.topic, that.topic) && Objects.equals(this.properties, that.properties) && Objects.equals(this.encodingFormat, that.encodingFormat) && Objects.equals(this.partitioner, that.partitioner);
    }

    public int hashCode() {
        return Objects.hash(this.consumedDataType, this.topic, this.properties, this.encodingFormat, this.partitioner);
    }
}

