/*
 * Decompiled with CFR 0.152.
 */
package shaded.alink.kafka.org.apache.flink.streaming.connectors.kafka.shuffle;

import java.util.Map;
import java.util.Properties;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.eventtime.WatermarkStrategy;
import org.apache.flink.api.common.serialization.TypeInformationSerializationSchema;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.streaming.api.functions.source.SourceFunction;
import org.apache.flink.streaming.api.operators.StreamingRuntimeContext;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.PropertiesUtil;
import org.apache.flink.util.SerializedValue;
import shaded.alink.kafka.org.apache.flink.streaming.connectors.kafka.FlinkKafkaConsumer;
import shaded.alink.kafka.org.apache.flink.streaming.connectors.kafka.config.OffsetCommitMode;
import shaded.alink.kafka.org.apache.flink.streaming.connectors.kafka.internal.KafkaShuffleFetcher;
import shaded.alink.kafka.org.apache.flink.streaming.connectors.kafka.internals.AbstractFetcher;
import shaded.alink.kafka.org.apache.flink.streaming.connectors.kafka.internals.KafkaTopicPartition;

@Internal
public class FlinkKafkaShuffleConsumer<T>
extends FlinkKafkaConsumer<T> {
    private final TypeSerializer<T> typeSerializer;
    private final int producerParallelism;

    FlinkKafkaShuffleConsumer(String topic, TypeInformationSerializationSchema<T> schema, TypeSerializer<T> typeSerializer, Properties props) {
        super(topic, schema, props);
        this.typeSerializer = typeSerializer;
        Preconditions.checkArgument((props.getProperty("producer parallelism") != null ? 1 : 0) != 0, (Object)"Missing producer parallelism for Kafka Shuffle");
        this.producerParallelism = PropertiesUtil.getInt((Properties)props, (String)"producer parallelism", (int)Integer.MAX_VALUE);
    }

    @Override
    protected AbstractFetcher<T, ?> createFetcher(SourceFunction.SourceContext<T> sourceContext, Map<KafkaTopicPartition, Long> assignedPartitionsWithInitialOffsets, SerializedValue<WatermarkStrategy<T>> watermarkStrategy, StreamingRuntimeContext runtimeContext, OffsetCommitMode offsetCommitMode, MetricGroup consumerMetricGroup, boolean useMetrics) throws Exception {
        FlinkKafkaShuffleConsumer.adjustAutoCommitConfig(this.properties, offsetCommitMode);
        return new KafkaShuffleFetcher<T>(sourceContext, assignedPartitionsWithInitialOffsets, watermarkStrategy, runtimeContext.getProcessingTimeService(), runtimeContext.getExecutionConfig().getAutoWatermarkInterval(), runtimeContext.getUserCodeClassLoader(), runtimeContext.getTaskNameWithSubtasks(), this.deserializer, this.properties, this.pollTimeout, runtimeContext.getMetricGroup(), consumerMetricGroup, useMetrics, this.typeSerializer, this.producerParallelism);
    }
}

