/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.alink.operator.common.io.kafka;

import com.alibaba.alink.operator.common.io.serde.RowToCsvSerialization;
import com.alibaba.alink.operator.common.io.serde.RowToJsonSerialization;
import com.alibaba.alink.params.io.shared.HasDataFormat;
import java.util.Properties;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.streaming.api.functions.sink.RichSinkFunction;
import org.apache.flink.types.Row;

public abstract class BaseKafkaSinkBuilder {
    protected String topic;
    protected HasDataFormat.DataFormat format;
    protected String fieldDelimiter;
    protected String[] fieldNames;
    protected TypeInformation<?>[] fieldTypes;
    protected Properties properties;

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public void setFieldDelimiter(String fieldDelimiter) {
        this.fieldDelimiter = fieldDelimiter;
    }

    public void setFieldNames(String[] fieldNames) {
        this.fieldNames = fieldNames;
    }

    public void setFieldTypes(TypeInformation<?>[] fieldTypes) {
        this.fieldTypes = fieldTypes;
    }

    public void setFormat(HasDataFormat.DataFormat format) {
        this.format = format;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    protected SerializationSchema<Row> getSerializationSchema() {
        switch (this.format) {
            case CSV: {
                return new RowToCsvSerialization(this.fieldTypes, this.fieldDelimiter);
            }
            case JSON: {
                return new RowToJsonSerialization(this.fieldNames);
            }
        }
        throw new IllegalArgumentException("Invalid format: " + this.format);
    }

    public abstract RichSinkFunction<Row> build();
}

