<h1 align="center">PyRival</h1>
<div align="center">
  <strong>A Python Library for Competitive Programming</strong>
</div>

<h3 align="center">Developers</h3>
<div align="center">
  <strong>
    <a href="https://github.com/Mukundan314">Mukundan314</a> &emsp;
    <a href="https://github.com/bjorn-martinsson">pajenegod</a> &emsp;
    <a href="https://github.com/eduard-netsajev">drd93</a> &emsp;
    <a href="https://github.com/algmyr">algmyr</a> &emsp;
    <a href="https://github.com/meooow25">meooow</a> &emsp;
    <a href="https://github.com/tfg50">tfg</a> &emsp;
    <a href="https://github.com/sgtlaugh">sgtlaugh</a> &emsp;
  </strong>
</div>

---

### Templates
- The [Master Template](templates/template.py) works with all versions of Python and has Python 3 behaviour.
- Version Specific Templates: [PyPy 2](templates/template_pypy2.py), [Python 3](templates/template_py3.py)

##

### Tools
- [Interactive Runner](https://github.com/cheran-senthil/PyRival/blob/master/pyrival/tools/interactive_runner.py)
- [Stress Tester](https://github.com/cheran-senthil/PyRival/blob/master/pyrival/tools/stress_tester.py)

##

### Snippets
<details>
  <summary>Algebra</summary>

  - (Multivariable) Chinese Remainder Theorem
  - Discrete Logarithm
  - Least Common Multiple
  - Integer Factorization
  - Fast Fourier Transform
  - Fast Subset Transform
  - Number Theoretic Transform
  - Deterministic Miller-Rabin Primality Test
  - Tonelli–Shanks Algorithm
  - Generalized Modular Inverse
  - Euler's Phi Function
  - Primitive Root
  - Sieve of Eratosthenes
</details>

<details>
  <summary>Data Structures</summary>

  - Bit Array
  - Binary Indexed (Fenwick) Tree
  - Fractions
  - Continued Fractions
  - Disjoint-Set (Union Find) Data Structure
  - Generic Nodes
  - Linked List
  - Range Query Data Structure
  - (Lazy) Segment Tree
  - Persistent Segment Tree
  - Sorted List
  - Treap
  - Trie Tree
  - 2-satisfiability Template
</details>

<details>
  <summary>Geometry</summary>

  - Convex Hull
  - Line Functions
  - Polygon Functions
  - Vector Functions
</details>

<details>
  <summary>Graphs</summary>

  - Bellman-Ford Algorithm
  - Breadth First Search
  - Connected Components Search
  - Brent's Algorithm for Cycle Detection
  - Depth First Search
  - Dijkstra's Algorithm
  - Eulerian Path
  - Path Constructor
  - Floyd-Warshall Algorithm
  - Bipartite Graph Check
  - Kruskal's Algorithm with Disjoin Set Union
  - Prim's Algorithm
  - Tarjan's Algorithm
  - Topological Sorting
</details>

<details>
  <summary>Combinatorics</summary>

  - General Purpose Numbers
  - Lucas's Theorem
  - Partition Function
</details>

<details>
  <summary>Linear Algebra</summary>

  - Matrix Arithmetic, Exponentiation, Determinant, and Inverse
  - Gaussian Elimination
  - Multivariable Chinese Remainder Theorem
</details>

<details>
  <summary>Numerical</summary>

  - Linear Recurrence Template
  - Hill Climbing Algorithm
  - Approximate Integration
  - Polynomial Interpolation
  - Integer Roots
  - Binary Search
</details>

<details>
  <summary>Strings</summary>

  - Knuth–Morris–Pratt Algorithm
  - Longest Common/Palindromic Subsequences
  - Longest Common Substring
  - Manacher's Algorithm
  - Lydon Factorization
</details>


<details>
  <summary>Misc</summary>

  - bootstrap for recursion
  - FastIO
  - heapq
  - sorted
  - py3k compatibility tools
  - random
  - str.split for whitespace
  - Bit Hacks
  - 32-bit Modular Arithmetic
  - Memoize Decorators
  - C++ syle cout
  - Interactive Runner
  - Stress Tester
  - Alpha–Beta Pruning
  - Longest Increasing Subsequence
  - K-th Order Statistic
</details>

##

### Apache License 2.0
  Copyright (c) 2020 Cheran Senthilkumar
