# coding: utf-8

"""
    Speech Services API v3.0

    Speech Services API v3.0.  # noqa: E501

    OpenAPI spec version: v3.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from swagger_client.api_client import ApiClient


class CustomSpeechModelEvaluationsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_evaluation(self, evaluation, **kwargs):  # noqa: E501
        """Creates a new evaluation.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_evaluation(evaluation, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Evaluation evaluation: The details of the new evaluation. (required)
        :return: Evaluation
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_evaluation_with_http_info(evaluation, **kwargs)  # noqa: E501
        else:
            (data) = self.create_evaluation_with_http_info(evaluation, **kwargs)  # noqa: E501
            return data

    def create_evaluation_with_http_info(self, evaluation, **kwargs):  # noqa: E501
        """Creates a new evaluation.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_evaluation_with_http_info(evaluation, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Evaluation evaluation: The details of the new evaluation. (required)
        :return: Evaluation
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['evaluation']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_evaluation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'evaluation' is set
        if self.api_client.client_side_validation and ('evaluation' not in params or
                                                       params['evaluation'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `evaluation` when calling `create_evaluation`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'evaluation' in params:
            body_params = params['evaluation']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'token']  # noqa: E501

        return self.api_client.call_api(
            '/evaluations', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Evaluation',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_evaluation(self, id, **kwargs):  # noqa: E501
        """Deletes the evaluation identified by the given ID.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_evaluation(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: The identifier of the evaluation. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_evaluation_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_evaluation_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def delete_evaluation_with_http_info(self, id, **kwargs):  # noqa: E501
        """Deletes the evaluation identified by the given ID.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_evaluation_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: The identifier of the evaluation. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_evaluation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in params or
                                                       params['id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `id` when calling `delete_evaluation`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'token']  # noqa: E501

        return self.api_client.call_api(
            '/evaluations/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_evaluation(self, id, **kwargs):  # noqa: E501
        """Gets the evaluation identified by the given ID.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_evaluation(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: The identifier of the evaluation. (required)
        :return: Evaluation
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_evaluation_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_evaluation_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def get_evaluation_with_http_info(self, id, **kwargs):  # noqa: E501
        """Gets the evaluation identified by the given ID.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_evaluation_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: The identifier of the evaluation. (required)
        :return: Evaluation
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_evaluation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in params or
                                                       params['id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `id` when calling `get_evaluation`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'token']  # noqa: E501

        return self.api_client.call_api(
            '/evaluations/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Evaluation',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_evaluation_file(self, id, file_id, **kwargs):  # noqa: E501
        """Gets one specific file (identified with fileId) from an evaluation (identified with id).  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_evaluation_file(id, file_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: The identifier of the evaluation. (required)
        :param str file_id: The identifier of the file. (required)
        :param int sas_validity_in_seconds: The duration in seconds that an SAS url should be valid. The default duration is 12 hours.              When using BYOS (https://docs.microsoft.com/en-us/azure/cognitive-services/speech-service/speech-encryption-of-data-at-rest#bring-your-own-storage-byos-for-customization-and-logging): A value of 0 means that a plain blob URI without SAS token will be generated.
        :return: File
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_evaluation_file_with_http_info(id, file_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_evaluation_file_with_http_info(id, file_id, **kwargs)  # noqa: E501
            return data

    def get_evaluation_file_with_http_info(self, id, file_id, **kwargs):  # noqa: E501
        """Gets one specific file (identified with fileId) from an evaluation (identified with id).  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_evaluation_file_with_http_info(id, file_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: The identifier of the evaluation. (required)
        :param str file_id: The identifier of the file. (required)
        :param int sas_validity_in_seconds: The duration in seconds that an SAS url should be valid. The default duration is 12 hours.              When using BYOS (https://docs.microsoft.com/en-us/azure/cognitive-services/speech-service/speech-encryption-of-data-at-rest#bring-your-own-storage-byos-for-customization-and-logging): A value of 0 means that a plain blob URI without SAS token will be generated.
        :return: File
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'file_id', 'sas_validity_in_seconds']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_evaluation_file" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in params or
                                                       params['id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `id` when calling `get_evaluation_file`")  # noqa: E501
        # verify the required parameter 'file_id' is set
        if self.api_client.client_side_validation and ('file_id' not in params or
                                                       params['file_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `file_id` when calling `get_evaluation_file`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501
        if 'file_id' in params:
            path_params['fileId'] = params['file_id']  # noqa: E501

        query_params = []
        if 'sas_validity_in_seconds' in params:
            query_params.append(('sasValidityInSeconds', params['sas_validity_in_seconds']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'token']  # noqa: E501

        return self.api_client.call_api(
            '/evaluations/{id}/files/{fileId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='File',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_evaluation_files(self, id, **kwargs):  # noqa: E501
        """Gets the files of the evaluation identified by the given ID.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_evaluation_files(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: The identifier of the evaluation. (required)
        :param int sas_validity_in_seconds: The duration in seconds that an SAS url should be valid. The default duration is 12 hours.              When using BYOS (https://docs.microsoft.com/en-us/azure/cognitive-services/speech-service/speech-encryption-of-data-at-rest#bring-your-own-storage-byos-for-customization-and-logging): A value of 0 means that a plain blob URI without SAS token will be generated.
        :param int skip: Number of datasets that will be skipped.
        :param int top: Number of datasets that will be included after skipping.
        :return: PaginatedFiles
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_evaluation_files_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_evaluation_files_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def get_evaluation_files_with_http_info(self, id, **kwargs):  # noqa: E501
        """Gets the files of the evaluation identified by the given ID.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_evaluation_files_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: The identifier of the evaluation. (required)
        :param int sas_validity_in_seconds: The duration in seconds that an SAS url should be valid. The default duration is 12 hours.              When using BYOS (https://docs.microsoft.com/en-us/azure/cognitive-services/speech-service/speech-encryption-of-data-at-rest#bring-your-own-storage-byos-for-customization-and-logging): A value of 0 means that a plain blob URI without SAS token will be generated.
        :param int skip: Number of datasets that will be skipped.
        :param int top: Number of datasets that will be included after skipping.
        :return: PaginatedFiles
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'sas_validity_in_seconds', 'skip', 'top']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_evaluation_files" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in params or
                                                       params['id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `id` when calling `get_evaluation_files`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'sas_validity_in_seconds' in params:
            query_params.append(('sasValidityInSeconds', params['sas_validity_in_seconds']))  # noqa: E501
        if 'skip' in params:
            query_params.append(('skip', params['skip']))  # noqa: E501
        if 'top' in params:
            query_params.append(('top', params['top']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'token']  # noqa: E501

        return self.api_client.call_api(
            '/evaluations/{id}/files', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PaginatedFiles',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_evaluations(self, **kwargs):  # noqa: E501
        """Gets the list of evaluations for the authenticated subscription.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_evaluations(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int skip: Number of datasets that will be skipped.
        :param int top: Number of datasets that will be included after skipping.
        :return: PaginatedEvaluations
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_evaluations_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_evaluations_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_evaluations_with_http_info(self, **kwargs):  # noqa: E501
        """Gets the list of evaluations for the authenticated subscription.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_evaluations_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int skip: Number of datasets that will be skipped.
        :param int top: Number of datasets that will be included after skipping.
        :return: PaginatedEvaluations
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['skip', 'top']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_evaluations" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'skip' in params:
            query_params.append(('skip', params['skip']))  # noqa: E501
        if 'top' in params:
            query_params.append(('top', params['top']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'token']  # noqa: E501

        return self.api_client.call_api(
            '/evaluations', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PaginatedEvaluations',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_supported_locales_for_evaluations(self, **kwargs):  # noqa: E501
        """Gets a list of supported locales for evaluations.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_supported_locales_for_evaluations(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: list[str]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_supported_locales_for_evaluations_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_supported_locales_for_evaluations_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_supported_locales_for_evaluations_with_http_info(self, **kwargs):  # noqa: E501
        """Gets a list of supported locales for evaluations.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_supported_locales_for_evaluations_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: list[str]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_supported_locales_for_evaluations" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'token']  # noqa: E501

        return self.api_client.call_api(
            '/evaluations/locales', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[str]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_evaluation(self, id, evaluation_update, **kwargs):  # noqa: E501
        """Updates the mutable details of the evaluation identified by its id.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_evaluation(id, evaluation_update, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: The identifier of the evaluation. (required)
        :param EvaluationUpdate evaluation_update: The object containing the updated fields of the evaluation. (required)
        :return: Evaluation
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_evaluation_with_http_info(id, evaluation_update, **kwargs)  # noqa: E501
        else:
            (data) = self.update_evaluation_with_http_info(id, evaluation_update, **kwargs)  # noqa: E501
            return data

    def update_evaluation_with_http_info(self, id, evaluation_update, **kwargs):  # noqa: E501
        """Updates the mutable details of the evaluation identified by its id.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_evaluation_with_http_info(id, evaluation_update, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: The identifier of the evaluation. (required)
        :param EvaluationUpdate evaluation_update: The object containing the updated fields of the evaluation. (required)
        :return: Evaluation
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'evaluation_update']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_evaluation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in params or
                                                       params['id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `id` when calling `update_evaluation`")  # noqa: E501
        # verify the required parameter 'evaluation_update' is set
        if self.api_client.client_side_validation and ('evaluation_update' not in params or
                                                       params['evaluation_update'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `evaluation_update` when calling `update_evaluation`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'evaluation_update' in params:
            body_params = params['evaluation_update']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/merge-patch+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'token']  # noqa: E501

        return self.api_client.call_api(
            '/evaluations/{id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Evaluation',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
