# coding: utf-8

"""
    Speech Services API v3.0

    Speech Services API v3.0.  # noqa: E501

    OpenAPI spec version: v3.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from swagger_client.api_client import ApiClient


class CustomSpeechEndpointsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_endpoint(self, endpoint, **kwargs):  # noqa: E501
        """Creates a new endpoint.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_endpoint(endpoint, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Endpoint endpoint: The details of the endpoint. (required)
        :return: Endpoint
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_endpoint_with_http_info(endpoint, **kwargs)  # noqa: E501
        else:
            (data) = self.create_endpoint_with_http_info(endpoint, **kwargs)  # noqa: E501
            return data

    def create_endpoint_with_http_info(self, endpoint, **kwargs):  # noqa: E501
        """Creates a new endpoint.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_endpoint_with_http_info(endpoint, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Endpoint endpoint: The details of the endpoint. (required)
        :return: Endpoint
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['endpoint']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_endpoint" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'endpoint' is set
        if self.api_client.client_side_validation and ('endpoint' not in params or
                                                       params['endpoint'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `endpoint` when calling `create_endpoint`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'endpoint' in params:
            body_params = params['endpoint']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'token']  # noqa: E501

        return self.api_client.call_api(
            '/endpoints', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Endpoint',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_base_model_log(self, locale, log_id, **kwargs):  # noqa: E501
        """Deletes one audio or transcription log that have been stored when using the default base model of a given language.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_base_model_log(locale, log_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str locale: The language used to select the default base model. (required)
        :param str log_id: The identifier of the log. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_base_model_log_with_http_info(locale, log_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_base_model_log_with_http_info(locale, log_id, **kwargs)  # noqa: E501
            return data

    def delete_base_model_log_with_http_info(self, locale, log_id, **kwargs):  # noqa: E501
        """Deletes one audio or transcription log that have been stored when using the default base model of a given language.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_base_model_log_with_http_info(locale, log_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str locale: The language used to select the default base model. (required)
        :param str log_id: The identifier of the log. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['locale', 'log_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_base_model_log" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'locale' is set
        if self.api_client.client_side_validation and ('locale' not in params or
                                                       params['locale'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `locale` when calling `delete_base_model_log`")  # noqa: E501
        # verify the required parameter 'log_id' is set
        if self.api_client.client_side_validation and ('log_id' not in params or
                                                       params['log_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `log_id` when calling `delete_base_model_log`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'locale' in params:
            path_params['locale'] = params['locale']  # noqa: E501
        if 'log_id' in params:
            path_params['logId'] = params['log_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'token']  # noqa: E501

        return self.api_client.call_api(
            '/endpoints/base/{locale}/files/logs/{logId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_base_model_logs(self, locale, **kwargs):  # noqa: E501
        """Deletes the specified audio and transcription logs that have been stored when using the default base model of a given language. It deletes all logs before (and including) a specific day.  # noqa: E501

        Deletion process is done asynchronously and can take up to one day depending on the amount of log files.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_base_model_logs(locale, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str locale: The language used to select the default base model. (required)
        :param str end_date: The end date of the audio logs deletion (specific day, UTC).              Expected format: \"yyyy-mm-dd\". For instance, \"2019-09-20\" results in deleting all logs on September 20h, 2019 and before.              Deletes all existing logs when date is not specified.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_base_model_logs_with_http_info(locale, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_base_model_logs_with_http_info(locale, **kwargs)  # noqa: E501
            return data

    def delete_base_model_logs_with_http_info(self, locale, **kwargs):  # noqa: E501
        """Deletes the specified audio and transcription logs that have been stored when using the default base model of a given language. It deletes all logs before (and including) a specific day.  # noqa: E501

        Deletion process is done asynchronously and can take up to one day depending on the amount of log files.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_base_model_logs_with_http_info(locale, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str locale: The language used to select the default base model. (required)
        :param str end_date: The end date of the audio logs deletion (specific day, UTC).              Expected format: \"yyyy-mm-dd\". For instance, \"2019-09-20\" results in deleting all logs on September 20h, 2019 and before.              Deletes all existing logs when date is not specified.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['locale', 'end_date']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_base_model_logs" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'locale' is set
        if self.api_client.client_side_validation and ('locale' not in params or
                                                       params['locale'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `locale` when calling `delete_base_model_logs`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'locale' in params:
            path_params['locale'] = params['locale']  # noqa: E501

        query_params = []
        if 'end_date' in params:
            query_params.append(('endDate', params['end_date']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'token']  # noqa: E501

        return self.api_client.call_api(
            '/endpoints/base/{locale}/files/logs', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_endpoint(self, id, **kwargs):  # noqa: E501
        """Deletes the endpoint identified by the given ID.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_endpoint(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: The identifier of the endpoint. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_endpoint_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_endpoint_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def delete_endpoint_with_http_info(self, id, **kwargs):  # noqa: E501
        """Deletes the endpoint identified by the given ID.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_endpoint_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: The identifier of the endpoint. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_endpoint" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in params or
                                                       params['id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `id` when calling `delete_endpoint`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'token']  # noqa: E501

        return self.api_client.call_api(
            '/endpoints/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_endpoint_log(self, id, log_id, **kwargs):  # noqa: E501
        """Deletes one audio or transcription log that have been stored for a given endpoint.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_endpoint_log(id, log_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: The identifier of the endpoint. (required)
        :param str log_id: The identifier of the log. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_endpoint_log_with_http_info(id, log_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_endpoint_log_with_http_info(id, log_id, **kwargs)  # noqa: E501
            return data

    def delete_endpoint_log_with_http_info(self, id, log_id, **kwargs):  # noqa: E501
        """Deletes one audio or transcription log that have been stored for a given endpoint.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_endpoint_log_with_http_info(id, log_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: The identifier of the endpoint. (required)
        :param str log_id: The identifier of the log. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'log_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_endpoint_log" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in params or
                                                       params['id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `id` when calling `delete_endpoint_log`")  # noqa: E501
        # verify the required parameter 'log_id' is set
        if self.api_client.client_side_validation and ('log_id' not in params or
                                                       params['log_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `log_id` when calling `delete_endpoint_log`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501
        if 'log_id' in params:
            path_params['logId'] = params['log_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'token']  # noqa: E501

        return self.api_client.call_api(
            '/endpoints/{id}/files/logs/{logId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_endpoint_logs(self, id, **kwargs):  # noqa: E501
        """Deletes the specified audio and transcription logs that have been stored for a given endpoint. It deletes all logs before (and including) a specific day.  # noqa: E501

        The deletion process is done asynchronously and can take up to one day depending on the amount of log files.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_endpoint_logs(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: The identifier of the endpoint. (required)
        :param str end_date: The end date of the audio logs deletion (specific day, UTC).              Expected format: \"yyyy-mm-dd\". For instance, \"2019-09-20\" results in deleting all logs on September 20h, 2019 and before.              Deletes all existing logs when date is not specified.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_endpoint_logs_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_endpoint_logs_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def delete_endpoint_logs_with_http_info(self, id, **kwargs):  # noqa: E501
        """Deletes the specified audio and transcription logs that have been stored for a given endpoint. It deletes all logs before (and including) a specific day.  # noqa: E501

        The deletion process is done asynchronously and can take up to one day depending on the amount of log files.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_endpoint_logs_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: The identifier of the endpoint. (required)
        :param str end_date: The end date of the audio logs deletion (specific day, UTC).              Expected format: \"yyyy-mm-dd\". For instance, \"2019-09-20\" results in deleting all logs on September 20h, 2019 and before.              Deletes all existing logs when date is not specified.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'end_date']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_endpoint_logs" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in params or
                                                       params['id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `id` when calling `delete_endpoint_logs`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'end_date' in params:
            query_params.append(('endDate', params['end_date']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'token']  # noqa: E501

        return self.api_client.call_api(
            '/endpoints/{id}/files/logs', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_base_model_log(self, locale, log_id, **kwargs):  # noqa: E501
        """Gets a specific audio or transcription log for the default base model in a given language.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_base_model_log(locale, log_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str locale: The language used to select the default base model. (required)
        :param str log_id: The identifier of the log. (required)
        :param int sas_validity_in_seconds: The duration in seconds that an SAS url should be valid. The default duration is 12 hours.              When using BYOS (https://docs.microsoft.com/en-us/azure/cognitive-services/speech-service/speech-encryption-of-data-at-rest#bring-your-own-storage-byos-for-customization-and-logging): A value of 0 means that a plain blob URI without SAS token will be generated.
        :return: File
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_base_model_log_with_http_info(locale, log_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_base_model_log_with_http_info(locale, log_id, **kwargs)  # noqa: E501
            return data

    def get_base_model_log_with_http_info(self, locale, log_id, **kwargs):  # noqa: E501
        """Gets a specific audio or transcription log for the default base model in a given language.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_base_model_log_with_http_info(locale, log_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str locale: The language used to select the default base model. (required)
        :param str log_id: The identifier of the log. (required)
        :param int sas_validity_in_seconds: The duration in seconds that an SAS url should be valid. The default duration is 12 hours.              When using BYOS (https://docs.microsoft.com/en-us/azure/cognitive-services/speech-service/speech-encryption-of-data-at-rest#bring-your-own-storage-byos-for-customization-and-logging): A value of 0 means that a plain blob URI without SAS token will be generated.
        :return: File
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['locale', 'log_id', 'sas_validity_in_seconds']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_base_model_log" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'locale' is set
        if self.api_client.client_side_validation and ('locale' not in params or
                                                       params['locale'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `locale` when calling `get_base_model_log`")  # noqa: E501
        # verify the required parameter 'log_id' is set
        if self.api_client.client_side_validation and ('log_id' not in params or
                                                       params['log_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `log_id` when calling `get_base_model_log`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'locale' in params:
            path_params['locale'] = params['locale']  # noqa: E501
        if 'log_id' in params:
            path_params['logId'] = params['log_id']  # noqa: E501

        query_params = []
        if 'sas_validity_in_seconds' in params:
            query_params.append(('sasValidityInSeconds', params['sas_validity_in_seconds']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'token']  # noqa: E501

        return self.api_client.call_api(
            '/endpoints/base/{locale}/files/logs/{logId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='File',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_base_model_logs(self, locale, **kwargs):  # noqa: E501
        """Gets the list of audio and transcription logs that have been stored when using the default base model of a given language.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_base_model_logs(locale, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str locale: The language used to select the default base model. (required)
        :param int sas_validity_in_seconds: The duration in seconds that an SAS url should be valid. The default duration is 12 hours.              When using BYOS (https://docs.microsoft.com/en-us/azure/cognitive-services/speech-service/speech-encryption-of-data-at-rest#bring-your-own-storage-byos-for-customization-and-logging): A value of 0 means that a plain blob URI without SAS token will be generated.
        :param str skip_token: Token to skip logs that were already retrieved in previous requests. Pagination starts from beginning when not defined.
        :param int top: Number of datasets that will be included after skipping.
        :return: PaginatedFiles
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_base_model_logs_with_http_info(locale, **kwargs)  # noqa: E501
        else:
            (data) = self.get_base_model_logs_with_http_info(locale, **kwargs)  # noqa: E501
            return data

    def get_base_model_logs_with_http_info(self, locale, **kwargs):  # noqa: E501
        """Gets the list of audio and transcription logs that have been stored when using the default base model of a given language.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_base_model_logs_with_http_info(locale, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str locale: The language used to select the default base model. (required)
        :param int sas_validity_in_seconds: The duration in seconds that an SAS url should be valid. The default duration is 12 hours.              When using BYOS (https://docs.microsoft.com/en-us/azure/cognitive-services/speech-service/speech-encryption-of-data-at-rest#bring-your-own-storage-byos-for-customization-and-logging): A value of 0 means that a plain blob URI without SAS token will be generated.
        :param str skip_token: Token to skip logs that were already retrieved in previous requests. Pagination starts from beginning when not defined.
        :param int top: Number of datasets that will be included after skipping.
        :return: PaginatedFiles
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['locale', 'sas_validity_in_seconds', 'skip_token', 'top']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_base_model_logs" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'locale' is set
        if self.api_client.client_side_validation and ('locale' not in params or
                                                       params['locale'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `locale` when calling `get_base_model_logs`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'locale' in params:
            path_params['locale'] = params['locale']  # noqa: E501

        query_params = []
        if 'sas_validity_in_seconds' in params:
            query_params.append(('sasValidityInSeconds', params['sas_validity_in_seconds']))  # noqa: E501
        if 'skip_token' in params:
            query_params.append(('skipToken', params['skip_token']))  # noqa: E501
        if 'top' in params:
            query_params.append(('top', params['top']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'token']  # noqa: E501

        return self.api_client.call_api(
            '/endpoints/base/{locale}/files/logs', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PaginatedFiles',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_endpoint(self, id, **kwargs):  # noqa: E501
        """Gets the endpoint identified by the given ID.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_endpoint(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: The identifier of the endpoint. (required)
        :return: Endpoint
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_endpoint_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_endpoint_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def get_endpoint_with_http_info(self, id, **kwargs):  # noqa: E501
        """Gets the endpoint identified by the given ID.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_endpoint_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: The identifier of the endpoint. (required)
        :return: Endpoint
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_endpoint" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in params or
                                                       params['id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `id` when calling `get_endpoint`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'token']  # noqa: E501

        return self.api_client.call_api(
            '/endpoints/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Endpoint',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_endpoint_log(self, id, log_id, **kwargs):  # noqa: E501
        """Gets a specific audio or transcription log for a given endpoint.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_endpoint_log(id, log_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: The identifier of the endpoint. (required)
        :param str log_id: The identifier of the log. (required)
        :param int sas_validity_in_seconds: The duration in seconds that an SAS url should be valid. The default duration is 12 hours.              When using BYOS (https://docs.microsoft.com/en-us/azure/cognitive-services/speech-service/speech-encryption-of-data-at-rest#bring-your-own-storage-byos-for-customization-and-logging): A value of 0 means that a plain blob URI without SAS token will be generated.
        :return: File
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_endpoint_log_with_http_info(id, log_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_endpoint_log_with_http_info(id, log_id, **kwargs)  # noqa: E501
            return data

    def get_endpoint_log_with_http_info(self, id, log_id, **kwargs):  # noqa: E501
        """Gets a specific audio or transcription log for a given endpoint.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_endpoint_log_with_http_info(id, log_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: The identifier of the endpoint. (required)
        :param str log_id: The identifier of the log. (required)
        :param int sas_validity_in_seconds: The duration in seconds that an SAS url should be valid. The default duration is 12 hours.              When using BYOS (https://docs.microsoft.com/en-us/azure/cognitive-services/speech-service/speech-encryption-of-data-at-rest#bring-your-own-storage-byos-for-customization-and-logging): A value of 0 means that a plain blob URI without SAS token will be generated.
        :return: File
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'log_id', 'sas_validity_in_seconds']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_endpoint_log" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in params or
                                                       params['id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `id` when calling `get_endpoint_log`")  # noqa: E501
        # verify the required parameter 'log_id' is set
        if self.api_client.client_side_validation and ('log_id' not in params or
                                                       params['log_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `log_id` when calling `get_endpoint_log`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501
        if 'log_id' in params:
            path_params['logId'] = params['log_id']  # noqa: E501

        query_params = []
        if 'sas_validity_in_seconds' in params:
            query_params.append(('sasValidityInSeconds', params['sas_validity_in_seconds']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'token']  # noqa: E501

        return self.api_client.call_api(
            '/endpoints/{id}/files/logs/{logId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='File',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_endpoint_logs(self, id, **kwargs):  # noqa: E501
        """Gets the list of audio and transcription logs that have been stored for a given endpoint.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_endpoint_logs(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: The identifier of the endpoint. (required)
        :param int sas_validity_in_seconds: The duration in seconds that an SAS url should be valid. The default duration is 12 hours.              When using BYOS (https://docs.microsoft.com/en-us/azure/cognitive-services/speech-service/speech-encryption-of-data-at-rest#bring-your-own-storage-byos-for-customization-and-logging): A value of 0 means that a plain blob URI without SAS token will be generated.
        :param str skip_token: Token to skip logs that were already retrieved in previous requests. Pagination starts from beginning when not defined.
        :param int top: Number of datasets that will be included after skipping.
        :return: PaginatedFiles
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_endpoint_logs_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_endpoint_logs_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def get_endpoint_logs_with_http_info(self, id, **kwargs):  # noqa: E501
        """Gets the list of audio and transcription logs that have been stored for a given endpoint.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_endpoint_logs_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: The identifier of the endpoint. (required)
        :param int sas_validity_in_seconds: The duration in seconds that an SAS url should be valid. The default duration is 12 hours.              When using BYOS (https://docs.microsoft.com/en-us/azure/cognitive-services/speech-service/speech-encryption-of-data-at-rest#bring-your-own-storage-byos-for-customization-and-logging): A value of 0 means that a plain blob URI without SAS token will be generated.
        :param str skip_token: Token to skip logs that were already retrieved in previous requests. Pagination starts from beginning when not defined.
        :param int top: Number of datasets that will be included after skipping.
        :return: PaginatedFiles
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'sas_validity_in_seconds', 'skip_token', 'top']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_endpoint_logs" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in params or
                                                       params['id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `id` when calling `get_endpoint_logs`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'sas_validity_in_seconds' in params:
            query_params.append(('sasValidityInSeconds', params['sas_validity_in_seconds']))  # noqa: E501
        if 'skip_token' in params:
            query_params.append(('skipToken', params['skip_token']))  # noqa: E501
        if 'top' in params:
            query_params.append(('top', params['top']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'token']  # noqa: E501

        return self.api_client.call_api(
            '/endpoints/{id}/files/logs', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PaginatedFiles',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_endpoints(self, **kwargs):  # noqa: E501
        """Gets the list of endpoints for the authenticated subscription.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_endpoints(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int skip: Number of datasets that will be skipped.
        :param int top: Number of datasets that will be included after skipping.
        :return: PaginatedEndpoints
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_endpoints_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_endpoints_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_endpoints_with_http_info(self, **kwargs):  # noqa: E501
        """Gets the list of endpoints for the authenticated subscription.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_endpoints_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int skip: Number of datasets that will be skipped.
        :param int top: Number of datasets that will be included after skipping.
        :return: PaginatedEndpoints
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['skip', 'top']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_endpoints" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'skip' in params:
            query_params.append(('skip', params['skip']))  # noqa: E501
        if 'top' in params:
            query_params.append(('top', params['top']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'token']  # noqa: E501

        return self.api_client.call_api(
            '/endpoints', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PaginatedEndpoints',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_supported_locales_for_endpoints(self, **kwargs):  # noqa: E501
        """Gets a list of supported locales for endpoint creations.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_supported_locales_for_endpoints(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: list[str]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_supported_locales_for_endpoints_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_supported_locales_for_endpoints_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_supported_locales_for_endpoints_with_http_info(self, **kwargs):  # noqa: E501
        """Gets a list of supported locales for endpoint creations.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_supported_locales_for_endpoints_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: list[str]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_supported_locales_for_endpoints" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'token']  # noqa: E501

        return self.api_client.call_api(
            '/endpoints/locales', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[str]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_endpoint(self, id, endpoint_update, **kwargs):  # noqa: E501
        """Updates the metadata of the endpoint identified by the given ID.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_endpoint(id, endpoint_update, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: The identifier of the endpoint. (required)
        :param EndpointUpdate endpoint_update: The updated values for the endpoint. (required)
        :return: Endpoint
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_endpoint_with_http_info(id, endpoint_update, **kwargs)  # noqa: E501
        else:
            (data) = self.update_endpoint_with_http_info(id, endpoint_update, **kwargs)  # noqa: E501
            return data

    def update_endpoint_with_http_info(self, id, endpoint_update, **kwargs):  # noqa: E501
        """Updates the metadata of the endpoint identified by the given ID.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_endpoint_with_http_info(id, endpoint_update, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: The identifier of the endpoint. (required)
        :param EndpointUpdate endpoint_update: The updated values for the endpoint. (required)
        :return: Endpoint
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'endpoint_update']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_endpoint" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in params or
                                                       params['id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `id` when calling `update_endpoint`")  # noqa: E501
        # verify the required parameter 'endpoint_update' is set
        if self.api_client.client_side_validation and ('endpoint_update' not in params or
                                                       params['endpoint_update'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `endpoint_update` when calling `update_endpoint`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'endpoint_update' in params:
            body_params = params['endpoint_update']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/merge-patch+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'token']  # noqa: E501

        return self.api_client.call_api(
            '/endpoints/{id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Endpoint',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
