# coding: utf-8

"""
    Speech Services API v3.0

    Speech Services API v3.0.  # noqa: E501

    OpenAPI spec version: v3.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from swagger_client.api_client import ApiClient


class CustomSpeechDatasetsForModelAdaptationApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_dataset(self, dataset, **kwargs):  # noqa: E501
        """Uploads and creates a new dataset by getting the data from a specified URL.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_dataset(dataset, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Dataset dataset: Definition for the new dataset. (required)
        :return: Dataset
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_dataset_with_http_info(dataset, **kwargs)  # noqa: E501
        else:
            (data) = self.create_dataset_with_http_info(dataset, **kwargs)  # noqa: E501
            return data

    def create_dataset_with_http_info(self, dataset, **kwargs):  # noqa: E501
        """Uploads and creates a new dataset by getting the data from a specified URL.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_dataset_with_http_info(dataset, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Dataset dataset: Definition for the new dataset. (required)
        :return: Dataset
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['dataset']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_dataset" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'dataset' is set
        if self.api_client.client_side_validation and ('dataset' not in params or
                                                       params['dataset'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `dataset` when calling `create_dataset`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'dataset' in params:
            body_params = params['dataset']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'token']  # noqa: E501

        return self.api_client.call_api(
            '/datasets', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Dataset',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_dataset(self, id, **kwargs):  # noqa: E501
        """Deletes the specified dataset.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_dataset(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: The identifier of the dataset. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_dataset_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_dataset_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def delete_dataset_with_http_info(self, id, **kwargs):  # noqa: E501
        """Deletes the specified dataset.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_dataset_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: The identifier of the dataset. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_dataset" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in params or
                                                       params['id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `id` when calling `delete_dataset`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'token']  # noqa: E501

        return self.api_client.call_api(
            '/datasets/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_dataset(self, id, **kwargs):  # noqa: E501
        """Gets the dataset identified by the given ID.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_dataset(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: The identifier of the dataset. (required)
        :return: Dataset
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_dataset_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_dataset_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def get_dataset_with_http_info(self, id, **kwargs):  # noqa: E501
        """Gets the dataset identified by the given ID.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_dataset_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: The identifier of the dataset. (required)
        :return: Dataset
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_dataset" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in params or
                                                       params['id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `id` when calling `get_dataset`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'token']  # noqa: E501

        return self.api_client.call_api(
            '/datasets/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Dataset',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_dataset_file(self, id, file_id, **kwargs):  # noqa: E501
        """Gets one specific file (identified with fileId) from a dataset (identified with id).  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_dataset_file(id, file_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: The identifier of the dataset. (required)
        :param str file_id: The identifier of the file. (required)
        :param int sas_validity_in_seconds: The duration in seconds that an SAS url should be valid. The default duration is 12 hours.              When using BYOS (https://docs.microsoft.com/en-us/azure/cognitive-services/speech-service/speech-encryption-of-data-at-rest#bring-your-own-storage-byos-for-customization-and-logging): A value of 0 means that a plain blob URI without SAS token will be generated.
        :return: File
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_dataset_file_with_http_info(id, file_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_dataset_file_with_http_info(id, file_id, **kwargs)  # noqa: E501
            return data

    def get_dataset_file_with_http_info(self, id, file_id, **kwargs):  # noqa: E501
        """Gets one specific file (identified with fileId) from a dataset (identified with id).  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_dataset_file_with_http_info(id, file_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: The identifier of the dataset. (required)
        :param str file_id: The identifier of the file. (required)
        :param int sas_validity_in_seconds: The duration in seconds that an SAS url should be valid. The default duration is 12 hours.              When using BYOS (https://docs.microsoft.com/en-us/azure/cognitive-services/speech-service/speech-encryption-of-data-at-rest#bring-your-own-storage-byos-for-customization-and-logging): A value of 0 means that a plain blob URI without SAS token will be generated.
        :return: File
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'file_id', 'sas_validity_in_seconds']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_dataset_file" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in params or
                                                       params['id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `id` when calling `get_dataset_file`")  # noqa: E501
        # verify the required parameter 'file_id' is set
        if self.api_client.client_side_validation and ('file_id' not in params or
                                                       params['file_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `file_id` when calling `get_dataset_file`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501
        if 'file_id' in params:
            path_params['fileId'] = params['file_id']  # noqa: E501

        query_params = []
        if 'sas_validity_in_seconds' in params:
            query_params.append(('sasValidityInSeconds', params['sas_validity_in_seconds']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'token']  # noqa: E501

        return self.api_client.call_api(
            '/datasets/{id}/files/{fileId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='File',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_dataset_files(self, id, **kwargs):  # noqa: E501
        """Gets the files of the dataset identified by the given ID.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_dataset_files(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: The identifier of the dataset. (required)
        :param int sas_validity_in_seconds: The duration in seconds that an SAS url should be valid. The default duration is 12 hours.              When using BYOS (https://docs.microsoft.com/en-us/azure/cognitive-services/speech-service/speech-encryption-of-data-at-rest#bring-your-own-storage-byos-for-customization-and-logging): A value of 0 means that a plain blob URI without SAS token will be generated.
        :param int skip: Number of datasets that will be skipped.
        :param int top: Number of datasets that will be included after skipping.
        :return: PaginatedFiles
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_dataset_files_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_dataset_files_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def get_dataset_files_with_http_info(self, id, **kwargs):  # noqa: E501
        """Gets the files of the dataset identified by the given ID.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_dataset_files_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: The identifier of the dataset. (required)
        :param int sas_validity_in_seconds: The duration in seconds that an SAS url should be valid. The default duration is 12 hours.              When using BYOS (https://docs.microsoft.com/en-us/azure/cognitive-services/speech-service/speech-encryption-of-data-at-rest#bring-your-own-storage-byos-for-customization-and-logging): A value of 0 means that a plain blob URI without SAS token will be generated.
        :param int skip: Number of datasets that will be skipped.
        :param int top: Number of datasets that will be included after skipping.
        :return: PaginatedFiles
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'sas_validity_in_seconds', 'skip', 'top']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_dataset_files" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in params or
                                                       params['id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `id` when calling `get_dataset_files`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'sas_validity_in_seconds' in params:
            query_params.append(('sasValidityInSeconds', params['sas_validity_in_seconds']))  # noqa: E501
        if 'skip' in params:
            query_params.append(('skip', params['skip']))  # noqa: E501
        if 'top' in params:
            query_params.append(('top', params['top']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'token']  # noqa: E501

        return self.api_client.call_api(
            '/datasets/{id}/files', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PaginatedFiles',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_datasets(self, **kwargs):  # noqa: E501
        """Gets a list of datasets for the authenticated subscription.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_datasets(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int skip: Number of datasets that will be skipped.
        :param int top: Number of datasets that will be included after skipping.
        :return: PaginatedDatasets
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_datasets_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_datasets_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_datasets_with_http_info(self, **kwargs):  # noqa: E501
        """Gets a list of datasets for the authenticated subscription.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_datasets_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int skip: Number of datasets that will be skipped.
        :param int top: Number of datasets that will be included after skipping.
        :return: PaginatedDatasets
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['skip', 'top']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_datasets" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'skip' in params:
            query_params.append(('skip', params['skip']))  # noqa: E501
        if 'top' in params:
            query_params.append(('top', params['top']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'token']  # noqa: E501

        return self.api_client.call_api(
            '/datasets', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PaginatedDatasets',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_supported_locales_for_datasets(self, **kwargs):  # noqa: E501
        """Gets a list of supported locales for datasets.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_supported_locales_for_datasets(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: DatasetLocales
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_supported_locales_for_datasets_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_supported_locales_for_datasets_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_supported_locales_for_datasets_with_http_info(self, **kwargs):  # noqa: E501
        """Gets a list of supported locales for datasets.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_supported_locales_for_datasets_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: DatasetLocales
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_supported_locales_for_datasets" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'token']  # noqa: E501

        return self.api_client.call_api(
            '/datasets/locales', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DatasetLocales',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_dataset(self, id, dataset_update, **kwargs):  # noqa: E501
        """Updates the mutable details of the dataset identified by its ID.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_dataset(id, dataset_update, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: The identifier of the dataset. (required)
        :param DatasetUpdate dataset_update: The updated values for the dataset. (required)
        :return: Dataset
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_dataset_with_http_info(id, dataset_update, **kwargs)  # noqa: E501
        else:
            (data) = self.update_dataset_with_http_info(id, dataset_update, **kwargs)  # noqa: E501
            return data

    def update_dataset_with_http_info(self, id, dataset_update, **kwargs):  # noqa: E501
        """Updates the mutable details of the dataset identified by its ID.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_dataset_with_http_info(id, dataset_update, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: The identifier of the dataset. (required)
        :param DatasetUpdate dataset_update: The updated values for the dataset. (required)
        :return: Dataset
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'dataset_update']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_dataset" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in params or
                                                       params['id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `id` when calling `update_dataset`")  # noqa: E501
        # verify the required parameter 'dataset_update' is set
        if self.api_client.client_side_validation and ('dataset_update' not in params or
                                                       params['dataset_update'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `dataset_update` when calling `update_dataset`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'dataset_update' in params:
            body_params = params['dataset_update']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/merge-patch+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'token']  # noqa: E501

        return self.api_client.call_api(
            '/datasets/{id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Dataset',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def upload_dataset_from_form(self, display_name, locale, kind, **kwargs):  # noqa: E501
        """Uploads data and creates a new dataset.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.upload_dataset_from_form(display_name, locale, kind, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str display_name: The name of this dataset (required). (required)
        :param str locale: The locale of this dataset (required). (required)
        :param str kind: The kind of the dataset (required). Possible values are \"Language\", \"Acoustic\", \"Pronunciation\", \"AudioFiles\". (required)
        :param str project: The optional string representation of the url of a project. If set, the dataset will be associated with that project.
        :param str description: Optional description of this dataset.
        :param str custom_properties: The optional custom properties of this entity. The maximum allowed key length is 64 characters, the maximum allowed value length is 256 characters and the count of allowed entries is 10.
        :param file data: For acoustic datasets, a zip file containing the audio data and a text file containing the transcriptions for the audio data. For language datasets, a text file containing the language or pronunciation data. Required in both cases.
        :param str email: An optional string containing the email address to send email notifications to in case the operation completes. The value will be removed after successfully sending the email.
        :return: Dataset
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.upload_dataset_from_form_with_http_info(display_name, locale, kind, **kwargs)  # noqa: E501
        else:
            (data) = self.upload_dataset_from_form_with_http_info(display_name, locale, kind, **kwargs)  # noqa: E501
            return data

    def upload_dataset_from_form_with_http_info(self, display_name, locale, kind, **kwargs):  # noqa: E501
        """Uploads data and creates a new dataset.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.upload_dataset_from_form_with_http_info(display_name, locale, kind, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str display_name: The name of this dataset (required). (required)
        :param str locale: The locale of this dataset (required). (required)
        :param str kind: The kind of the dataset (required). Possible values are \"Language\", \"Acoustic\", \"Pronunciation\", \"AudioFiles\". (required)
        :param str project: The optional string representation of the url of a project. If set, the dataset will be associated with that project.
        :param str description: Optional description of this dataset.
        :param str custom_properties: The optional custom properties of this entity. The maximum allowed key length is 64 characters, the maximum allowed value length is 256 characters and the count of allowed entries is 10.
        :param file data: For acoustic datasets, a zip file containing the audio data and a text file containing the transcriptions for the audio data. For language datasets, a text file containing the language or pronunciation data. Required in both cases.
        :param str email: An optional string containing the email address to send email notifications to in case the operation completes. The value will be removed after successfully sending the email.
        :return: Dataset
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['display_name', 'locale', 'kind', 'project', 'description', 'custom_properties', 'data', 'email']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method upload_dataset_from_form" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'display_name' is set
        if self.api_client.client_side_validation and ('display_name' not in params or
                                                       params['display_name'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `display_name` when calling `upload_dataset_from_form`")  # noqa: E501
        # verify the required parameter 'locale' is set
        if self.api_client.client_side_validation and ('locale' not in params or
                                                       params['locale'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `locale` when calling `upload_dataset_from_form`")  # noqa: E501
        # verify the required parameter 'kind' is set
        if self.api_client.client_side_validation and ('kind' not in params or
                                                       params['kind'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `kind` when calling `upload_dataset_from_form`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'project' in params:
            form_params.append(('project', params['project']))  # noqa: E501
        if 'display_name' in params:
            form_params.append(('displayName', params['display_name']))  # noqa: E501
        if 'description' in params:
            form_params.append(('description', params['description']))  # noqa: E501
        if 'locale' in params:
            form_params.append(('locale', params['locale']))  # noqa: E501
        if 'kind' in params:
            form_params.append(('kind', params['kind']))  # noqa: E501
        if 'custom_properties' in params:
            form_params.append(('customProperties', params['custom_properties']))  # noqa: E501
        if 'data' in params:
            local_var_files['data'] = params['data']  # noqa: E501
        if 'email' in params:
            form_params.append(('email', params['email']))  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key', 'token']  # noqa: E501

        return self.api_client.call_api(
            '/datasets/upload', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Dataset',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
