# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['tom_alertstreams',
 'tom_alertstreams.alertstreams',
 'tom_alertstreams.management.commands',
 'tom_alertstreams.migrations']

package_data = \
{'': ['*']}

install_requires = \
['gcn-kafka>=0.2,<0.3',
 'hop-client>=0.7,<0.8',
 'psycopg2-binary>=2.9,<3.0',
 'tomtoolkit>=2.10,<3.0']

setup_kwargs = {
    'name': 'tom-alertstreams',
    'version': '0.4.2',
    'description': 'Reusable TOMToolkit app for listening to kafka streams.',
    'long_description': '# tom-alertstreams\n\n`tom-alertstreams` is a reusable TOM Toolkit app for listening to kafka streams.\n\n`tom-alertstreams` provides a management command, `readstreams`. There are no `urlpatterns`,\nno Views, and no templates. The `readstreams` management command reads the `settings.py` `ALERT_STREAMS`\nconfiguration and starts listening to each configured Kafka stream. It is not expected\nto return, and is intended to run along side your TOM\'s server component. The `ALERT_STREAMS`\nconfiguration (see below) tells `readstreams` what streams to access, how to access them,\nwhat topics to listen to, and what to do with messages that arrive on a given topic.\n\n## Installation\n\n1. Install the package into your TOM environment:\n    ```bash\n    pip install tom-alertstreams\n   ```\n\n2. In your project `settings.py`, add `tom_alertstreams` to your `INSTALLED_APPS` setting:\n\n    ```python\n    INSTALLED_APPS = [\n        ...\n        \'tom_alertstreams\',\n    ]\n    ```\n\nAt this point you can verify the installation by running `./manage.py` to list the available\nmanagement commands and see\n\n   ```bash\n   [tom_alertstreams]\n       readstreams\n   ```\nin the output.\n\n## Configuration\n\nEach Kafka stream that your TOM listens to (via `readstreams`) will have a configuration dictionary\nin your `settings.py` `ALERT_STREAMS`. `ALERT_STREAMS` is a list of configuration dictionaries, one\ndictionary for each Kafka stream. Here\'s an example `ALERT_STREAMS` configuration for two Kafka streams:\n[SCiMMA Hopskotch](https://scimma.org/hopskotch.html) and\n[GCN Classic over Kafka](https://gcn.nasa.gov/quickstart).\n\n```python\nALERT_STREAMS = [\n    {\n        \'ACTIVE\': True,\n        \'NAME\': \'tom_alertstreams.alertstreams.hopskotch.HopskotchAlertStream\',\n        \'OPTIONS\': {\n            \'URL\': \'kafka://kafka.scimma.org/\',\n            \'USERNAME\': os.getenv(\'SCIMMA_AUTH_USERNAME\', None),\n            \'PASSWORD\': os.getenv(\'SCIMMA_AUTH_PASSWORD\', None),\n            \'TOPIC_HANDLERS\': {\n                \'sys.heartbeat\': \'tom_alertstreams.alertstreams.hopskotch.heartbeat_handler\',\n                \'tomtoolkit.test\': \'tom_alertstreams.alertstreams.hopskotch.alert_logger\',\n                \'hermes.test\': \'tom_alertstreams.alertstreams.hopskotch.alert_logger\',\n            },\n        },\n    },\n    {\n        \'ACTIVE\': True,\n        \'NAME\': \'tom_alertstreams.alertstreams.gcn.GCNClassicAlertStream\',\n        # The keys of the OPTIONS dictionary become (lower-case) properties of the AlertStream instance.\n        \'OPTIONS\': {\n            # see https://github.com/nasa-gcn/gcn-kafka-python#to-use for configuration details.\n            \'GCN_CLASSIC_CLIENT_ID\': os.getenv(\'GCN_CLASSIC_CLIENT_ID\', None),\n            \'GCN_CLASSIC_CLIENT_SECRET\': os.getenv(\'GCN_CLASSIC_CLIENT_SECRET\', None),\n            \'DOMAIN\': \'gcn.nasa.gov\',  # optional, defaults to \'gcn.nasa.gov\'\n            \'CONFIG\': {  # optional\n                # \'group.id\': \'tom_alertstreams-my-custom-group-id\',\n                # \'auto.offset.reset\': \'earliest\',\n                # \'enable.auto.commit\': False\n            },\n            \'TOPIC_HANDLERS\': {\n                \'gcn.classic.text.LVC_INITIAL\': \'tom_alertstreams.alertstreams.alertstream.alert_logger\',\n                \'gcn.classic.text.LVC_PRELIMINARY\': \'tom_alertstreams.alertstreams.alertstream.alert_logger\',\n                \'gcn.classic.text.LVC_RETRACTION\': \'tom_alertstreams.alertstreams.alertstream.alert_logger\',\n            },\n        },\n    }\n]\n```\n\nThe configuration dictionary for each `AlertStream` subclass will contain these key-value pairs:\n* `ACTIVE`: Boolean which tells `readstreams` to access this stream. Should be `True`, unless you want to\nkeep a configuration dictionary, but ignore the stream.\n* `NAME`: The name of the `AlertStream` subclass that implements the interface to this Kafka stream. `tom_alertstreams`\nwill provide `AlertStream` subclasses for major astromical Kafka streams. See below for instructions on Subclassing\nthe `AlertStream` base class.\n* `OPTIONS`: A dictionary of key-value pairs specific to the`AlertStream` subclass given by `NAME`. The doc string for\nthe `AlertStream` subclass should document what is expected. Typically, a URL, authentication information, and a\ndictionary, `TOPIC_HANDLERS`, will be required. See "Subclassing `AlertStream`" below. The `AlertStream` subclass will\nconvert the key-value pairs of the `OPTIONS` dictionary into properties (and values) of the `AlertStream` subclass\ninstance.\n\n### Getting Kafka Stream Credentials\nAs part of your `OPTIONS` for each Kafka stream, you need to configure access credentials. Visit these links\nto get credentials for [Hopskotch](https://hop.scimma.org/) and [GCN Classic over Kafka](https://gcn.nasa.gov/quickstart).\nSet the environment variables with the username and passwords obtained. Do not check them in to your code repository.\n\n\n## Alert Handling\n\nAssuming that an `AlertStream` subclass exists for the Kafka stream of interest,\nthe keys of the `TOPIC_HANDLERS` dictionary are the topics that will be subscribed to. The values\nof the `TOPIC_HANDLERS` dictionary specify alert handling methods that will be imported and called\nfor each alert recieved on that topic. An example is provided,\n`tom_alerts.alertstreams.alertstream.alert_logger`, which simply logs the alert.\n\nTo customize this behaviour according to the needs of your TOM, define an alert handling function for each\ntopic that you wish to subscribe to. Your `TOPIC_HANDLERS` dictionary will have a an entry for each topic\nwhose key is the topic name and whose value is a string indicating the dot-path to the alert handling function.\nWhen the `AlertStream` subclass is instanciated, the `OPTIONS` dictionary is read and an `alert_handler`\ndictionary is created. It is keyed by topic name and it\'s values are the imported callable functions specified by the\ndot-path strings. `readstreams` will call the alert handler for each alert that comes in on the topic. The signiture\nof the alert handling function is specific to the `AlertStream` subclasss.\n\n## Subclassing `AlertStream`\n\nIdeally, As a TOM developer, there is already an `AlertStream`-subclass for the alert stream that you\nwant your TOM to listen to. If so, you need only to configure your TOM to use it in  `settings.py`\n`ALERT_STREAMS`. If you must implement your own `AlertStream` subclass, please get in touch. In the meantime, here\'s a brief outline:\n\n1. Create subclass of `AlertStream`\n2. Create `required_keys` and `allowed_keys` class variables in your `AlertStream`-subclass. These are list of\nstrings refering to the keys of the `OPTIONS` dictionary. The purpose of these is to help TOM developers using\nyour `AlertStream`-subclass with their `ALERT_STREAMS` `OPTIONS` configuration dictionary. \n\n\nmore documentation coming.\n',
    'author': 'TOM Toolkit Project',
    'author_email': 'tomtoolkit@lco.global',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://github.com/TOMToolkit/tom-alertstreams',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.8,<3.12',
}


setup(**setup_kwargs)
