# Code generated by:
# python -m pwiz -e mysql -H mariadb.ibolit.dev -p 3306 -u root -P stage-4 -i
# Date: September 01, 2022 03:19PM
# Database: stage-4
# Peewee version: 3.15.1

from peewee import *

database = MySQLDatabase(None)


class UnknownField(object):
    def __init__(self, *_, **__): pass


class BaseModel(Model):
    class Meta:
        database = database


class AccountManagers(BaseModel):
    created_at = DateTimeField(null=True)
    id = BigAutoField()
    name = CharField()
    updated_at = DateTimeField(null=True)

    class Meta:
        table_name = 'account_managers'


class AnomaliesCheckers(BaseModel):
    class_ = CharField(column_name='class')
    name = CharField()

    class Meta:
        table_name = 'anomalies_checkers'


class AnomaliesCheckersRuns(BaseModel):
    anomalies_checker = ForeignKeyField(column_name='anomalies_checker_id', field='id', model=AnomaliesCheckers)
    from_hour = IntegerField()
    start_hour = IntegerField()
    threshold_abs = IntegerField(constraints=[SQL("DEFAULT 0")])
    threshold_more_less = IntegerField(constraints=[SQL("DEFAULT 0")])
    threshold_pcs = IntegerField(constraints=[SQL("DEFAULT 10")])
    to_hour = IntegerField()

    class Meta:
        table_name = 'anomalies_checkers_runs'


class Roles(BaseModel):
    created_at = DateTimeField(null=True)
    description = TextField(null=True)
    name = CharField(unique=True)
    updated_at = DateTimeField(null=True)

    class Meta:
        table_name = 'roles'


class Users(BaseModel):
    activated_at = DateTimeField(index=True, null=True)
    api_token = CharField(index=True, null=True)
    auto_resume = IntegerField(constraints=[SQL("DEFAULT 0")])
    avatar = CharField(null=True)
    avatar_alias = CharField(null=True)
    chat_pin = IntegerField(constraints=[SQL("DEFAULT 0")])
    code = CharField(null=True)
    created_at = DateTimeField(index=True, null=True)
    date_of_birth = DateField(null=True)
    dead_zone = IntegerField(null=True)
    deleted_at = DateTimeField(index=True, null=True)
    email = CharField(index=True, null=True)
    external_id = CharField(null=True)
    fingerprint = IntegerField(constraints=[SQL("DEFAULT 1")])
    full_name = CharField(index=True)
    gender = CharField(null=True)
    has_primary_acceptance = IntegerField(constraints=[SQL("DEFAULT 0")], index=True)
    hash = CharField(null=True)
    is_showcase = IntegerField(constraints=[SQL("DEFAULT 1")])
    is_test = IntegerField(constraints=[SQL("DEFAULT 0")])
    last_show_stats_at = DateTimeField(null=True)
    notification_delay = IntegerField(constraints=[SQL("DEFAULT 60")])
    password = CharField(null=True)
    phone = CharField(index=True, null=True)
    position = CharField(null=True)
    registration_code = CharField(null=True)
    registration_short_link = CharField(null=True)
    remember_token = CharField(null=True)
    repeated_message = TextField(null=True)
    role = ForeignKeyField(column_name='role_id', field='id', model=Roles, null=True)
    save_video_at = DateTimeField(constraints=[SQL("DEFAULT current_timestamp()")], null=True)
    self_appointment = IntegerField(constraints=[SQL("DEFAULT 0")])
    send_email = IntegerField(constraints=[SQL("DEFAULT 1")])
    send_sms = IntegerField(constraints=[SQL("DEFAULT 1")])
    send_to = CharField(null=True)
    silence = IntegerField(constraints=[SQL("DEFAULT 0")])
    silence_activated_at = DateTimeField(null=True)
    source = CharField(null=True)
    timezone = CharField(null=True)
    trial_time = IntegerField(constraints=[SQL("DEFAULT 0")])
    type = CharField()
    type_chat = CharField(constraints=[SQL("DEFAULT 'free'")])
    unread_client_message = CharField(null=True)
    updated_at = DateTimeField(null=True)

    class Meta:
        table_name = 'users'
        indexes = (
            (('api_token', 'deleted_at'), False),
        )


class Appointments(BaseModel):
    bundle_id = IntegerField(index=True, null=True)
    created_at = DateTimeField(null=True)
    doctor = ForeignKeyField(column_name='doctor_id', field='id', model=Users)
    doctor_new = IntegerField(constraints=[SQL("DEFAULT 0")], index=True)
    end_at = DateTimeField(null=True)
    patient = ForeignKeyField(backref='users_patient_set', column_name='patient_id', field='id', model=Users)
    patient_new = IntegerField(constraints=[SQL("DEFAULT 0")], index=True)
    price_id = IntegerField(index=True, null=True)
    start_at = DateTimeField()
    status = CharField(constraints=[SQL("DEFAULT 'open'")])
    updated_at = DateTimeField(null=True)

    class Meta:
        table_name = 'appointments'


class VideoCallEvents(BaseModel):
    code = IntegerField(unique=True)
    created_at = DateTimeField(null=True)
    message = CharField()
    updated_at = DateTimeField(null=True)

    class Meta:
        table_name = 'video_call_events'


class AppointmentVideoCallEvent(BaseModel):
    appointment = ForeignKeyField(column_name='appointment_id', field='id', model=Appointments)
    created_at = DateTimeField(null=True)
    updated_at = DateTimeField(null=True)
    video_call_event_code = ForeignKeyField(column_name='video_call_event_code', field='code', model=VideoCallEvents)

    class Meta:
        table_name = 'appointment_video_call_event'


class Artifacts(BaseModel):
    created_at = DateTimeField(null=True)
    creator = ForeignKeyField(column_name='creator_id', field='id', model=Users, null=True)
    deleted_at = DateTimeField(null=True)
    external_id = CharField()
    id = BigAutoField()
    owner = ForeignKeyField(backref='users_owner_set', column_name='owner_id', field='id', model=Users, null=True)
    type = CharField()
    updated_at = DateTimeField(null=True)

    class Meta:
        table_name = 'artifacts'


class AudioFiles(BaseModel):
    created_at = DateTimeField(null=True)
    duration = IntegerField()
    extension = CharField()
    id = BigAutoField()
    name = CharField()
    path = CharField()
    size = IntegerField()
    updated_at = DateTimeField(null=True)

    class Meta:
        table_name = 'audio_files'


class BackgroundTasks(BaseModel):
    completed = IntegerField(constraints=[SQL("DEFAULT 0")])
    created_at = DateTimeField(null=True)
    hash = CharField()
    job = CharField(null=True)
    payload = TextField(null=True)
    updated_at = DateTimeField(null=True)
    user = ForeignKeyField(column_name='user_id', field='id', model=Users, null=True)

    class Meta:
        table_name = 'background_tasks'


class Bundles(BaseModel):
    created_at = DateTimeField(null=True)
    price = IntegerField(null=True)
    updated_at = DateTimeField(null=True)

    class Meta:
        table_name = 'bundles'


class CbClinics(BaseModel):
    clinic_branches_id = BigIntegerField()
    clinic_id = BigIntegerField()

    class Meta:
        table_name = 'cb_clinics'
        indexes = (
            (('clinic_id', 'clinic_branches_id'), False),
        )
        primary_key = False


# Possible reference cycle: chat_messages
# Possible reference cycle: chat_messages
class Chats(BaseModel):
    active = IntegerField(constraints=[SQL("DEFAULT 1")])
    created_at = DateTimeField(null=True)
    deleted_at = DateTimeField(null=True)
    doctor = ForeignKeyField(column_name='doctor_id', field='id', model=Users)
    last_chat_message_id = IntegerField(null=True)
    last_med_card_message_id = IntegerField(null=True)
    patient = ForeignKeyField(backref='users_patient_set', column_name='patient_id', field='id', model=Users)
    pin = IntegerField(constraints=[SQL("DEFAULT 0")])
    updated_at = DateTimeField(null=True)

    class Meta:
        table_name = 'chats'
        indexes = (
            (('doctor', 'patient'), True),
        )


class ChatMessages(BaseModel):
    author = ForeignKeyField(column_name='author_id', field='id', model=Users)
    body = TextField(null=True)
    chat = ForeignKeyField(column_name='chat_id', field='id', model=Chats)
    created_at = DateTimeField(index=True, null=True)
    deleted_at = DateTimeField(null=True)
    entity_id = IntegerField(null=True)
    new = IntegerField(constraints=[SQL("DEFAULT 0")], index=True)
    send_push = IntegerField(constraints=[SQL("DEFAULT 1")])
    send_sms = IntegerField(constraints=[SQL("DEFAULT 1")])
    type = CharField(constraints=[SQL("DEFAULT 'text'")], index=True)
    updated_at = DateTimeField(null=True)
    uuid = CharField(null=True, unique=True)

    class Meta:
        table_name = 'chat_messages'


class Files(BaseModel):
    created_at = DateTimeField(null=True)
    deleted_at = DateTimeField(null=True)
    extension = CharField()
    file = CharField()
    name = CharField()
    preview_for = IntegerField(index=True, null=True)
    size = IntegerField(null=True)
    updated_at = DateTimeField(null=True)

    class Meta:
        table_name = 'files'


class CitylabCodes(BaseModel):
    author = ForeignKeyField(column_name='author_id', field='id', model=Users, null=True)
    citylab_estimated_date = DateTimeField(null=True)
    code = CharField(unique=True)
    created_at = DateTimeField(null=True)
    doctor = ForeignKeyField(backref='users_doctor_set', column_name='doctor_id', field='id', model=Users, null=True)
    file = ForeignKeyField(column_name='file_id', field='id', model=Files, null=True)
    patient = ForeignKeyField(backref='users_patient_set', column_name='patient_id', field='id', model=Users)
    send_estimated_date = IntegerField(constraints=[SQL("DEFAULT 0")])
    sender_code = CharField(null=True)
    sender_id = IntegerField(null=True)
    sender_name = CharField(null=True)
    silence = IntegerField(constraints=[SQL("DEFAULT 0")])
    silence_activated_at = DateTimeField(null=True)
    silence_doctor = ForeignKeyField(backref='users_silence_doctor_set', column_name='silence_doctor_id', field='id',
                                     model=Users, null=True)
    updated_at = DateTimeField(null=True)

    class Meta:
        table_name = 'citylab_codes'
        indexes = (
            (('doctor', 'file'), False),
        )


class ClinicBranches(BaseModel):
    created_at = DateTimeField(null=True)
    id = BigAutoField()
    is_active_at = DateTimeField(null=True)
    name = CharField(unique=True)
    updated_at = DateTimeField(null=True)

    class Meta:
        table_name = 'clinic_branches'


class MISIntegrations(BaseModel):
    created_at = DateTimeField(null=True)
    data = TextField()
    id = BigAutoField()
    provider = CharField()
    updated_at = DateTimeField(null=True)

    class Meta:
        table_name = 'm_i_s_integrations'


class Clinics(BaseModel):
    account_manager = ForeignKeyField(column_name='account_manager_id', field='id', model=AccountManagers, null=True)
    active = IntegerField(constraints=[SQL("DEFAULT 0")])
    avatar = CharField(null=True)
    city = CharField()
    client_key = CharField(index=True, null=True)
    client_secret = CharField(null=True)
    created_at = DateTimeField(null=True)
    default_doctor = ForeignKeyField(column_name='default_doctor_id', field='id', model=Users, null=True)
    deleted_at = DateTimeField(null=True)
    description = TextField(null=True)
    email = CharField()
    font_color = CharField(constraints=[SQL("DEFAULT '#ffffff'")])
    health_care_agreement = TextField(null=True)
    include_price = IntegerField(constraints=[SQL("DEFAULT 1")])
    informed_voluntary_consent = TextField(null=True)
    is_demo = IntegerField(null=True)
    is_send_report = IntegerField(constraints=[SQL("DEFAULT 0")])
    is_test = IntegerField(constraints=[SQL("DEFAULT 0")])
    lang = CharField(constraints=[SQL("DEFAULT 'ru'")])
    m_i_s_integration = ForeignKeyField(column_name='m_i_s_integration_id', field='id', model=MISIntegrations,
                                        null=True)
    main_color = CharField(constraints=[SQL("DEFAULT '#e54059'")])
    min_commission = FloatField(constraints=[SQL("DEFAULT 0.00")])
    name = CharField()
    notify_by_email = IntegerField(constraints=[SQL("DEFAULT 0")])
    notify_patient_to_pay_by_sms = IntegerField(constraints=[SQL("DEFAULT 0")])
    parent = ForeignKeyField(column_name='parent_id', field='id', model='self', null=True)
    personal_data_processing_consent = TextField(null=True)
    phone = CharField()
    public_token = CharField(null=True)
    rate = FloatField(null=True)
    rate_type = CharField(constraints=[SQL("DEFAULT 'fixed'")])
    referral_program_key = CharField(null=True)
    registry_doctor = ForeignKeyField(backref='users_registry_doctor_set', column_name='registry_doctor_id', field='id',
                                      model=Users, null=True)
    repeated_message = TextField(null=True)
    save_video_at = DateTimeField(constraints=[SQL("DEFAULT current_timestamp()")], null=True)
    site = CharField(null=True)
    sms_payment = IntegerField(null=True)
    street = CharField()
    transfer_commission = FloatField(constraints=[SQL("DEFAULT 0.00")])
    type = CharField(null=True)
    updated_at = DateTimeField(null=True)
    use_referral = IntegerField(constraints=[SQL("DEFAULT 0")])
    wl_url = CharField(null=True)

    class Meta:
        table_name = 'clinics'


class Partners(BaseModel):
    config = TextField(null=True)
    created_at = DateTimeField(null=True)
    description = TextField(null=True)
    name = CharField()
    token = CharField(null=True)
    updated_at = DateTimeField(null=True)

    class Meta:
        table_name = 'partners'


class ClinicExcludePartner(BaseModel):
    clinic = ForeignKeyField(column_name='clinic_id', field='id', model=Clinics)
    created_at = DateTimeField(null=True)
    partner = ForeignKeyField(column_name='partner_id', field='id', model=Partners)
    updated_at = DateTimeField(null=True)

    class Meta:
        table_name = 'clinic_exclude_partner'
        primary_key = False


class ClinicMetaData(BaseModel):
    additional_contract_date = DateField(null=True)
    additional_license_price = FloatField()
    additional_licenses_count = IntegerField()
    base_contract_date = DateField(null=True)
    base_license_price = FloatField()
    base_licenses_count = IntegerField()
    clinic = ForeignKeyField(column_name='clinic_id', field='id', model=Clinics)
    created_at = DateTimeField(null=True)
    deleted_at = DateTimeField(null=True)
    id = BigAutoField()
    updated_at = DateTimeField(null=True)

    class Meta:
        table_name = 'clinic_meta_data'


class ClinicPartner(BaseModel):
    clinic = ForeignKeyField(column_name='clinic_id', field='id', model=Clinics)
    created_at = DateTimeField(null=True)
    partner = ForeignKeyField(column_name='partner_id', field='id', model=Partners)
    updated_at = DateTimeField(null=True)

    class Meta:
        table_name = 'clinic_partner'
        primary_key = False


class ClinicPartners(BaseModel):
    clinic = ForeignKeyField(column_name='clinic_id', field='id', model=Clinics)
    created_at = DateTimeField(null=True)
    partner = ForeignKeyField(backref='clinics_partner_set', column_name='partner_id', field='id', model=Clinics)
    updated_at = DateTimeField(null=True)
    weight = IntegerField(constraints=[SQL("DEFAULT 0")])

    class Meta:
        table_name = 'clinic_partners'
        primary_key = False


class ClinicSchedules(BaseModel):
    clinic = ForeignKeyField(column_name='clinic_id', field='id', model=Clinics)
    from_ = TimeField(column_name='from')
    id = BigAutoField()
    to = TimeField()
    week_day = IntegerField()

    class Meta:
        table_name = 'clinic_schedules'


class ClinicSla(BaseModel):
    clinic = ForeignKeyField(column_name='clinic_id', field='id', model=Clinics)
    created_at = DateTimeField(null=True)
    doctor_time = IntegerField(null=True)
    email = CharField(null=True)
    head_doctor_time = IntegerField(null=True)
    phone = CharField(null=True)
    turn_on = IntegerField(constraints=[SQL("DEFAULT 0")], index=True)
    updated_at = DateTimeField(null=True)

    class Meta:
        table_name = 'clinic_sla'


class ClinicUser(BaseModel):
    clinic = ForeignKeyField(column_name='clinic_id', field='id', model=Clinics)
    comment = TextField(null=True)
    created_at = DateTimeField(null=True)
    type = CharField(null=True)
    updated_at = DateTimeField(null=True)
    user = ForeignKeyField(column_name='user_id', field='id', model=Users)

    class Meta:
        table_name = 'clinic_user'
        primary_key = False


class Messages(BaseModel):
    channel = CharField()
    created_at = DateTimeField(null=True)
    is_disabled = IntegerField(constraints=[SQL("DEFAULT 0")])
    text = TextField(null=True)
    type = CharField()
    updated_at = DateTimeField(null=True)

    class Meta:
        table_name = 'messages'
        indexes = (
            (('channel', 'type'), False),
        )


class ClinicsMessages(BaseModel):
    clinic = ForeignKeyField(column_name='clinic_id', field='id', model=Clinics)
    message = ForeignKeyField(column_name='message_id', field='id', model=Messages)

    class Meta:
        table_name = 'clinics_messages'
        indexes = (
            (('clinic', 'message'), True),
        )
        primary_key = CompositeKey('clinic', 'message')


class Promotions(BaseModel):
    clinic = ForeignKeyField(column_name='clinic_id', field='id', model=Clinics, null=True)
    created_at = DateTimeField(null=True)
    creator = ForeignKeyField(column_name='creator_id', field='id', model=Users, null=True)
    deleted_at = DateTimeField(null=True)
    discount = IntegerField()
    discount_type = CharField()
    doctors_services_type = CharField()
    end_at = DateTimeField(null=True)
    id = BigAutoField()
    is_active = IntegerField(constraints=[SQL("DEFAULT 0")])
    name = CharField()
    patients_activated_at = DateField(null=True)
    patients_days = IntegerField(null=True)
    patients_type = CharField()
    start_at = DateTimeField(constraints=[SQL("DEFAULT current_timestamp()")])
    updated_at = DateTimeField(null=True)
    use_count = IntegerField(null=True)
    use_type = CharField()

    class Meta:
        table_name = 'promotions'


class PromotionCodes(BaseModel):
    code = CharField()
    created_at = DateTimeField(null=True)
    deleted_at = DateTimeField(null=True)
    id = BigAutoField()
    promotion = ForeignKeyField(column_name='promotion_id', field='id', model=Promotions)
    updated_at = DateTimeField(null=True)

    class Meta:
        table_name = 'promotion_codes'


class Services(BaseModel):
    active = IntegerField()
    auto_message = TextField(null=True)
    can_close = IntegerField()
    code = CharField(null=True)
    created_at = DateTimeField(null=True)
    currency = CharField(constraints=[SQL("DEFAULT 'RUB'")])
    deleted_at = DateTimeField(null=True)
    description = CharField(null=True)
    doctor = ForeignKeyField(column_name='doctor_id', field='id', model=Users)
    duration = IntegerField()
    id = BigAutoField()
    is_auto_resume = IntegerField(constraints=[SQL("DEFAULT 0")])
    is_default = IntegerField(constraints=[SQL("DEFAULT 0")])
    is_hidden = IntegerField(constraints=[SQL("DEFAULT 0")])
    is_on_top = IntegerField(constraints=[SQL("DEFAULT 0")])
    is_subscription = IntegerField(constraints=[SQL("DEFAULT 0")])
    is_trial = IntegerField(constraints=[SQL("DEFAULT 0")])
    name = CharField()
    name_receipt = CharField(null=True)
    old_pay_type = CharField()
    order = IntegerField(null=True)
    price = BigIntegerField()
    service_type = CharField(index=True)
    updated_at = DateTimeField(null=True)

    class Meta:
        table_name = 'services'


class Invoices(BaseModel):
    created_at = DateTimeField(null=True)
    deleted_at = DateTimeField(null=True)
    id = BigAutoField()
    patient = ForeignKeyField(column_name='patient_id', field='id', model=Users)
    promotion_code = ForeignKeyField(column_name='promotion_code_id', field='id', model=PromotionCodes, null=True)
    service = ForeignKeyField(column_name='service_id', field='id', model=Services)
    slot_patient_batch_id = CharField(index=True, null=True)
    status = CharField()
    updated_at = DateTimeField(null=True)

    class Meta:
        table_name = 'invoices'


class ServiceSubscriptions(BaseModel):
    card_last_four = CharField(null=True)
    created_at = DateTimeField(null=True)
    deleted_at = DateTimeField(null=True)
    external_subscription_id = CharField(null=True)
    id = BigAutoField()
    next_transaction_at = DateTimeField(constraints=[SQL("DEFAULT current_timestamp()")], null=True)
    patient = ForeignKeyField(column_name='patient_id', field='id', model=Users)
    service = ForeignKeyField(column_name='service_id', field='id', model=Services)
    status = CharField()
    updated_at = DateTimeField(null=True)

    class Meta:
        table_name = 'service_subscriptions'


class ServicesPatients(BaseModel):
    created_at = DateTimeField(null=True)
    deleted_at = DateTimeField(null=True)
    end_at = DateTimeField(null=True)
    external_id = BigIntegerField(null=True)
    id = BigAutoField()
    invoice = ForeignKeyField(column_name='invoice_id', field='id', model=Invoices, null=True)
    is_finished = IntegerField(constraints=[SQL("DEFAULT 0")])
    patient = ForeignKeyField(column_name='patient_id', field='id', model=Users)
    service = ForeignKeyField(column_name='service_id', field='id', model=Services)
    source = CharField(null=True)
    start_at = DateTimeField(null=True)
    subscription = ForeignKeyField(column_name='subscription_id', field='id', model=ServiceSubscriptions, null=True)
    type = CharField()
    updated_at = DateTimeField(null=True)

    class Meta:
        table_name = 'services_patients'
        indexes = (
            (('type', 'external_id'), False),
        )


class Conclusions(BaseModel):
    appointment = ForeignKeyField(column_name='appointment_id', field='id', model=Appointments, null=True)
    created_at = DateTimeField(null=True)
    service_patient = ForeignKeyField(column_name='service_patient_id', field='id', model=ServicesPatients, null=True)
    text = TextField(null=True)
    updated_at = DateTimeField(null=True)

    class Meta:
        table_name = 'conclusions'


class ConfirmationCodes(BaseModel):
    action = CharField()
    attempts = IntegerField()
    code = CharField()
    created_at = DateTimeField(constraints=[SQL("DEFAULT current_timestamp()")])
    expires_at = DateTimeField()
    is_active = IntegerField()
    user_id = IntegerField()

    class Meta:
        table_name = 'confirmation_codes'


class SlotsDoctors(BaseModel):
    context = CharField()
    created_at = DateTimeField(null=True)
    deleted_at = DateTimeField(null=True)
    doctor = ForeignKeyField(column_name='doctor_id', field='id', model=Users)
    duration = IntegerField()
    end_at = DateTimeField()
    id = BigAutoField()
    start_at = DateTimeField()
    type = CharField()
    updated_at = DateTimeField(null=True)

    class Meta:
        table_name = 'slots_doctors'
        indexes = (
            (('doctor', 'start_at', 'type'), False),
        )


class SlotsDoctorsPatients(BaseModel):
    batch_id = CharField(null=True)
    cancel_reason = TextField(null=True)
    comment = TextField(null=True)
    conclusion = ForeignKeyField(column_name='conclusion_id', field='id', model=Conclusions, null=True)
    confirmed_at = DateTimeField(null=True)
    created_at = DateTimeField(null=True)
    creator_id = IntegerField(null=True)
    deleted_at = DateTimeField(null=True)
    id = BigAutoField()
    is_viewed = IntegerField(constraints=[SQL("DEFAULT 0")])
    parent = ForeignKeyField(column_name='parent_id', field='id', model='self', null=True)
    patient = ForeignKeyField(column_name='patient_id', field='id', model=Users)
    service = ForeignKeyField(column_name='service_id', field='id', model=Services)
    service_patient = ForeignKeyField(column_name='service_patient_id', field='id', model=ServicesPatients, null=True)
    slot_doctor = ForeignKeyField(column_name='slot_doctor_id', field='id', model=SlotsDoctors)
    source = CharField(null=True)
    status = CharField()
    type = CharField()
    updated_at = DateTimeField(null=True)

    class Meta:
        table_name = 'slots_doctors_patients'


class ConsultationRating(BaseModel):
    clinic = ForeignKeyField(column_name='clinic_id', field='id', model=Clinics, null=True)
    created_at = DateTimeField(null=True)
    deleted_at = DateTimeField(null=True)
    doctor = ForeignKeyField(column_name='doctor_id', field='id', model=Users)
    hide_at = DateTimeField(null=True)
    id = BigAutoField()
    message = TextField(null=True)
    patient = ForeignKeyField(backref='users_patient_set', column_name='patient_id', field='id', model=Users)
    rate = IntegerField()
    service = ForeignKeyField(column_name='service_id', field='id', model=Services)
    service_patient = ForeignKeyField(column_name='service_patient_id', field='id', model=ServicesPatients)
    slot_patient = ForeignKeyField(column_name='slot_patient_id', field='id', model=SlotsDoctorsPatients, null=True)
    updated_at = DateTimeField(null=True)

    class Meta:
        table_name = 'consultation_rating'


class ConsultationRatingReplies(BaseModel):
    consultation_rating = ForeignKeyField(column_name='consultation_rating_id', field='id', model=ConsultationRating)
    created_at = DateTimeField(null=True)
    deleted_at = DateTimeField(null=True)
    id = BigAutoField()
    message = TextField()
    updated_at = DateTimeField(null=True)
    user = ForeignKeyField(column_name='user_id', field='id', model=Users, null=True)

    class Meta:
        table_name = 'consultation_rating_replies'


class Consultations(BaseModel):
    created_at = DateTimeField(null=True)
    deleted_at = DateTimeField(null=True)
    doctor = ForeignKeyField(column_name='doctor_id', field='id', model=Users)
    end_at = DateTimeField(null=True)
    external_id = BigIntegerField(index=True)
    external_type = CharField(index=True)
    id = BigAutoField()
    patient = ForeignKeyField(backref='users_patient_set', column_name='patient_id', field='id', model=Users)
    pay_source = CharField(null=True)
    service = ForeignKeyField(column_name='service_id', field='id', model=Services)
    source = CharField(null=True)
    start_at = DateTimeField(null=True)
    status = CharField()
    type = CharField()
    updated_at = DateTimeField(null=True)

    class Meta:
        table_name = 'consultations'


class DailyMetrics(BaseModel):
    class_ = CharField(column_name='class')
    is_accumulated = IntegerField(constraints=[SQL("DEFAULT 0")])
    is_active = IntegerField(constraints=[SQL("DEFAULT 1")])
    name = CharField()
    numeric_type = CharField(constraints=[SQL("DEFAULT 'INT'")])
    output_priority = IntegerField(constraints=[SQL("DEFAULT 0")])
    process_priority = IntegerField(constraints=[SQL("DEFAULT 0")])
    publish2es = IntegerField(constraints=[SQL("DEFAULT 0")])
    type = CharField(constraints=[SQL("DEFAULT 'daily-general'")])

    class Meta:
        table_name = 'daily_metrics'


class DailyMetricsData(BaseModel):
    clinic_id = IntegerField(constraints=[SQL("DEFAULT 0")])
    date = DateField(index=True)
    doctor_id = IntegerField(constraints=[SQL("DEFAULT 0")])
    id = BigAutoField()
    metric_id = IntegerField()
    value = FloatField()

    class Meta:
        table_name = 'daily_metrics_data'
        indexes = (
            (('date', 'metric_id'), False),
            (('metric_id', 'date', 'clinic_id', 'doctor_id'), True),
        )


class DailyMetricsMutexes(BaseModel):
    held = IntegerField(constraints=[SQL("DEFAULT 0")], null=True)
    metric_id = IntegerField(unique=True)

    class Meta:
        table_name = 'daily_metrics_mutexes'


class DailyMetricsTasks(BaseModel):
    created_at = DateTimeField()
    finished_at = DateTimeField(null=True)
    id = BigAutoField()
    metric_id = IntegerField()
    priority = IntegerField(constraints=[SQL("DEFAULT 0")])
    started_at = DateTimeField(null=True)
    status = CharField(constraints=[SQL("DEFAULT 'CREATED'")])

    class Meta:
        table_name = 'daily_metrics_tasks'


class DedicatedOnboardings(BaseModel):
    created_at = DateTimeField(null=True)
    id = BigAutoField()
    is_active = IntegerField(constraints=[SQL("DEFAULT 1")])
    key = CharField(index=True)
    updated_at = DateTimeField(null=True)

    class Meta:
        table_name = 'dedicated_onboardings'


class DedicatedOnboardingViews(BaseModel):
    dedicated_onboarding = ForeignKeyField(column_name='dedicated_onboarding_id', field='id',
                                           model=DedicatedOnboardings)
    id = BigAutoField()
    user = ForeignKeyField(column_name='user_id', field='id', model=Users)

    class Meta:
        table_name = 'dedicated_onboarding_views'


class DedicatedOnboardingsClinicsExceptions(BaseModel):
    clinic = ForeignKeyField(column_name='clinic_id', field='id', model=Clinics)
    dedicated_onboarding = ForeignKeyField(column_name='dedicated_onboarding_id', field='id',
                                           model=DedicatedOnboardings)
    id = BigAutoField()

    class Meta:
        table_name = 'dedicated_onboardings_clinics_exceptions'


class DoctorInformations(BaseModel):
    category = CharField(null=True)
    description = TextField(null=True)
    education = TextField(null=True)
    experience = IntegerField(null=True)
    has_pay_before_minutes = IntegerField(constraints=[SQL("DEFAULT 0")])
    license_status = CharField(null=True)
    pay_before_minutes = IntegerField(null=True)
    percent_income_chat = IntegerField(null=True)
    percent_income_online = IntegerField(null=True)
    user = ForeignKeyField(column_name='user_id', field='id', model=Users, unique=True)

    class Meta:
        table_name = 'doctor_informations'
        primary_key = False


class DoctorPatient(BaseModel):
    confirm_appointment = IntegerField(constraints=[SQL("DEFAULT 0")])
    created_at = DateTimeField(null=True)
    doctor = ForeignKeyField(column_name='doctor_id', field='id', model=Users)
    doctor_new = IntegerField(constraints=[SQL("DEFAULT 0")], index=True)
    is_primary = IntegerField(constraints=[SQL("DEFAULT 0")])
    is_primary_at = DateTimeField(null=True)
    message = TextField(null=True)
    patient = ForeignKeyField(backref='users_patient_set', column_name='patient_id', field='id', model=Users)
    patient_new = IntegerField(constraints=[SQL("DEFAULT 0")], index=True)
    source = CharField(null=True)
    updated_at = DateTimeField(null=True)

    class Meta:
        table_name = 'doctor_patient'


class DoctorSpecialties(BaseModel):
    created_at = DateTimeField(null=True)
    doctor = ForeignKeyField(column_name='doctor_id', field='id', model=Users)
    id = BigAutoField()
    specialty = CharField()
    updated_at = DateTimeField(null=True)

    class Meta:
        table_name = 'doctor_specialties'


class Entities(BaseModel):
    name = CharField()

    class Meta:
        table_name = 'entities'


class Exports(BaseModel):
    created_at = DateTimeField(null=True)
    file = ForeignKeyField(column_name='file_id', field='id', model=Files)
    payload = TextField()
    scope = CharField(index=True)
    updated_at = DateTimeField(null=True)

    class Meta:
        table_name = 'exports'
        indexes = (
            (('scope', 'created_at'), False),
        )


class FailedJobs(BaseModel):
    connection = TextField()
    exception = TextField()
    failed_at = DateTimeField(constraints=[SQL("DEFAULT current_timestamp()")])
    id = BigAutoField()
    payload = TextField()
    queue = TextField()

    class Meta:
        table_name = 'failed_jobs'


class Family(BaseModel):
    child_account = ForeignKeyField(column_name='child_account_id', field='id', model=Users)
    child_role = CharField()
    id = BigAutoField()
    main_account = ForeignKeyField(backref='users_main_account_set', column_name='main_account_id', field='id',
                                   model=Users)

    class Meta:
        table_name = 'family'


class Feedback(BaseModel):
    commentary = TextField(null=True)
    created_at = DateTimeField(null=True)
    new = IntegerField(constraints=[SQL("DEFAULT 1")])
    text = TextField()
    updated_at = DateTimeField(null=True)
    user = ForeignKeyField(column_name='user_id', field='id', model=Users, null=True)

    class Meta:
        table_name = 'feedback'


class Handbook(BaseModel):
    created_at = DateTimeField(null=True)
    description = TextField(null=True)
    id = BigAutoField()
    is_deletable = IntegerField(constraints=[SQL("DEFAULT 1")])
    key = CharField()
    name = CharField(null=True)
    type = CharField()
    updated_at = DateTimeField(null=True)
    value = CharField(null=True)

    class Meta:
        table_name = 'handbook'
        indexes = (
            (('type', 'key'), True),
        )


class ImportTasks(BaseModel):
    author = ForeignKeyField(column_name='author_id', field='id', model=Users, null=True)
    clinic = ForeignKeyField(column_name='clinic_id', field='id', model=Clinics, null=True)
    created_at = DateTimeField(null=True)
    delay = DateTimeField()
    description = CharField(null=True)
    has_errors = IntegerField(constraints=[SQL("DEFAULT 0")])
    hash = CharField()
    payload = TextField()
    report = TextField(null=True)
    status = CharField(constraints=[SQL("DEFAULT 'new'")])
    type = CharField()
    updated_at = DateTimeField(null=True)

    class Meta:
        table_name = 'import_tasks'


class Jobs(BaseModel):
    attempts = IntegerField()
    available_at = IntegerField()
    created_at = IntegerField()
    id = BigAutoField()
    payload = TextField()
    queue = CharField(index=True)
    reserved_at = IntegerField(null=True)

    class Meta:
        table_name = 'jobs'


class Licenses(BaseModel):
    clinic = ForeignKeyField(column_name='clinic_id', field='id', model=Clinics, null=True)
    created_at = DateTimeField(null=True)
    text = TextField()
    updated_at = DateTimeField(null=True)

    class Meta:
        table_name = 'licenses'


class StaticProjects(BaseModel):
    created_at = DateTimeField(null=True)
    hash = CharField(null=True)
    is_active = IntegerField()
    last_build_at = DateTimeField(null=True)
    partner = ForeignKeyField(column_name='partner_id', field='id', model=Partners)
    project_key = CharField(unique=True)
    project_name = CharField()
    updated_at = DateTimeField(null=True)

    class Meta:
        table_name = 'static_projects'


class ListStatics(BaseModel):
    created_at = DateTimeField(null=True)
    element_name = CharField()
    element_type = CharField()
    project = ForeignKeyField(column_name='project_id', field='id', model=StaticProjects)
    updated_at = DateTimeField(null=True)
    value = TextField()

    class Meta:
        table_name = 'list_statics'


class Loggings(BaseModel):
    created_at = DateTimeField(null=True)
    data = TextField(null=True)
    id = BigAutoField()
    type = CharField()
    updated_at = DateTimeField(null=True)
    user_id = BigIntegerField(null=True)

    class Meta:
        table_name = 'loggings'


class Mailings(BaseModel):
    channel = CharField()
    created_at = DateTimeField(null=True)
    errors = TextField(null=True)
    extra_params = TextField(null=True)
    file = ForeignKeyField(column_name='file_id', field='id', model=Files, null=True)
    filters = TextField(null=True)
    id = BigAutoField()
    is_from_file = IntegerField(constraints=[SQL("DEFAULT 0")])
    is_initialized = IntegerField(constraints=[SQL("DEFAULT 0")])
    is_task_created = IntegerField(constraints=[SQL("DEFAULT 0")])
    name = CharField()
    payer_clinic = ForeignKeyField(column_name='payer_clinic_id', field='id', model=Clinics, null=True)
    run_at = DateTimeField()
    sender = ForeignKeyField(column_name='sender_id', field='id', model=Users)
    text = TextField()
    updated_at = DateTimeField(null=True)

    class Meta:
        table_name = 'mailings'


class MailingReceivers(BaseModel):
    created_at = DateTimeField(null=True)
    external_id = CharField(null=True)
    id = BigAutoField()
    is_validation_error = IntegerField(constraints=[SQL("DEFAULT 0")])
    mailing_data = CharField(null=True)
    mailing = ForeignKeyField(column_name='mailing_id', field='id', model=Mailings)
    received_at = DateTimeField(null=True)
    receiver = ForeignKeyField(column_name='receiver_id', field='id', model=Users)
    sent_at = DateTimeField(null=True)
    status = CharField(null=True)
    updated_at = DateTimeField(null=True)
    validation_error = TextField(null=True)

    class Meta:
        table_name = 'mailing_receivers'


class MediaFiles(BaseModel):
    consultation_id = IntegerField(index=True, null=True)
    duration = IntegerField()
    end_at = DateTimeField(constraints=[SQL("DEFAULT '2018-05-06 19:18:16'")])
    external_id = CharField(null=True)
    is_compiled = IntegerField(constraints=[SQL("DEFAULT 0")])
    is_full = IntegerField(constraints=[SQL("DEFAULT 0")])
    is_voximplant_video = IntegerField(constraints=[SQL("DEFAULT 0")])
    mark_delete_at = DateTimeField(null=True)
    name = CharField()
    path = CharField()
    resolution = CharField(null=True)
    start_at = DateTimeField(constraints=[SQL("DEFAULT '2018-05-06 19:18:16'")])

    class Meta:
        table_name = 'media_files'


class MediaserverLog(BaseModel):
    level = CharField(constraints=[SQL("DEFAULT 'info'")])
    message = CharField(constraints=[SQL("DEFAULT 'no message'")])
    timestamp = DateTimeField(index=True)

    class Meta:
        table_name = 'mediaserver_log'
        primary_key = False


class Migrations(BaseModel):
    batch = IntegerField()
    migration = CharField()

    class Meta:
        table_name = 'migrations'


class MobileDevices(BaseModel):
    created_at = DateTimeField(null=True)
    properties = TextField()
    token = CharField(unique=True)
    updated_at = DateTimeField(null=True)

    class Meta:
        table_name = 'mobile_devices'


class MobileDeviceUser(BaseModel):
    created_at = DateTimeField(null=True)
    debug = CharField(constraints=[SQL("DEFAULT 'prod'")])
    mobile_device = ForeignKeyField(column_name='mobile_device_id', field='id', model=MobileDevices)
    updated_at = DateTimeField(null=True)
    user = ForeignKeyField(column_name='user_id', field='id', model=Users)

    class Meta:
        table_name = 'mobile_device_user'


class MobileTokens(BaseModel):
    created_at = DateTimeField(null=True)
    fcm = IntegerField(constraints=[SQL("DEFAULT 0")])
    is_apns = IntegerField(constraints=[SQL("DEFAULT 0")])
    os = CharField()
    token = CharField()
    updated_at = DateTimeField(null=True)
    user = ForeignKeyField(column_name='user_id', field='id', model=Users)

    class Meta:
        table_name = 'mobile_tokens'


class Notifiers(BaseModel):
    created_at = DateTimeField(null=True)
    criteria_container = TextField(null=True)
    id = BigAutoField()
    is_active = IntegerField(constraints=[SQL("DEFAULT 0")])
    message_data = TextField(null=True)
    start_at = DateTimeField(null=True)
    title = CharField(null=True)
    type = CharField()
    updated_at = DateTimeField(null=True)

    class Meta:
        table_name = 'notifiers'


class NotifierResults(BaseModel):
    created_at = DateTimeField(null=True)
    id = BigAutoField()
    meta = TextField(null=True)
    notifier = ForeignKeyField(column_name='notifier_id', field='id', model=Notifiers)
    receiver = ForeignKeyField(column_name='receiver_id', field='id', model=Users)
    responded_at = DateTimeField(null=True)
    sent_at = DateTimeField(null=True)
    updated_at = DateTimeField(null=True)
    viewed_at = DateTimeField(null=True)

    class Meta:
        table_name = 'notifier_results'


class NotifierResultEntities(BaseModel):
    created_at = DateTimeField(null=True)
    entity_id = BigIntegerField()
    entity_type = CharField()
    id = BigAutoField()
    notifier_result = ForeignKeyField(column_name='notifier_result_id', field='id', model=NotifierResults)
    updated_at = DateTimeField(null=True)

    class Meta:
        table_name = 'notifier_result_entities'


class Onboardings(BaseModel):
    application = CharField(null=True)
    clinic = ForeignKeyField(column_name='clinic_id', field='id', model=Clinics, null=True)
    created_at = DateTimeField(null=True)
    deleted_at = DateTimeField(null=True)
    description = TextField(null=True)
    end_at = DateTimeField(null=True)
    from_version = CharField(null=True)
    id = BigAutoField()
    is_active = IntegerField(constraints=[SQL("DEFAULT 1")])
    os = CharField(null=True)
    payload = TextField()
    start_at = DateTimeField(constraints=[SQL("DEFAULT current_timestamp()")])
    title = CharField()
    to_version = CharField(null=True)
    updated_at = DateTimeField(null=True)

    class Meta:
        table_name = 'onboardings'


class OnboardingExcludeClinics(BaseModel):
    clinic = ForeignKeyField(column_name='clinic_id', field='id', model=Clinics)
    created_at = DateTimeField(null=True)
    onboarding = ForeignKeyField(column_name='onboarding_id', field='id', model=Onboardings)
    updated_at = DateTimeField(null=True)

    class Meta:
        table_name = 'onboarding_exclude_clinics'
        primary_key = False


class OnboardingsViews(BaseModel):
    created_at = DateTimeField(null=True)
    id = BigAutoField()
    onboarding = ForeignKeyField(column_name='onboarding_id', field='id', model=Onboardings)
    updated_at = DateTimeField(null=True)
    user = ForeignKeyField(column_name='user_id', field='id', model=Users)
    viewed_at = DateTimeField(constraints=[SQL("DEFAULT current_timestamp()")])

    class Meta:
        table_name = 'onboardings_views'


class PasswordResetTokens(BaseModel):
    created_at = DateTimeField(constraints=[SQL("DEFAULT current_timestamp()")])
    login = CharField()
    token = CharField()

    class Meta:
        table_name = 'password_reset_tokens'
        primary_key = False


class PasswordResets(BaseModel):
    created_at = DateTimeField(null=True)
    email = CharField(index=True)
    token = CharField()

    class Meta:
        table_name = 'password_resets'
        primary_key = False


class PatientProblems(BaseModel):
    created_at = DateTimeField(null=True)
    days = IntegerField(null=True)
    id = BigAutoField()
    patient = ForeignKeyField(column_name='patient_id', field='id', model=Users)
    title = CharField()
    updated_at = DateTimeField(null=True)

    class Meta:
        table_name = 'patient_problems'


class PatientProblemChat(BaseModel):
    chat = ForeignKeyField(column_name='chat_id', field='id', model=Chats)
    created_at = DateTimeField(null=True)
    id = BigAutoField()
    patient_problem = ForeignKeyField(column_name='patient_problem_id', field='id', model=PatientProblems)
    service_id = BigIntegerField(null=True)
    updated_at = DateTimeField(null=True)

    class Meta:
        table_name = 'patient_problem_chat'


class PatientProblemDiscomfort(BaseModel):
    consultation_id = BigIntegerField()
    consultation_type = CharField()
    created_at = DateTimeField(null=True)
    description = TextField(null=True)
    id = BigAutoField()
    level = IntegerField()
    patient_problem = ForeignKeyField(column_name='patient_problem_id', field='id', model=PatientProblems)
    updated_at = DateTimeField(null=True)

    class Meta:
        table_name = 'patient_problem_discomfort'


class PatientProblemSlotPatient(BaseModel):
    created_at = DateTimeField(null=True)
    id = BigAutoField()
    patient_problem = ForeignKeyField(column_name='patient_problem_id', field='id', model=PatientProblems)
    service_id = BigIntegerField(null=True)
    slot_patient = ForeignKeyField(column_name='slot_patient_id', field='id', model=SlotsDoctorsPatients)
    updated_at = DateTimeField(null=True)

    class Meta:
        table_name = 'patient_problem_slot_patient'


class Products(BaseModel):
    created_at = DateTimeField(null=True)
    doctor = ForeignKeyField(column_name='doctor_id', field='id', model=Users)
    name = CharField()
    productable_id = IntegerField()
    productable_type = CharField()
    updated_at = DateTimeField(null=True)

    class Meta:
        table_name = 'products'


class PatientProducts(BaseModel):
    created_at = DateTimeField(null=True)
    expire_at = DateTimeField(constraints=[SQL("DEFAULT current_timestamp()")])
    patient = ForeignKeyField(column_name='patient_id', field='id', model=Users)
    product = ForeignKeyField(column_name='product_id', field='id', model=Products)
    start_at = DateTimeField(constraints=[SQL("DEFAULT current_timestamp()")])
    updated_at = DateTimeField(null=True)

    class Meta:
        table_name = 'patient_products'


class PaymentDrivers(BaseModel):
    clinic = ForeignKeyField(column_name='clinic_id', field='id', model=Clinics)
    config = TextField(null=True)
    created_at = DateTimeField(null=True)
    deleted_at = DateTimeField(null=True)
    id = BigAutoField()
    min_acquiring = DecimalField(constraints=[SQL("DEFAULT 0.00")])
    percent_acquiring = DecimalField(constraints=[SQL("DEFAULT 0.00")])
    type = CharField()
    updated_at = DateTimeField(null=True)

    class Meta:
        table_name = 'payment_drivers'


class Payments(BaseModel):
    amount = DecimalField(constraints=[SQL("DEFAULT 0.00")])
    card_exp_date = CharField(null=True)
    card_first_six = CharField(null=True)
    card_last_four = CharField(null=True)
    card_type = CharField(null=True)
    clinic = ForeignKeyField(column_name='clinic_id', field='id', model=Clinics, null=True)
    commission = DecimalField(constraints=[SQL("DEFAULT 0.00")])
    cost = DecimalField(constraints=[SQL("DEFAULT 0.00")])
    created_at = DateTimeField(null=True)
    currency = CharField(constraints=[SQL("DEFAULT 'RUB'")])
    date_time = DateTimeField(null=True)
    discount = DecimalField(constraints=[SQL("DEFAULT 0.00")])
    doctor = ForeignKeyField(column_name='doctor_id', field='id', model=Users, null=True)
    driver = ForeignKeyField(column_name='driver_id', field='id', model=PaymentDrivers, null=True)
    essence_id = BigIntegerField(null=True)
    essence_type = CharField(null=True)
    is_refund = IntegerField(null=True)
    parent_id = IntegerField(null=True)
    patient = ForeignKeyField(backref='users_patient_set', column_name='patient_id', field='id', model=Users, null=True)
    pay_type = CharField(null=True)
    promotion_code = ForeignKeyField(column_name='promotion_code_id', field='id', model=PromotionCodes, null=True)
    refund_reason = CharField(null=True)
    status = CharField(null=True)
    sum = DecimalField(constraints=[SQL("DEFAULT 0.00")])
    test_mode = IntegerField(constraints=[SQL("DEFAULT 0")])
    transaction_id = CharField(null=True)
    transfer_commission = FloatField(null=True)
    type = IntegerField(constraints=[SQL("DEFAULT 0")])
    type_form = CharField(constraints=[SQL("DEFAULT 'appointment'")])
    updated_at = DateTimeField(null=True)
    user = ForeignKeyField(backref='users_user_set', column_name='user_id', field='id', model=Users, null=True)

    class Meta:
        table_name = 'payments'
        indexes = (
            (('essence_type', 'essence_id'), False),
        )


class Permissions(BaseModel):
    entity = ForeignKeyField(column_name='entity_id', field='id', model=Entities)
    permission = BigIntegerField(constraints=[SQL("DEFAULT 0")])
    role = ForeignKeyField(column_name='role_id', field='id', model=Roles, null=True)
    user = ForeignKeyField(column_name='user_id', field='id', model=Users, null=True)

    class Meta:
        table_name = 'permissions'
        primary_key = False


class Prices(BaseModel):
    code = CharField()
    created_at = DateTimeField(null=True)
    duration = IntegerField()
    price = DecimalField()
    updated_at = DateTimeField(null=True)
    user = ForeignKeyField(column_name='user_id', field='id', model=Users)

    class Meta:
        table_name = 'prices'


class PromotionDoctors(BaseModel):
    created_at = DateTimeField(null=True)
    id = BigAutoField()
    promotion = ForeignKeyField(column_name='promotion_id', field='id', model=Promotions)
    updated_at = DateTimeField(null=True)
    user = ForeignKeyField(column_name='user_id', field='id', model=Users)

    class Meta:
        table_name = 'promotion_doctors'


class PromotionPatients(BaseModel):
    created_at = DateTimeField(null=True)
    id = BigAutoField()
    promotion = ForeignKeyField(column_name='promotion_id', field='id', model=Promotions)
    updated_at = DateTimeField(null=True)
    user = ForeignKeyField(column_name='user_id', field='id', model=Users)

    class Meta:
        table_name = 'promotion_patients'


class PromotionServices(BaseModel):
    created_at = DateTimeField(null=True)
    id = BigAutoField()
    promotion = ForeignKeyField(column_name='promotion_id', field='id', model=Promotions)
    service = ForeignKeyField(column_name='service_id', field='id', model=Services)
    updated_at = DateTimeField(null=True)

    class Meta:
        table_name = 'promotion_services'


class RecommendedConsultations(BaseModel):
    created_at = DateTimeField(null=True)
    date_time = DateTimeField()
    deleted_at = DateTimeField(null=True)
    doctor = ForeignKeyField(column_name='doctor_id', field='id', model=Users)
    id = BigAutoField()
    is_ignored = IntegerField(constraints=[SQL("DEFAULT 0")])
    is_reminded = IntegerField(null=True)
    patient = ForeignKeyField(backref='users_patient_set', column_name='patient_id', field='id', model=Users)
    previous_slot_patient = ForeignKeyField(column_name='previous_slot_patient_id', field='id',
                                            model=SlotsDoctorsPatients)
    slot_patient = ForeignKeyField(backref='slots_doctors_patients_slot_patient_set', column_name='slot_patient_id',
                                   field='id', model=SlotsDoctorsPatients, null=True)
    updated_at = DateTimeField(null=True)

    class Meta:
        table_name = 'recommended_consultations'


class Requisites(BaseModel):
    bik = CharField(column_name='BIK', null=True)
    inn = CharField(column_name='INN', null=True)
    kpp = CharField(column_name='KPP', null=True)
    ogrn = CharField(column_name='OGRN', null=True)
    actual_address = TextField(null=True)
    bank = TextField(null=True)
    checking_account = CharField(null=True)
    clinic = ForeignKeyField(column_name='clinic_id', field='id', model=Clinics)
    contract_date = DateField(null=True)
    contract_name = TextField(null=True)
    contract_number = CharField(null=True)
    correspondent_account = CharField(null=True)
    created_at = DateTimeField(null=True)
    legal_address = TextField(null=True)
    legal_entity = TextField(null=True)
    signatory_of_organization = CharField(null=True)
    updated_at = DateTimeField(null=True)

    class Meta:
        table_name = 'requisites'


class SendDeeplinks(BaseModel):
    created_at = DateTimeField(null=True)
    creator = CharField(null=True)
    doctor = ForeignKeyField(column_name='doctor_id', field='id', model=Users)
    link = CharField(null=True)
    patient = ForeignKeyField(backref='users_patient_set', column_name='patient_id', field='id', model=Users, null=True)
    send_at = DateTimeField(null=True)
    send_status = IntegerField(constraints=[SQL("DEFAULT 0")])
    source = CharField()
    target = CharField()
    to = CharField()
    type = CharField(constraints=[SQL("DEFAULT 'invite'")])
    updated_at = DateTimeField(null=True)

    class Meta:
        table_name = 'send_deeplinks'


class ServiceIntegration(BaseModel):
    external_id = CharField()
    id = BigAutoField()
    integration = ForeignKeyField(column_name='integration_id', field='id', model=MISIntegrations)
    last_sync_at = DateTimeField()
    service = ForeignKeyField(column_name='service_id', field='id', model=Services)

    class Meta:
        table_name = 'service_integration'


class ServiceLocators(BaseModel):
    code = CharField(unique=True)
    created_at = DateTimeField(null=True)
    data = TextField()
    updated_at = DateTimeField(null=True)

    class Meta:
        table_name = 'service_locators'


class Settings(BaseModel):
    created_at = DateTimeField(null=True)
    key = CharField()
    updated_at = DateTimeField(null=True)
    value = TextField(null=True)

    class Meta:
        table_name = 'settings'


class SkiniveInspections(BaseModel):
    created_at = DateTimeField(null=True)
    deleted_at = DateTimeField(null=True)
    id = BigAutoField()
    predict = TextField()
    updated_at = DateTimeField(null=True)
    user = ForeignKeyField(column_name='user_id', field='id', model=Users)

    class Meta:
        table_name = 'skinive_inspections'


class SlotPatientIntegration(BaseModel):
    batch_id = CharField()
    created_at = DateTimeField(null=True)
    external_id = CharField()
    id = BigAutoField()
    integration = ForeignKeyField(column_name='integration_id', field='id', model=MISIntegrations)
    updated_at = DateTimeField(null=True)

    class Meta:
        table_name = 'slot_patient_integration'


class SlotsDoctorsPatientsFile(BaseModel):
    file = ForeignKeyField(column_name='file_id', field='id', model=Files)
    slot_patient = ForeignKeyField(column_name='slot_patient_id', field='id', model=SlotsDoctorsPatients)

    class Meta:
        table_name = 'slots_doctors_patients_file'
        primary_key = False


class SlotsPatientsNotifications(BaseModel):
    before = IntegerField()
    end_sent = IntegerField()
    id = BigAutoField()
    slot_patient_id = BigIntegerField()
    start_sent = IntegerField()

    class Meta:
        table_name = 'slots_patients_notifications'


class SmsReports(BaseModel):
    clinic_id = IntegerField(null=True)
    cost = DecimalField(null=True)
    created_at = DateTimeField(null=True)
    external_id = CharField(null=True)
    id = BigAutoField()
    is_delivered = IntegerField(constraints=[SQL("DEFAULT 0")])
    phone = CharField()
    status = CharField(constraints=[SQL("DEFAULT 'on_queue'")])
    text = TextField()
    type = CharField()
    updated_at = DateTimeField(null=True)
    user_id = IntegerField(null=True)

    class Meta:
        table_name = 'sms_reports'


class SupportRequests(BaseModel):
    active = IntegerField(constraints=[SQL("DEFAULT 0")])
    answer = TextField()
    created_at = DateTimeField(null=True)
    position = IntegerField(constraints=[SQL("DEFAULT 0")])
    question = CharField()
    updated_at = DateTimeField(null=True)

    class Meta:
        table_name = 'support_requests'


class SurveyAnswers(BaseModel):
    answer = TextField()
    answered_at = DateTimeField()
    created_at = DateTimeField(null=True)
    id = BigAutoField()
    updated_at = DateTimeField(null=True)
    user = ForeignKeyField(column_name='user_id', field='id', model=Users)

    class Meta:
        table_name = 'survey_answers'


class TokboxArchives(BaseModel):
    archive_created_at = DateTimeField(null=True)
    archive_id = CharField()
    archive_updated_at = DateTimeField(null=True)
    created_at = DateTimeField(null=True)
    duration = IntegerField(null=True)
    id = BigAutoField()
    is_audio = IntegerField(null=True)
    is_video = IntegerField(null=True)
    media_file_id = IntegerField(null=True)
    reason = CharField(null=True)
    session_id = BigIntegerField()
    size = IntegerField(null=True)
    status = CharField()
    updated_at = DateTimeField(null=True)
    url = TextField(null=True)

    class Meta:
        table_name = 'tokbox_archives'


class TokboxSession(BaseModel):
    archive_created_at = DateTimeField(null=True)
    archive_id = CharField(null=True)
    archive_updated_at = DateTimeField(null=True)
    attempt = IntegerField(null=True)
    call_id = CharField(index=True)
    created_at = DateTimeField(null=True)
    duration = IntegerField(null=True)
    id = BigAutoField()
    is_audio = CharField(null=True)
    is_compiled = IntegerField(constraints=[SQL("DEFAULT 0")])
    is_compiled_error = IntegerField(constraints=[SQL("DEFAULT 0")])
    is_old_compiled = IntegerField(constraints=[SQL("DEFAULT 0")], null=True)
    is_processing = IntegerField(constraints=[SQL("DEFAULT 0")])
    is_video = IntegerField(null=True)
    last_error = CharField(null=True)
    lock_at = DateTimeField(index=True, null=True)
    reason = CharField(null=True)
    run_at = DateTimeField(index=True, null=True)
    session_id = CharField()
    size = IntegerField(null=True)
    status = CharField(index=True, null=True)
    updated_at = DateTimeField(null=True)

    class Meta:
        table_name = 'tokbox_session'


class TotemFrequencyParameters(BaseModel):
    created_at = DateTimeField(null=True)
    frequency_id = IntegerField()
    name = CharField()
    updated_at = DateTimeField(null=True)
    value = CharField()

    class Meta:
        table_name = 'totem_frequency_parameters'


class TotemTasks(BaseModel):
    auto_cleanup_num = IntegerField(constraints=[SQL("DEFAULT 0")], index=True)
    auto_cleanup_type = CharField(index=True, null=True)
    command = CharField()
    created_at = DateTimeField(null=True)
    description = CharField()
    dont_overlap = IntegerField(constraints=[SQL("DEFAULT 0")], index=True)
    expression = CharField(null=True)
    is_active = IntegerField(constraints=[SQL("DEFAULT 1")], index=True)
    notification_email_address = CharField(null=True)
    notification_phone_number = CharField(null=True)
    notification_slack_webhook = CharField(null=True)
    parameters = CharField(null=True)
    run_in_background = IntegerField(constraints=[SQL("DEFAULT 0")])
    run_in_maintenance = IntegerField(constraints=[SQL("DEFAULT 0")], index=True)
    run_on_one_server = IntegerField(constraints=[SQL("DEFAULT 0")], index=True)
    timezone = CharField(constraints=[SQL("DEFAULT 'UTC'")])
    updated_at = DateTimeField(null=True)

    class Meta:
        table_name = 'totem_tasks'


class TotemTaskFrequencies(BaseModel):
    created_at = DateTimeField(null=True)
    interval = CharField()
    label = CharField()
    task = ForeignKeyField(column_name='task_id', field='id', model=TotemTasks)
    updated_at = DateTimeField(null=True)

    class Meta:
        table_name = 'totem_task_frequencies'


class TotemTaskResults(BaseModel):
    created_at = DateTimeField(null=True)
    duration = DecimalField()
    ran_at = DateTimeField(constraints=[SQL("DEFAULT current_timestamp()")], index=True)
    result = TextField()
    task = ForeignKeyField(column_name='task_id', field='id', model=TotemTasks)
    updated_at = DateTimeField(null=True)

    class Meta:
        table_name = 'totem_task_results'


class Tracks(BaseModel):
    created_at = DateTimeField(null=True)
    entity_id = BigIntegerField()
    entity_type = CharField()
    flow = CharField(null=True)
    id = BigAutoField()
    status = CharField()
    updated_at = DateTimeField(null=True)

    class Meta:
        table_name = 'tracks'


class TrackHistories(BaseModel):
    created_at = DateTimeField(null=True)
    from_ = CharField(column_name='from')
    id = BigAutoField()
    meta = TextField(null=True)
    reason = TextField(null=True)
    to = CharField()
    track = ForeignKeyField(column_name='track_id', field='id', model=Tracks)
    transition = CharField(null=True)
    updated_at = DateTimeField(null=True)

    class Meta:
        table_name = 'track_histories'


class UserActiveDays(BaseModel):
    date = DateField()
    user = ForeignKeyField(column_name='user_id', field='id', model=Users)

    class Meta:
        table_name = 'user_active_days'
        indexes = (
            (('user', 'date'), True),
        )
        primary_key = CompositeKey('date', 'user')


class UserGroups(BaseModel):
    clinic = ForeignKeyField(column_name='clinic_id', field='id', model=Clinics)
    count = IntegerField()
    created_at = DateTimeField(null=True)
    deleted_at = DateTimeField(null=True)
    icon = CharField()
    id = BigAutoField()
    is_system = IntegerField(constraints=[SQL("DEFAULT 0")])
    title = CharField()
    type = CharField()
    updated_at = DateTimeField(null=True)

    class Meta:
        table_name = 'user_groups'


class UserGroupUser(BaseModel):
    group = ForeignKeyField(column_name='group_id', field='id', model=UserGroups)
    user = ForeignKeyField(column_name='user_id', field='id', model=Users)

    class Meta:
        table_name = 'user_group_user'
        primary_key = False


class UserIntegration(BaseModel):
    external_id = CharField()
    id = BigAutoField()
    integration = ForeignKeyField(column_name='integration_id', field='id', model=MISIntegrations)
    last_sync_at = DateTimeField(null=True)
    user = ForeignKeyField(column_name='user_id', field='id', model=Users)

    class Meta:
        table_name = 'user_integration'


class UserVoximplantEvents(BaseModel):
    call_id = CharField()
    created_at = DateTimeField(null=True)
    event = CharField()
    id = BigAutoField()
    metadata = TextField(null=True)
    microtime = BigIntegerField()
    updated_at = DateTimeField(null=True)
    user_id = BigIntegerField(null=True)

    class Meta:
        table_name = 'user_voximplant_events'


class UsersMessages(BaseModel):
    message = ForeignKeyField(column_name='message_id', field='id', model=Messages)
    user = ForeignKeyField(column_name='user_id', field='id', model=Users)

    class Meta:
        table_name = 'users_messages'
        indexes = (
            (('user', 'message'), True),
        )
        primary_key = CompositeKey('message', 'user')


class VerificationSms(BaseModel):
    code = CharField()
    created_at = DateTimeField(null=True)
    id = CharField(primary_key=True)
    phone = CharField()
    updated_at = DateTimeField(null=True)

    class Meta:
        table_name = 'verification_sms'


class VerificationSmsActions(BaseModel):
    action = CharField()
    active = IntegerField(constraints=[SQL("DEFAULT 1")])
    created_at = DateTimeField(null=True)
    id = CharField(primary_key=True)
    sms = ForeignKeyField(column_name='sms_id', field='id', model=VerificationSms)
    updated_at = DateTimeField(null=True)

    class Meta:
        table_name = 'verification_sms_actions'


class VersionApplications(BaseModel):
    application = CharField()
    client_id = CharField(null=True)
    created_at = DateTimeField(null=True)
    critical = IntegerField(constraints=[SQL("DEFAULT 0")])
    os = CharField()
    updated_at = DateTimeField(null=True)
    version = CharField()
    version_code = IntegerField(null=True)

    class Meta:
        table_name = 'version_applications'


class VideoEvents(BaseModel):
    created_at = DateTimeField()
    event = CharField()
    extra_data = TextField()
    track_id = CharField(index=True)

    class Meta:
        table_name = 'video_events'
        primary_key = False


class VoximplantSessions(BaseModel):
    account_id = BigIntegerField(null=True)
    application_id = BigIntegerField(null=True)
    attempt = IntegerField(null=True)
    call_start_at = DateTimeField(null=True)
    call_update_at = DateTimeField(null=True)
    conference_cost = BigIntegerField(null=True)
    conference_duration = BigIntegerField(null=True)
    conference_name = CharField(index=True, null=True)
    created_at = DateTimeField(null=True)
    duration = BigIntegerField(null=True)
    id = BigAutoField()
    is_download = IntegerField(constraints=[SQL("DEFAULT 0")])
    is_downloading = IntegerField(constraints=[SQL("DEFAULT 0")])
    is_processed = IntegerField(constraints=[SQL("DEFAULT 0")], index=True)
    last_error = CharField(null=True)
    lock_at = DateTimeField(index=True, null=True)
    log_url = TextField(null=True)
    record_cost = BigIntegerField(null=True)
    record_duration = BigIntegerField(null=True)
    record_url = TextField(null=True)
    run_at = DateTimeField(index=True, null=True)
    session_id = CharField(null=True, unique=True)
    size = BigIntegerField(null=True)
    updated_at = DateTimeField(null=True)

    class Meta:
        table_name = 'voximplant_sessions'


class VoximplantEvents(BaseModel):
    created_at = DateTimeField(null=True)
    id = BigAutoField()
    microtime = BigIntegerField(index=True, null=True)
    session = ForeignKeyField(column_name='session_id', field='id', model=VoximplantSessions)
    status = CharField(index=True, null=True)
    updated_at = DateTimeField(null=True)

    class Meta:
        table_name = 'voximplant_events'


class VoximplantUser(BaseModel):
    created_at = DateTimeField(null=True)
    credentials_hash = CharField()
    id = BigAutoField()
    updated_at = DateTimeField(null=True)
    user = ForeignKeyField(column_name='user_id', field='id', model=Users, unique=True)
    username = CharField(unique=True)

    class Meta:
        table_name = 'voximplant_user'


class WebHookEvents(BaseModel):
    client_id = BigIntegerField()
    client_type = CharField()
    created_at = DateTimeField(null=True)
    event_name = CharField(index=True)
    id = BigAutoField()
    updated_at = DateTimeField(null=True)
    webhook_url = CharField()

    class Meta:
        table_name = 'web_hook_events'


class WebHookTasks(BaseModel):
    client_id = BigIntegerField()
    client_type = CharField()
    created_at = DateTimeField(null=True)
    event_data = TextField()
    event_name = CharField()
    id = BigAutoField()
    is_success = IntegerField(null=True)
    response_code = IntegerField(null=True)
    response_data = CharField(null=True)
    sent_at = DateTimeField(null=True)
    updated_at = DateTimeField(null=True)
    webhook_url = CharField()

    class Meta:
        table_name = 'web_hook_tasks'


class Widgets(BaseModel):
    active = IntegerField(constraints=[SQL("DEFAULT 1")])
    clinic = ForeignKeyField(column_name='clinic_id', field='id', model=Clinics)
    created_at = DateTimeField(null=True)
    deleted_at = DateTimeField(null=True)
    doctor = ForeignKeyField(column_name='doctor_id', field='id', model=Users)
    id = BigAutoField()
    name = CharField()
    params = TextField()
    updated_at = DateTimeField(null=True)
    version = CharField(constraints=[SQL("DEFAULT '1.0'")])

    class Meta:
        table_name = 'widgets'


class WorkingSchedules(BaseModel):
    created_at = DateTimeField(null=True)
    date = DateField()
    time_from = TimeField()
    time_to = TimeField()
    type_schedule = IntegerField()
    updated_at = DateTimeField(null=True)
    user = ForeignKeyField(column_name='user_id', field='id', model=Users)

    class Meta:
        table_name = 'working_schedules'
        indexes = (
            (('date', 'time_from'), False),
        )
