/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util;

import com.sas.codepolicy.SASScope;
import com.sas.uiconfig.UIConfigurationInterface;
import com.sas.util.AttributeDescriptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

@SASScope
public class AttributeGroup {
    private String label;
    private UIConfigurationInterface uiConfig;
    private boolean visible;
    private List<Object> attributes;

    public AttributeGroup() {
        this(null);
    }

    public AttributeGroup(String label) {
        this.label = label;
        this.visible = true;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public UIConfigurationInterface getUIConfig() {
        return this.uiConfig;
    }

    public void setUIConfig(UIConfigurationInterface uiConfig) {
        this.uiConfig = uiConfig;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public final List<Object> getAttributes() {
        if (null == this.attributes) {
            this.attributes = new ArrayList<Object>();
        }
        return this.attributes;
    }

    public final void setAttributes(List<Object> attributes) {
        this.attributes = attributes;
    }

    public boolean equals(Object obj) {
        return obj instanceof AttributeGroup && ((AttributeGroup)obj).getLabel().equals(this.getLabel());
    }

    public String toString() {
        return this.getLabel();
    }

    public final List<AttributeDescriptor> getAttributeDescriptors() {
        ArrayList<Object> list = new ArrayList<Object>();
        list.addAll(this.getAttributes());
        if (!list.isEmpty()) {
            ArrayList<AttributeDescriptor> attrs = new ArrayList<AttributeDescriptor>();
            this.recurse(list, attrs);
            return attrs;
        }
        return Collections.emptyList();
    }

    private void recurse(List<Object> list, List<AttributeDescriptor> attrs) {
        for (Object object : list) {
            if (object instanceof AttributeGroup) {
                this.recurse(((AttributeGroup)object).getAttributes(), attrs);
                continue;
            }
            if (!(object instanceof AttributeDescriptor)) continue;
            attrs.add((AttributeDescriptor)object);
        }
    }

    public final AttributeGroup subset(List<String> list) {
        if (null == list) {
            throw new IllegalArgumentException("The list parameter may not be null.");
        }
        if (!list.isEmpty() && !this.getAttributes().isEmpty()) {
            AttributeGroup ag = this.copy();
            List<Object> copiedList = ag.getAttributes();
            this.deleteAttribute(list, copiedList);
            this.deleteAttribute(list, copiedList);
            return ag;
        }
        return this;
    }

    private void deleteAttribute(List<String> list, List<Object> copiedList) {
        Iterator<Object> iterator = copiedList.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (object instanceof AttributeGroup) {
                if (((AttributeGroup)object).getAttributes().isEmpty()) {
                    iterator.remove();
                    continue;
                }
                this.deleteAttribute(list, ((AttributeGroup)object).getAttributes());
                continue;
            }
            if (!(object instanceof AttributeDescriptor) || list.contains(((AttributeDescriptor)object).getName())) continue;
            iterator.remove();
        }
    }

    protected final synchronized AttributeGroup copy() {
        AttributeGroup retVal = new AttributeGroup();
        retVal.setLabel(this.getLabel());
        retVal.setUIConfig(this.getUIConfig());
        retVal.setVisible(this.isVisible());
        ArrayList<Object> copiedList = new ArrayList<Object>();
        retVal.setAttributes(copiedList);
        for (Object object : this.attributes) {
            if (object instanceof AttributeGroup) {
                AttributeGroup subGroup = ((AttributeGroup)object).copy();
                copiedList.add(subGroup);
                continue;
            }
            if (!(object instanceof AttributeDescriptor)) continue;
            copiedList.add(object);
        }
        return retVal;
    }
}

