/*
 * Decompiled with CFR 0.152.
 */
package com.sas.text;

import com.sas.codepolicy.SASScope;
import com.sas.text.D;
import com.sas.text.SASFormatEntry;
import com.sas.text.SingleEntry;
import java.text.DecimalFormatSymbols;
import java.util.Hashtable;
import java.util.Locale;

@SASScope
public class NLD
extends D {
    private static Hashtable m_localeFormatCache;
    private StringBuffer m_sb;
    private DecimalFormatSymbols m_dfs;
    private DecimalFormatSymbols m_dfsOfUS;

    public static final Object[] getDefinedFormats(Locale locale) {
        Object[] nldfmts = new Object[1];
        if (m_localeFormatCache == null) {
            m_localeFormatCache = new Hashtable();
        } else if (m_localeFormatCache.get(locale) != null) {
            nldfmts[0] = m_localeFormatCache.get(locale);
            return nldfmts;
        }
        SingleEntry entry = new SingleEntry("NLDw.d", NLD.class.getName());
        ((SASFormatEntry)entry).addPattern(12, 32, null, true);
        ((SASFormatEntry)entry).addPattern(1, 11, null);
        entry.setFormatLocale(locale);
        nldfmts[0] = entry;
        m_localeFormatCache.put(locale, entry);
        return nldfmts;
    }

    @Override
    public StringBuffer format(double value) {
        if (this.m_sb != null) {
            this.m_sb.setLength(0);
        } else {
            this.m_sb = new StringBuffer(32);
        }
        this.m_sb.append(super.format(value));
        for (int i = 0; i < this.m_sb.length(); ++i) {
            if (this.m_sb.charAt(i) == this.getDfsOfUS().getGroupingSeparator()) {
                this.m_sb.setCharAt(i, this.getDfs().getGroupingSeparator());
                continue;
            }
            if (this.m_sb.charAt(i) != this.getDfsOfUS().getDecimalSeparator()) continue;
            this.m_sb.setCharAt(i, this.getDfs().getDecimalSeparator());
        }
        return this.m_sb;
    }

    private DecimalFormatSymbols getDfs() {
        if (this.m_dfs == null) {
            this.m_dfs = new DecimalFormatSymbols(this.info.getFormatLocale());
        }
        return this.m_dfs;
    }

    private DecimalFormatSymbols getDfsOfUS() {
        if (this.m_dfsOfUS == null) {
            this.m_dfsOfUS = new DecimalFormatSymbols(Locale.US);
        }
        return this.m_dfsOfUS;
    }
}

