/*
 * Decompiled with CFR 0.152.
 */
package com.sas.text;

import com.sas.codepolicy.SASScope;
import com.sas.text.InvalidFormatException;
import com.sas.text.SingleEntry;
import com.sas.text.TableEntry;

@SASScope
class MultiEntry
extends SingleEntry {
    char delim;
    char separator;
    String[] fNames;
    private StringBuffer newPattern = new StringBuffer(30);

    public MultiEntry(String format, String className, char defaultXValue) {
        super(format, className);
        this.separator = this.delim = defaultXValue;
        this.fNames = new String[]{this.baseFormat, this.baseFormat + "B", this.baseFormat + "C", this.baseFormat + "D", this.baseFormat + "P", this.baseFormat + "S"};
    }

    @Override
    public String getPattern(String format, int width) throws InvalidFormatException {
        return this.replace(format, super.getPattern(format, width));
    }

    @Override
    public String getPattern(String format) throws InvalidFormatException {
        return this.replace(format, super.getPattern(format));
    }

    public char getSeparator() {
        return this.separator;
    }

    private String replace(String format, String pattern) {
        if (pattern == null) {
            return null;
        }
        this.newPattern.setLength(0);
        char[] oldPattern = pattern.toCharArray();
        int i = 0;
        if (this.baseFormat.length() != format.length()) {
            char ch = this.delim;
            char xvalue = format.charAt(this.baseFormat.length());
            switch (xvalue) {
                case 'B': 
                case 'b': {
                    ch = ' ';
                    break;
                }
                case 'C': 
                case 'c': {
                    ch = ':';
                    break;
                }
                case 'D': 
                case 'd': {
                    ch = '-';
                    break;
                }
                case 'P': 
                case 'p': {
                    ch = '.';
                    break;
                }
                case 'S': 
                case 's': {
                    ch = '/';
                    break;
                }
            }
            this.separator = ch;
            if (this.delim >= 'a' && this.delim <= 'z' || this.delim >= 'A' && this.delim <= 'Z') {
                while (i < oldPattern.length) {
                    if (oldPattern[i] == '\'') {
                        if (i + 2 < oldPattern.length && oldPattern[i + 1] == this.delim && oldPattern[i + 2] == '\'') {
                            this.newPattern.append(ch);
                            i += 2;
                        } else {
                            this.newPattern.append(oldPattern[i]);
                        }
                    } else {
                        this.newPattern.append(oldPattern[i]);
                    }
                    ++i;
                }
            } else {
                while (i < oldPattern.length) {
                    if (oldPattern[i] == this.delim) {
                        this.newPattern.append(ch);
                    } else {
                        this.newPattern.append(oldPattern[i]);
                    }
                    ++i;
                }
            }
        } else {
            this.separator = this.delim;
            this.newPattern.append(pattern);
        }
        return this.newPattern.toString();
    }

    @Override
    public String getBaseFormatName() {
        return this.baseFormat;
    }

    @Override
    com.sas.text.FormatDescription[] getFormatDescription() {
        com.sas.text.FormatDescription[] fd = new com.sas.text.FormatDescription[this.fNames.length];
        for (int i = 0; i < this.fNames.length; ++i) {
            fd[i] = new FormatDescription(this.fNames[i], this);
        }
        return fd;
    }

    @SASScope
    class FormatDescription
    extends TableEntry {
        String name;
        MultiEntry entry;

        public FormatDescription(String formatName, MultiEntry entry) {
            this.name = formatName;
            this.entry = entry;
        }

        @Override
        public String getClassName() {
            return this.entry.getClassName();
        }

        @Override
        public String getBaseFormatName() {
            return this.name;
        }

        @Override
        public int getDefaultWidth() {
            return this.entry.getDefaultWidth();
        }

        @Override
        public int getMaxWidth() {
            return this.entry.getMaxWidth();
        }

        @Override
        public int getMinWidth() {
            return this.entry.getMinWidth();
        }

        @Override
        public boolean isDecimalWidthSupported() {
            return this.entry.isDecimalWidthSupported();
        }

        @Override
        public int getMaxDValue() {
            return this.entry.getMaxDValue();
        }

        @Override
        public int getMinDValue() {
            return this.entry.getMinDValue();
        }
    }
}

