/*
 * Decompiled with CFR 0.152.
 */
package com.sas.text;

import com.sas.codepolicy.SASScope;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

@SASScope
class CalendarType {
    private static final String Gregorian_Localized = "01";
    private static final String Gregorian_United_States = "02";
    private static final String Gregorian_Arabic = "0A";
    private static final Map calendars = new HashMap();

    CalendarType() {
    }

    static String getCalendar(Locale locale) {
        String shape;
        String lang = locale.getLanguage();
        String country = locale.getCountry();
        if (country != null && country.length() > 0) {
            StringBuffer buff = new StringBuffer(lang);
            buff.append("_").append(country);
            shape = (String)calendars.get(buff.toString());
            if (shape != null) {
                return shape;
            }
        }
        if ((shape = (String)calendars.get(lang)) != null) {
            return shape;
        }
        return Gregorian_Localized;
    }

    static {
        calendars.put("en_US", Gregorian_United_States);
        calendars.put("ar", Gregorian_Arabic);
    }
}

