/*
 * Decompiled with CFR 0.152.
 */
package com.sas.models;

import com.sas.codepolicy.SASScope;
import com.sas.models.FileLocationInterface;
import com.sas.util.Strings;
import java.io.Serializable;

@SASScope
public class FileLocation
implements FileLocationInterface,
Serializable {
    static final long serialVersionUID = 782950705915115216L;
    private static final String SEPARATOR = " @@ ";
    private String serverName;
    private String fileLocation;
    private boolean isDirectory;

    public FileLocation(String serverName, String fileLocation) {
        this(serverName, fileLocation, false);
    }

    public FileLocation(String serverName, String fileLocation, boolean isDirectory) {
        this.init(serverName, fileLocation, isDirectory);
    }

    public FileLocation(String text) {
        this.parseString(text);
    }

    public FileLocation() {
    }

    private void init(String serverName, String fileLocation, boolean isDirectory) {
        this.serverName = serverName;
        this.fileLocation = fileLocation;
        this.isDirectory = isDirectory;
    }

    @Override
    public String getServerName() {
        return this.serverName;
    }

    @Override
    public String getFileLocation() {
        return this.fileLocation;
    }

    @Override
    public boolean isFile() {
        return !this.isDirectory;
    }

    @Override
    public boolean isDirectory() {
        return this.isDirectory;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public void setFileLocation(String fileLocation) {
        this.fileLocation = fileLocation;
    }

    public void setDirectory(boolean isDirectory) {
        this.isDirectory = isDirectory;
    }

    public String toString() {
        StringBuffer text = new StringBuffer();
        text.append(this.getServerName());
        text.append(SEPARATOR);
        text.append(this.getFileLocation());
        text.append(SEPARATOR);
        text.append(this.isDirectory());
        return text.toString();
    }

    @Override
    public void parseString(String text) {
        String[] parts = text.split(SEPARATOR);
        if (parts.length == 3) {
            this.init(parts[0], parts[1], Boolean.valueOf(parts[2]));
            return;
        }
        if (parts.length == 1) {
            this.init(null, parts[0], false);
            return;
        }
        throw new IllegalStateException("Invalid file location : " + text);
    }

    public boolean equals(Object otherItem) {
        if (otherItem instanceof FileLocationInterface) {
            FileLocationInterface other = (FileLocationInterface)otherItem;
            if (this.isDirectory() != other.isDirectory()) {
                return false;
            }
            if (!Strings.equal(this.getFileLocation(), other.getFileLocation(), true, false)) {
                return false;
            }
            return Strings.equal(this.getServerName(), other.getServerName(), true, false);
        }
        return false;
    }
}

