/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rio;

import com.sas.codepolicy.SASScope;
import java.util.Hashtable;

@SASScope
public class Sqpformat {
    private static final Hashtable<String, Integer> formats = new Hashtable();
    private static final String[] prefixes;
    private static final Hashtable<String, Integer> suffixes;
    int name_len;
    String name;
    int wid;
    int ndec;

    public Sqpformat(String formatName, int formatLength, int formatWidth, int formatDecimal) {
        this.name = formatName;
        this.name_len = formatLength;
        this.wid = formatWidth;
        this.ndec = formatDecimal;
    }

    @Deprecated
    public Sqpformat(boolean v6) {
    }

    public Sqpformat() {
    }

    public int findFormat(String inname) {
        String tstring = inname.trim();
        if (tstring.length() == 0) {
            if (this.ndec == 0 && this.wid != 0) {
                return 4;
            }
            return 0;
        }
        Integer temp = formats.get(tstring);
        int subtype = temp != null ? temp : 0;
        if (subtype == 5) {
            if (inname.indexOf("HEX") != -1) {
                if (this.wid != 16) {
                    return 4;
                }
                return 0;
            }
            if (this.ndec == 0) {
                return 4;
            }
        }
        if (subtype != 0) {
            return subtype;
        }
        subtype = Sqpformat.getIntl(inname);
        if (subtype == 0) {
            subtype = Sqpformat.checkForSep(inname);
        }
        return subtype;
    }

    public static int intepretFormat(String inname) {
        int length = (inname = inname.trim()).length();
        if (length == 0) {
            return 0;
        }
        char[] tchar = inname.toCharArray();
        if (Character.isDigit(tchar[0])) {
            if (tchar[length - 1] == '.') {
                return 4;
            }
            return 0;
        }
        if (inname.indexOf("HEX") != -1) {
            if (inname.indexOf("16") == -1) {
                return 4;
            }
            return 0;
        }
        for (int i = length - 1; i >= 0 && (tchar[i] == '.' || Character.isDigit(tchar[i])); --i) {
            tchar[i] = 32;
        }
        String tstring = new String(tchar);
        Integer temp = formats.get(tstring = tstring.trim());
        if (temp != null) {
            int subtype = temp;
            if (subtype == 5 && inname.charAt(length - 1) == '.') {
                subtype = 4;
            }
            return subtype;
        }
        int st = Sqpformat.getIntl(tstring);
        if (st == 0) {
            st = Sqpformat.checkForSep(tstring);
        }
        return st;
    }

    public static int getIntl(String format) {
        if (format.length() < 7) {
            return 0;
        }
        String temp = format.substring(0, 3);
        for (int i = 0; i < prefixes.length; ++i) {
            if (!prefixes[i].equals(temp)) continue;
            String suffix = format.substring(3, format.length());
            Integer subtype = suffixes.get(suffix);
            if (subtype != null) {
                return subtype;
            }
            return 0;
        }
        return 0;
    }

    private static int checkForSep(String inname) {
        String temp = inname.substring(0, inname.length() - 1);
        char c = inname.charAt(inname.length() - 1);
        Integer st = formats.get(temp);
        int likely = 0;
        if (st != null) {
            likely = st;
        }
        if (likely != 0) {
            switch (c) {
                case 'B': {
                    if (temp.equals("MMDDYY") || temp.equals("DDMMYY") || temp.equals("YYMMDD")) {
                        return likely;
                    }
                    return 0;
                }
                case 'C': 
                case 'D': 
                case 'N': 
                case 'P': 
                case 'S': {
                    if (temp.equals("MMDDYY") || temp.equals("DDMMYY") || temp.equals("YYMMDD") || temp.equals("MMYY") || temp.equals("YYQ") || temp.equals("YYMM") || temp.equals("YYQR")) {
                        return likely;
                    }
                    return 0;
                }
            }
            return 0;
        }
        return likely;
    }

    static {
        formats.put("DATE", 1);
        formats.put("DATETIME", 3);
        formats.put("DAY", 1);
        formats.put("DDMMYY", 1);
        formats.put("DOWNAME", 1);
        formats.put("HHMM", 2);
        formats.put("HOUR", 2);
        formats.put("JULDAY", 1);
        formats.put("JULIAN", 1);
        formats.put("MINGUO", 1);
        formats.put("MMDDYY", 1);
        formats.put("MMSS", 2);
        formats.put("MMYY", 1);
        formats.put("MONNAME", 1);
        formats.put("MONTH", 1);
        formats.put("MONYY", 1);
        formats.put("NENGO", 1);
        formats.put("QTR", 1);
        formats.put("QTRR", 1);
        formats.put("TIME", 2);
        formats.put("TOD", 3);
        formats.put("WEEKDATE", 1);
        formats.put("WEEKDATX", 1);
        formats.put("WEEKDAY", 1);
        formats.put("WORDDATE", 1);
        formats.put("WORDDATX", 1);
        formats.put("YEAR", 1);
        formats.put("YYMM", 1);
        formats.put("YYMMDD", 1);
        formats.put("YYMON", 1);
        formats.put("YYQ", 1);
        formats.put("YYQR", 1);
        formats.put("WEEKU", 1);
        formats.put("WEEKV", 1);
        formats.put("WEEKW", 1);
        formats.put("BINARY", 4);
        formats.put("COMMA", 5);
        formats.put("COMMAX", 5);
        formats.put("DOLLAR", 5);
        formats.put("DOLLARX", 5);
        formats.put("HEX", 5);
        formats.put("IB", 5);
        formats.put("OCTAL", 4);
        formats.put("PIB", 5);
        formats.put("ROMAN", 4);
        formats.put("SSN", 4);
        formats.put("Z", 5);
        formats.put("F", 5);
        formats.put("DTYEAR", 3);
        formats.put("DTWKDATX", 3);
        formats.put("DTYYQC", 3);
        formats.put("DATEAMPM", 3);
        formats.put("TIMEAMPM", 2);
        formats.put("DTDATE", 3);
        formats.put("DTMONYY", 3);
        formats.put("JDATEMD", 1);
        formats.put("JDATEMDW", 1);
        formats.put("JDATEMNW", 1);
        formats.put("JDATEMON", 1);
        formats.put("JDATEQRW", 1);
        formats.put("JDATEQTR", 1);
        formats.put("JDATESEM", 1);
        formats.put("JDATESMW", 1);
        formats.put("JDATEWK", 1);
        formats.put("JDATEYDW", 1);
        formats.put("JDATEYM", 1);
        formats.put("JDATEYMD", 1);
        formats.put("JDATEYMW", 1);
        formats.put("JDATEYT", 3);
        formats.put("JDATEYTW", 3);
        formats.put("JNENGO", 1);
        formats.put("JNENGOT", 3);
        formats.put("JNENGOTW", 3);
        formats.put("JNENGOW", 1);
        formats.put("IS8601DA", 1);
        formats.put("IS8601DN", 3);
        formats.put("IS8601DT", 3);
        formats.put("IS8601DZ", 3);
        formats.put("JULDATE", 1);
        formats.put("MDYAMPM", 3);
        formats.put("NLDATE", 1);
        formats.put("NLDATEMN", 1);
        formats.put("NLDATEW", 1);
        formats.put("NLDATEWN", 1);
        formats.put("NLDATM", 3);
        formats.put("NLDATMAP", 3);
        formats.put("NLDATMTM", 3);
        formats.put("NLDATMW", 3);
        formats.put("TWMDY", 3);
        formats.put("XYYMMDD", 1);
        formats.put("IS8601LZ", 2);
        formats.put("IS8601TM", 2);
        formats.put("IS8601TZ", 2);
        formats.put("JTIMEH", 2);
        formats.put("JTIMEHM", 2);
        formats.put("JTIMEHMS", 2);
        formats.put("JTIMEHW", 2);
        formats.put("JTIMEMW", 2);
        formats.put("JTIMESW", 2);
        formats.put("NLTIME", 2);
        formats.put("NLTIMAP", 2);
        prefixes = new String[13];
        Sqpformat.prefixes[0] = "DAN";
        Sqpformat.prefixes[1] = "DES";
        Sqpformat.prefixes[2] = "DEU";
        Sqpformat.prefixes[3] = "ESP";
        Sqpformat.prefixes[4] = "EUR";
        Sqpformat.prefixes[5] = "FIN";
        Sqpformat.prefixes[6] = "FRA";
        Sqpformat.prefixes[7] = "FRS";
        Sqpformat.prefixes[8] = "ITA";
        Sqpformat.prefixes[9] = "NLD";
        Sqpformat.prefixes[10] = "NOR";
        Sqpformat.prefixes[11] = "PTG";
        Sqpformat.prefixes[12] = "SVE";
        suffixes = new Hashtable();
        suffixes.put("DFDD", 1);
        suffixes.put("DFDE", 1);
        suffixes.put("DFDN", 1);
        suffixes.put("DFDT", 3);
        suffixes.put("DFDWN", 1);
        suffixes.put("DFMN", 1);
        suffixes.put("DFMY", 1);
        suffixes.put("DFWDX", 1);
        suffixes.put("DFWKX", 1);
    }
}

