/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rio;

import com.sas.codepolicy.SASScope;
import com.sas.rio.Cache;
import com.sas.rio.Column;
import com.sas.rio.DataHolder;
import com.sas.rio.IRowCache;
import com.sas.rio.MVAConnectionProperties;
import com.sas.rio.MVARow;
import com.sas.rio.MVASQLException;
import com.sas.rio.MVAStatement;
import com.sas.rio.MessageCode;
import com.sas.rio.RIOUtil;
import java.sql.SQLException;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@SASScope
class MVARowCache
implements IRowCache {
    protected final int m_bindKey;
    protected final int m_hashCode;
    private final boolean _isDirect;
    protected final RIOUtil _rioUtil;
    private final MVAConnectionProperties _mvaConnProps;
    private boolean m_countValid = true;
    private static final int EOF = -1;
    private static final int BOF = -2;
    private int m_status = -2;
    protected final Column[] _columns;
    protected Cache<MVARow> m_rows;
    int _cacheIndex;
    protected int _rowNumber;
    protected int m_maxRows = 0;
    private boolean m_alreadyCounted = false;
    int m_cacheSize = 100;
    protected Position _position = Position.BEFORE_FIRST;
    protected UpdateType _updateType = UpdateType.NONE;
    protected MVARow _updateRow = null;
    private int m_rowCount = 0;
    protected boolean m_peekFlag = false;
    protected boolean m_cacheChangeFlag = false;
    protected int m_newCache = 0;

    MVARowCache(int hashCode, RIOUtil rioUtil) throws SQLException {
        this._rioUtil = rioUtil;
        this._isDirect = false;
        this._mvaConnProps = rioUtil.getMVAConnectionProperties();
        boolean applyFormats = this._mvaConnProps.isApplyFormats();
        this.m_bindKey = applyFormats ? 3 : 2;
        this.m_hashCode = hashCode;
        this._cacheIndex = -1;
        this._rowNumber = 0;
        this._position = Position.BEFORE_FIRST;
        this.m_rows = new Cache(0);
        this._columns = this._rioUtil.getColumns(this.m_hashCode);
        this.m_cacheSize = this.computeFetchSize();
    }

    MVARowCache(MVAStatement mvaStatement, String libref, @Nonnull String tableName, @Nullable String[] password, String options, int bindKey) throws SQLException {
        this._rioUtil = mvaStatement.getRioUtil();
        this._isDirect = true;
        this._mvaConnProps = mvaStatement.getMVAConnectionProperties();
        this.m_bindKey = bindKey;
        this.m_hashCode = this.openDataSet(mvaStatement, libref, tableName, password, options);
        if (this.m_hashCode == -1) {
            this._columns = new Column[0];
            return;
        }
        this._cacheIndex = -1;
        this._rowNumber = 0;
        this._position = Position.BEFORE_FIRST;
        this.m_rows = new Cache(0);
        this._columns = this._rioUtil.getColumns(this.m_hashCode);
        this.m_cacheSize = this.computeFetchSize();
    }

    private int computeFetchSize() {
        int bufferSize = 262144;
        int width = 0;
        for (Column c : this._columns) {
            width += c.getLength();
        }
        int fetchSize = width == 0 ? 100 : 262144 / width;
        if (fetchSize == 0) {
            fetchSize = 1;
        }
        return fetchSize;
    }

    @Override
    public void setFetchSize(int size) throws SQLException {
        this.m_cacheSize = size;
        if (this._position == Position.BEFORE_FIRST || this._position == Position.AFTER_LAST) {
            this.m_rows.setSize(size);
            return;
        }
        MVARow r = (MVARow)this.m_rows.get(this._cacheIndex);
        byte[] startBookmark = r.getBookmark();
        this.m_rows.setSize(size);
        this.refresh(startBookmark);
        this._cacheIndex = 0;
    }

    @Override
    public int getFetchSize() {
        return this.m_cacheSize;
    }

    @Override
    public void setMaxRows(int m) {
        this.m_maxRows = m;
    }

    public int getMaxRows() {
        return this.m_maxRows;
    }

    public int getColumnCount() {
        return this._columns.length;
    }

    @Override
    public Column[] getColumns() {
        return this._columns;
    }

    @Override
    public int getRow() {
        int position = this._updateRow != null && this._updateType == UpdateType.INSERT ? 0 : (this._position == Position.VALID_ROW ? this._rowNumber : 0);
        return position;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        boolean afterLast = this._updateRow == null && this._position == Position.AFTER_LAST;
        return afterLast;
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        if (this._updateRow != null) {
            return false;
        }
        if (this._rowNumber > 0) {
            return this._position == Position.BEFORE_FIRST;
        }
        if (this.m_alreadyCounted && this.m_rowCount > 0) {
            return this._position == Position.BEFORE_FIRST;
        }
        boolean peekaboo = this.peek();
        if (peekaboo) {
            this._position = Position.BEFORE_FIRST;
        }
        return this._position == Position.BEFORE_FIRST;
    }

    @Override
    public boolean isFirst() {
        boolean first = this._position == Position.VALID_ROW && this._rowNumber == 1;
        return first;
    }

    @Override
    public boolean isLast() throws SQLException {
        if (this._position != Position.VALID_ROW) {
            return false;
        }
        if (this.m_status != -1) {
            if (this._cacheIndex < this.m_rows.size() - 1) {
                return false;
            }
            int save = this._rowNumber;
            boolean f = this.absolute(this._rowNumber + 1);
            this.absolute(save);
            return !f;
        }
        return this._cacheIndex == this.m_rows.size() - 1;
    }

    @Override
    public boolean getIsMissing(int i) throws SQLException {
        --i;
        if (this._updateRow != null) {
            return this._updateRow.getMissing(i);
        }
        if (this._position != Position.VALID_ROW) {
            throw new MVASQLException(MessageCode.MVAResultSet_invalidRowPosition, new Object[0]);
        }
        MVARow row = (MVARow)this.m_rows.get(this._cacheIndex);
        return row.getMissing(i);
    }

    @Override
    public int getSqlType(int columnIndex) {
        Column c = this._columns[columnIndex - 1];
        return c.getSqlType();
    }

    @Override
    public Object getData(int column) throws SQLException {
        if (this._updateRow == null && this._position != Position.VALID_ROW) {
            throw new MVASQLException(MessageCode.MVAResultSet_invalidRowPosition, new Object[0]);
        }
        --column;
        if (this._updateRow != null) {
            if (this.getSqlType(column + 1) != 12 && this._updateRow.getMissing(column)) {
                return 0.0;
            }
            return this._updateRow.getData(column);
        }
        MVARow mvaRow = (MVARow)this.m_rows.get(this._cacheIndex);
        if (mvaRow == null) {
            return null;
        }
        return mvaRow.getData(column);
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        this._updateType = UpdateType.INSERT;
        this._updateRow = new MVARow(this._columns.length, this.m_bindKey == 0);
        block3: for (int i = 0; i < this._columns.length; ++i) {
            switch (this.getSqlType(i + 1)) {
                case 12: {
                    this._updateRow.add(i, null);
                    this._updateRow.setMissing(i, true);
                    continue block3;
                }
                default: {
                    this._updateRow.add(i, Double.NaN);
                    this._updateRow.setMissing(i, true);
                }
            }
        }
    }

    @Override
    public void moveToCurrentRow() {
        this._updateRow = null;
        this._updateType = UpdateType.NONE;
    }

    @Override
    public boolean next() throws SQLException {
        if (this.m_peekFlag) {
            this.m_peekFlag = false;
            this._position = Position.VALID_ROW;
            return true;
        }
        this.moveToCurrentRow();
        if (this._position == Position.AFTER_LAST) {
            return false;
        }
        if (this.m_maxRows > 0 && this._rowNumber + 1 > this.m_maxRows) {
            this._rowNumber = this.m_maxRows + 1;
            this._position = Position.AFTER_LAST;
            return false;
        }
        if (this._cacheIndex >= 0 && this._cacheIndex < this.m_rows.size() - 1) {
            ++this._cacheIndex;
            ++this._rowNumber;
            this._position = Position.VALID_ROW;
            return true;
        }
        if (this._cacheIndex > this.m_rows.size() - 1) {
            this._cacheIndex = this.m_rows.size() - 1;
        }
        if (this._rowNumber == 0) {
            int offset;
            int n = offset = this._rowNumber == -1 ? 0 : this._rowNumber;
            if (this.readRecordsWithOffset(this.m_bindKey, this.m_cacheSize, offset)) {
                this._position = Position.VALID_ROW;
                this._cacheIndex = 0;
                ++this._rowNumber;
                return true;
            }
            this._position = Position.AFTER_LAST;
            if (!this.m_rows.isEmpty()) {
                ++this._rowNumber;
            }
            return false;
        }
        if (this.readRecordsWithBookmark(this.m_bindKey, this.m_cacheSize)) {
            this._position = Position.VALID_ROW;
            this._cacheIndex = 0;
            ++this._rowNumber;
            return true;
        }
        this._position = Position.AFTER_LAST;
        if (!this.m_rows.isEmpty()) {
            ++this._rowNumber;
        }
        return false;
    }

    @Override
    public boolean previous() throws SQLException {
        boolean success = false;
        this.moveToCurrentRow();
        int flags = 0;
        byte[] pos = null;
        int offset = 0;
        if (this._position == Position.BEFORE_FIRST) {
            return false;
        }
        if (this._position == Position.AFTER_LAST) {
            if (this.isEmpty()) {
                this._position = Position.BEFORE_FIRST;
                return false;
            }
            this._position = Position.VALID_ROW;
            --this._rowNumber;
            this._cacheIndex = this.m_rows.size() - 1;
            return true;
        }
        if (this._cacheIndex < 0 || this._rowNumber == 0) {
            return false;
        }
        if (this._cacheIndex == 0 && this._rowNumber == 1) {
            this._position = Position.BEFORE_FIRST;
            --this._rowNumber;
            --this._cacheIndex;
            return false;
        }
        if (this._cacheIndex == 0) {
            flags = 3;
            pos = ((MVARow)this.m_rows.get(this._cacheIndex)).getBookmark();
            offset = -1;
            try {
                success = this.m_status == -2 ? false : this.readRecords(flags, this.m_bindKey, -this.m_cacheSize, offset, pos);
            }
            catch (SQLException e) {
                throw new MVASQLException(MessageCode.MVAResultSet_previousError, (Throwable)e, new Object[0]);
            }
            if (success) {
                this._cacheIndex = this.m_rows.size() - 1;
                --this._rowNumber;
                this._position = Position.VALID_ROW;
            } else {
                --this._rowNumber;
                this._cacheIndex = -1;
                this._position = Position.BEFORE_FIRST;
            }
        } else {
            --this._cacheIndex;
            --this._rowNumber;
            if (this._rowNumber > 0) {
                success = true;
                this._position = Position.VALID_ROW;
            } else {
                success = false;
                this._position = Position.BEFORE_FIRST;
            }
        }
        return success;
    }

    @Override
    public boolean absolute(int destinationRow) throws SQLException {
        this.moveToCurrentRow();
        boolean success = false;
        if (this.m_maxRows > 0 && destinationRow > this.m_maxRows) {
            while (this.next()) {
            }
            return false;
        }
        if (destinationRow == 0) {
            this.m_peekFlag = false;
            this._position = Position.BEFORE_FIRST;
            this._rowNumber = 0;
            this._cacheIndex = -1;
            return false;
        }
        if (destinationRow > 0) {
            boolean ableToCalc = true;
            int cacheStart = 0;
            int cacheEnd = 0;
            if (this._position != Position.VALID_ROW) {
                ableToCalc = false;
            } else {
                ableToCalc = true;
                cacheStart = this._rowNumber - this._cacheIndex;
                cacheEnd = cacheStart + this.m_rows.size() - 1;
                if (this.m_status == -1 && destinationRow > cacheEnd) {
                    this.m_peekFlag = false;
                    this._position = Position.AFTER_LAST;
                    this._rowNumber = cacheEnd + 1;
                    return false;
                }
            }
            if (!ableToCalc || this._rowNumber == 0 || this._cacheIndex < 0 || destinationRow < cacheStart || destinationRow > cacheEnd) {
                int move = destinationRow / this.m_cacheSize;
                int offset = destinationRow % this.m_cacheSize;
                move = destinationRow < this.m_cacheSize ? (move *= this.m_cacheSize) : (move > 0 && offset == 0 ? (move - 1) * this.m_cacheSize : (move *= this.m_cacheSize));
                if (offset == 0) {
                    offset = this.m_cacheSize;
                }
                --offset;
                success = this.readRecordsWithOffset(this.m_bindKey, this.m_cacheSize, move);
                if (success) {
                    if (offset >= this.m_rows.size()) {
                        this._position = Position.AFTER_LAST;
                        success = false;
                        this._rowNumber = move + this.m_rows.size() + 1;
                    } else {
                        this._cacheIndex = offset;
                        this._rowNumber = destinationRow;
                        this._position = Position.VALID_ROW;
                    }
                    this.m_peekFlag = false;
                } else if (destinationRow > 0) {
                    while (this.next()) {
                    }
                }
            } else {
                this.m_peekFlag = false;
                this._cacheIndex = destinationRow - cacheStart;
                this._rowNumber = destinationRow;
                this._position = Position.VALID_ROW;
                success = true;
            }
        } else {
            int cc = this.count(this._rowNumber);
            if (Math.abs(destinationRow) > cc) {
                success = this.absolute(0);
            } else {
                int newpos = cc + 1 - Math.abs(destinationRow);
                success = this.absolute(newpos);
            }
        }
        return success;
    }

    @Override
    public boolean relative(int distance) throws SQLException {
        if (this._position != Position.VALID_ROW) {
            throw new MVASQLException(MessageCode.MVAResultSet_invalidRowPosition, new Object[0]);
        }
        this.moveToCurrentRow();
        if (this._position != Position.VALID_ROW) {
            return false;
        }
        long newpos = (long)this._rowNumber + 1L + (long)distance;
        if (newpos > Integer.MAX_VALUE) {
            this.afterLast();
            return false;
        }
        if (newpos <= 0L) {
            return this.absolute(0);
        }
        return this.absolute((int)newpos);
    }

    @Override
    public void updateData(int column, Object updateObj) throws SQLException {
        if (this._position != Position.VALID_ROW && this._updateType == UpdateType.UPDATE) {
            throw new MVASQLException(MessageCode.MVAResultSet_invalidRowPosition, new Object[0]);
        }
        --column;
        if (this._updateRow == null) {
            if (this._rowNumber > 0 && this._cacheIndex < this.m_rows.size()) {
                this._updateRow = new MVARow((MVARow)this.m_rows.get(this._cacheIndex));
                this._updateType = UpdateType.UPDATE;
            } else {
                throw new MVASQLException(MessageCode.MVAResultSet_invalidRowPosition, new Object[0]);
            }
        }
        if (updateObj == null && this.getSqlType(column + 1) == 12) {
            updateObj = "";
        }
        if (column >= this._updateRow.size()) {
            this._updateRow.add(column, updateObj);
        } else {
            this._updateRow.setData(column, updateObj);
        }
        if (updateObj instanceof Double && Double.isNaN((Double)updateObj)) {
            this._updateRow.setMissing(column, true);
        }
    }

    @Override
    public void cancelUpdate() {
        this._updateRow = null;
        this._updateType = UpdateType.NONE;
    }

    @Override
    public void close() throws SQLException {
        if (this._rioUtil != null) {
            this._rioUtil.close(this.m_hashCode);
        }
        this.m_rows.clear();
    }

    @Override
    public synchronized void insertRow() throws SQLException {
        if (this._updateRow == null) {
            throw new MVASQLException(MessageCode.MVAResultSet_insertFailedNoDataError, new Object[0]);
        }
        if (this._updateType == UpdateType.UPDATE) {
            throw new MVASQLException(MessageCode.MVAResultSet_notOnInsertRowError, new Object[0]);
        }
        this._rioUtil.insertRow(this.m_hashCode, this._columns, this._updateRow);
        this._updateRow = null;
        this._updateType = UpdateType.NONE;
        this.m_countValid = false;
    }

    @Override
    public synchronized void updateRow() throws SQLException {
        if (this._updateType == UpdateType.INSERT) {
            throw new MVASQLException(MessageCode.MVAResultSet_insertRowUpdateError, new Object[0]);
        }
        if (this._updateRow == null) {
            return;
        }
        int[] columnTypes = new int[this.getColumnCount()];
        Object[] data = new Object[this.getColumnCount()];
        for (int i = 0; i < this.getColumnCount(); ++i) {
            columnTypes[i] = this.getSqlType(i + 1);
            data[i] = this._updateRow.getData(i);
            if (columnTypes[i] == 12 || !this._updateRow.getMissing(i)) continue;
            data[i] = Double.NaN;
        }
        byte[] bookmarksUpdate = null;
        MVARow f = (MVARow)this.m_rows.get(this._cacheIndex);
        bookmarksUpdate = f.getBookmark();
        try {
            this._rioUtil.updateRow(this.m_hashCode, data, bookmarksUpdate, this.m_bindKey, columnTypes);
        }
        catch (Exception e) {
            throw new MVASQLException(MessageCode.MVAResultSet_updateFailed, (Throwable)e, new Object[0]);
        }
        this._updateRow.setBookmark(bookmarksUpdate);
        for (int xx = 0; xx < this.getColumnCount(); ++xx) {
            if (columnTypes[xx] != 12) {
                String tv;
                double tdv = this.m_bindKey == 3 ? ((tv = data[xx].toString()).length() == 0 || tv.trim().equals("") ? Double.NaN : Double.parseDouble(tv)) : (Double)data[xx];
                if (!Double.isNaN(tdv)) continue;
                this._updateRow.setData(xx, 0.0);
                this._updateRow.setMissing(xx, true);
                continue;
            }
            if (columnTypes[xx] != 12 || data[xx] != null) continue;
            this._updateRow.setData(xx, "");
        }
        if (this.m_bindKey == 3) {
            this.refresh();
        } else {
            this.m_rows.set(this._cacheIndex, this._updateRow);
        }
        this._updateRow = null;
        this._updateType = UpdateType.NONE;
    }

    @Override
    public void refresh() throws SQLException {
        if (this._position != Position.VALID_ROW) {
            throw new MVASQLException(MessageCode.MVAResultSet_invalidRowPosition, new Object[0]);
        }
        MVARow r = (MVARow)this.m_rows.get(0);
        int offset = 0;
        byte[] startBookmark = r.getBookmark();
        int flags = 3;
        this.readRecords(flags, this.m_bindKey, this.m_cacheSize, offset, startBookmark);
        this._updateRow = null;
        this._updateType = UpdateType.NONE;
    }

    protected void refresh(byte[] bookmark) throws SQLException {
        int offset = 0;
        int flags = 3;
        boolean success = false;
        success = this.readRecords(flags, this.m_bindKey, this.m_cacheSize, offset, bookmark);
        if (success) {
            this._updateRow = null;
        }
    }

    @Override
    public synchronized void deleteRow() throws SQLException {
        if (this._position != Position.VALID_ROW || this._updateRow != null) {
            throw new MVASQLException(MessageCode.MVAResultSet_invalidRowPosition, new Object[0]);
        }
        try {
            MVARow r = (MVARow)this.m_rows.get(this._cacheIndex);
            byte[] bookmarksDelete = r.getBookmark();
            this._rioUtil.deleteRow(this.m_hashCode, bookmarksDelete);
            this.m_rows.remove(this._cacheIndex);
            if (this._cacheIndex == this.m_rows.size()) {
                --this._cacheIndex;
                --this._rowNumber;
                this.next();
            }
            this.m_countValid = false;
        }
        catch (Exception e) {
            throw new MVASQLException(MessageCode.MVAResultSet_deleteFailed, (Throwable)e, new Object[0]);
        }
    }

    private boolean peek() throws SQLException {
        this.m_peekFlag = this.next();
        return this.m_peekFlag;
    }

    private int count(int prior) throws SQLException {
        if (!this._isDirect && this.m_alreadyCounted) {
            return this.m_rowCount;
        }
        if (this._isDirect) {
            if (this.m_alreadyCounted && this.m_countValid) {
                return this.m_rowCount;
            }
            int lrc = 0;
            try {
                this.m_rowCount = lrc = this._rioUtil.countRecords(this.m_hashCode);
            }
            catch (Exception e) {
                throw new MVASQLException(MessageCode.MVAStatement_executeError, (Throwable)e, new Object[0]);
            }
            this.m_alreadyCounted = true;
            this.m_countValid = true;
            if (this.m_maxRows > 0 && this.m_rowCount > this.m_maxRows) {
                this.m_rowCount = this.m_maxRows;
            }
            return this.m_rowCount;
        }
        if (this.m_alreadyCounted && this.m_countValid) {
            return this.m_rowCount;
        }
        int lrc = 0;
        try {
            this.m_rowCount = lrc = this._rioUtil.countRecords(this.m_hashCode);
        }
        catch (Exception e) {
            try {
                while (this.next()) {
                }
                this.m_rowCount = this._rowNumber - 1;
                this.absolute(prior);
                if (this.m_rowCount < 0) {
                    this.m_rowCount = 0;
                }
                this.m_alreadyCounted = true;
                return this.m_rowCount;
            }
            catch (Exception ee) {
                throw new MVASQLException(MessageCode.MVAStatement_executeError, (Throwable)e, new Object[0]);
            }
        }
        this.m_alreadyCounted = true;
        this.m_countValid = true;
        if (this.m_maxRows > 0 && this.m_rowCount > this.m_maxRows) {
            this.m_rowCount = this.m_maxRows;
        }
        return this.m_rowCount;
    }

    private int openDataSet(MVAStatement stmt, String libref, String tableName, String[] password, String options) throws SQLException {
        if (this._rioUtil == null) {
            throw new MVASQLException(MessageCode.MVAResultSet_openDataSetError, new Object[0]);
        }
        int hashCode = this._rioUtil.openDataSet2(libref, tableName, password, options, stmt.getResultSetConcurrency(), stmt.getResultSetType());
        return hashCode;
    }

    protected boolean readRecordsWithNfp(int bindKey, int rows) throws SQLException {
        int flags = 19;
        return this.readRecords(flags, bindKey, rows, 0, new byte[0]);
    }

    protected boolean readRecordsWithOffset(int bindKey, int rows, int offset) throws SQLException {
        int flags = 23;
        return this.readRecords(flags, bindKey, rows, offset, new byte[0]);
    }

    protected boolean readRecordsWithBookmark(int bindKey, int rows) throws SQLException {
        int flags = 19;
        MVARow r = (MVARow)this.m_rows.get(this._cacheIndex);
        byte[] pos = r.getBookmark();
        return this.readRecords(flags, bindKey, rows, 1, pos);
    }

    protected boolean readRecords(int flags, int bindKey, int rows, int rowsOffset, byte[] pos) throws SQLException {
        boolean forward;
        boolean bl = forward = rows >= 0;
        if (this._rioUtil == null) {
            return false;
        }
        assert ((flags & 1) == 1);
        DataHolder data = this._rioUtil.readRecords2(this.m_hashCode, flags |= 0x10, bindKey, rows, rowsOffset, pos);
        if (data.isEmpty()) {
            return false;
        }
        this.m_status = data.status;
        int blen = data.bookmarkArray.length / data.characterValues.length;
        if (forward) {
            this.addForwardRows(data, blen);
        } else {
            this.addBackwardRows(data, blen);
        }
        return true;
    }

    protected void addForwardRows(DataHolder data, int blen) {
        String[][] characterValues = data.characterValues;
        double[][] numericValues = data.numericValues;
        byte[][] missingNumericValues = data.missingNumericValues;
        byte[] bookmarks = data.bookmarkArray;
        int nCharColumns = 0;
        for (Column c : this._columns) {
            if (c.getSqlType() != 12) continue;
            ++nCharColumns;
        }
        this.m_rows.clear();
        this.m_rows.ensureCapacity(DataHolder.rowCount(data));
        Object[] rowData = new Object[this._columns.length];
        boolean[] missingData = new boolean[this._columns.length];
        String[] dualFormattedData = this.m_bindKey == 0 ? new String[this._columns.length] : null;
        boolean isBindKeyAll = this.m_bindKey == 0;
        boolean numericsAreCoercedToChars = this.m_bindKey == 3;
        for (int rowIdx = 0; rowIdx < characterValues.length; ++rowIdx) {
            int from = rowIdx * blen;
            byte[] b = Arrays.copyOfRange(bookmarks, from, from + blen);
            int cIdx = 0;
            int nIdx = 0;
            int nMissingIdx = 0;
            int fIdx = nCharColumns;
            for (int colIdx = 0; colIdx < this._columns.length; ++colIdx) {
                String formatted;
                Column c = this._columns[colIdx];
                int cType = c.getSqlType();
                if (cType == 12) {
                    rowData[colIdx] = characterValues[rowIdx][cIdx++];
                } else {
                    byte missingValue;
                    boolean isMissing;
                    missingData[colIdx] = isMissing = (missingValue = missingNumericValues[rowIdx][nMissingIdx++]) != 127;
                    rowData[colIdx] = numericsAreCoercedToChars ? characterValues[rowIdx][cIdx++] : Double.valueOf(numericValues[rowIdx][nIdx++]);
                }
                if (!isBindKeyAll) continue;
                dualFormattedData[colIdx] = formatted = characterValues[rowIdx][fIdx++];
            }
            MVARow row = new MVARow(b, rowData, missingData, dualFormattedData);
            this.m_rows.add(row);
        }
    }

    protected void addBackwardRows(DataHolder data, int blen) {
        String[][] characterValues = data.characterValues;
        double[][] numericValues = data.numericValues;
        byte[][] missingNumericValues = data.missingNumericValues;
        byte[] bookmarks = data.bookmarkArray;
        int nCharColumns = 0;
        for (Column c : this._columns) {
            if (c.getSqlType() != 12) continue;
            ++nCharColumns;
        }
        this.m_rows.clear();
        this.m_rows.ensureCapacity(DataHolder.rowCount(data));
        Object[] rowData = new Object[this._columns.length];
        boolean[] missingData = new boolean[this._columns.length];
        String[] dualFormattedData = this.m_bindKey == 0 ? new String[this._columns.length] : null;
        boolean isBindKeyAll = this.m_bindKey == 0;
        boolean numericsAreCoercedToChars = this.m_bindKey == 3;
        for (int rowIdx = characterValues.length - 1; rowIdx >= 0; --rowIdx) {
            int from = rowIdx * blen;
            byte[] b = Arrays.copyOfRange(bookmarks, from, from + blen);
            int cIdx = 0;
            int nIdx = 0;
            int nMissingIdx = 0;
            int fIdx = nCharColumns;
            for (int colIdx = 0; colIdx < this._columns.length; ++colIdx) {
                String formatted;
                Column c = this._columns[colIdx];
                int cType = c.getSqlType();
                if (12 == cType) {
                    rowData[colIdx] = characterValues[rowIdx][cIdx++];
                } else {
                    byte missingValue;
                    boolean isMissing;
                    missingData[colIdx] = isMissing = (missingValue = missingNumericValues[rowIdx][nMissingIdx++]) != 127;
                    rowData[colIdx] = numericsAreCoercedToChars ? characterValues[rowIdx][cIdx++] : Double.valueOf(numericValues[rowIdx][nIdx++]);
                }
                if (!isBindKeyAll) continue;
                dualFormattedData[colIdx] = formatted = characterValues[rowIdx][fIdx++];
            }
            MVARow row = new MVARow(b, rowData, missingData, dualFormattedData);
            this.m_rows.add(row);
        }
    }

    @Override
    @SASScope
    public int getHashCode() {
        return this.m_hashCode;
    }

    @Override
    @SASScope
    public RIOUtil getRioUtil() {
        return this._rioUtil;
    }

    public String getFormatted(int columnIndex) throws SQLException {
        assert (this.m_bindKey == 0);
        if (this._position != Position.VALID_ROW && this._updateRow == null) {
            throw new MVASQLException(MessageCode.MVAResultSet_invalidRowPosition, new Object[0]);
        }
        --columnIndex;
        MVARow mvaRow = (MVARow)this.m_rows.get(this._cacheIndex);
        if (mvaRow == null) {
            return null;
        }
        return mvaRow.getFormatted(columnIndex);
    }

    @Override
    public void afterLast() throws SQLException {
        this.last();
        this.next();
    }

    @Override
    public boolean first() throws SQLException {
        return this.absolute(1);
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.absolute(1);
        this.previous();
    }

    @Override
    public boolean isEmpty() {
        return this.m_rows.isEmpty();
    }

    @Override
    public boolean last() throws SQLException {
        return this.absolute(-1);
    }

    static enum UpdateType {
        UPDATE,
        INSERT,
        NONE;

    }

    static enum Position {
        BEFORE_FIRST,
        AFTER_LAST,
        VALID_ROW;

    }
}

