/*
 * Decompiled with CFR 0.152.
 */
package com.sas.net.brg.orb;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.iom.orb.SASURI;
import com.sas.iom.orb.SelectionHub;
import com.sas.iom.orb.brg.ORBImpl;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.omg.CORBA.Object;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public class BrgOrb
extends ORBImpl {
    public BrgOrb() {
    }

    public BrgOrb(Properties properties) {
        this.set_parameters((String[])null, properties);
    }

    @SASScope
    public BrgOrb(SelectionHub hub) {
        super(hub);
    }

    public Object propertiesToObject(Properties properties) {
        return this.propertiesToObjectNoCopy(properties);
    }

    public Object propertiesToObjectNoCopy(Properties properties) {
        SASURI uri = BrgOrb.properties_to_uri(properties);
        Object obj = this.uri_to_object(uri);
        return obj;
    }

    public Properties objectToProperties(Object obj) {
        SASURI uri = this.object_to_uri(obj);
        Properties p = BrgOrb.uri_to_properties(uri);
        return p;
    }

    public static Properties referenceToProperties(String reference) {
        return BrgOrb.sorToProperties(reference);
    }

    public static String propertiesToReference(Properties properties) {
        Map map = BrgOrb.propertiesToMap(properties);
        String sor = BrgOrb.mapToSOR(map);
        return sor;
    }

    private static SASURI properties_to_uri(Properties p) {
        Map map = BrgOrb.propertiesToMap(p);
        String sor = BrgOrb.mapToSOR(map);
        SASURI uri = SASURI.create(sor);
        return uri;
    }

    private static Properties uri_to_properties(SASURI uri) {
        String sor = uri.toString();
        Properties p = BrgOrb.sorToProperties(sor);
        BrgOrb.manglePropertyNames(p);
        return p;
    }

    private static Map propertiesToMap(Properties p) {
        HashMap<java.lang.Object, java.lang.Object> map = new HashMap<java.lang.Object, java.lang.Object>(p);
        BrgOrb.convertStringValToInt(map, "major");
        BrgOrb.convertStringValToInt(map, "minor");
        BrgOrb.convertStringValToInt(map, "port");
        return map;
    }

    private static void convertStringValToInt(Map m, java.lang.Object k) {
        String v = (String)m.get(k);
        if (v != null) {
            Integer _v = new Integer(v);
            m.put(k, _v);
        }
    }

    private static String mapToSOR(Map map) {
        String clsid;
        Integer port;
        String host = (String)map.get("host");
        if (host == null) {
            host = "localhost";
        }
        if ((port = (Integer)map.get("port")) == null) {
            port = new Integer(5312);
        }
        if ((clsid = (String)map.get("clsid")) == null) {
            clsid = "440196D4-90F0-11D0-9F41-00A024BB830C";
        }
        StringBuffer buffer = new StringBuffer("bridge://");
        buffer.append(host);
        buffer.append(":");
        buffer.append(port);
        buffer.append("/");
        buffer.append(clsid);
        StringBuffer query = null;
        Set entrySet = map.entrySet();
        for (Map.Entry entry : entrySet) {
            String propertyName;
            java.lang.Object key = entry.getKey();
            if (!(key instanceof String) || (propertyName = (String)key).equals("protocol") || propertyName.equals("host") || propertyName.equals("port") || propertyName.equals("clsid")) continue;
            if (query == null) {
                query = new StringBuffer();
            } else {
                query.append("&");
            }
            String k = SASURI.urlEncode(propertyName);
            query.append(k);
            query.append("=");
            java.lang.Object val = entry.getValue();
            String propertyVal = val.toString();
            String v = SASURI.urlEncode(propertyVal);
            query.append(v);
        }
        if (query != null) {
            buffer.append("?");
            buffer.append(query.toString());
        }
        return buffer.toString();
    }

    private static Properties sorToProperties(String url) {
        Properties properties = new Properties();
        int index0 = url.indexOf("://");
        if (index0 < 0) {
            properties.put("protocol", url);
            return properties;
        }
        String s = url.substring(0, index0);
        properties.put("protocol", s);
        int index1 = url.indexOf("/", index0 += 3);
        s = index1 < 0 ? url.substring(index0) : url.substring(index0, index1);
        int index2 = 0;
        if (s.length() > 0) {
            index2 = s.indexOf(":");
            if (index2 < 0) {
                properties.put("host", s);
            } else {
                properties.put("host", s.substring(0, index2));
                properties.put("port", s.substring(index2 + 1));
            }
        }
        if (index1 < 0) {
            return properties;
        }
        index0 = index1 + 1;
        int length = url.length();
        if (index0 >= length) {
            return properties;
        }
        index1 = url.indexOf("?", index0);
        if (index1 < 0) {
            properties.put("clsid", url.substring(index0));
            return properties;
        }
        properties.put("clsid", url.substring(index0, index1));
        index0 = index1 + 1;
        while (index0 < length) {
            index1 = url.indexOf("=", index0);
            if (index1 < 0) {
                properties.put(BrgOrb.decode(url.substring(index0)), "");
                return properties;
            }
            String name = url.substring(index0, index1);
            index0 = index1 + 1;
            if (index0 < length) {
                index1 = url.indexOf("&", index0);
                if (index1 < 0) {
                    properties.put(BrgOrb.decode(name), BrgOrb.decode(url.substring(index0)));
                    return properties;
                }
                properties.put(BrgOrb.decode(name), BrgOrb.decode(url.substring(index0, index1)));
                index0 = index1 + 1;
                continue;
            }
            properties.put(BrgOrb.decode(name), "");
            return properties;
        }
        return properties;
    }

    private static String decode(String s) {
        if (s.indexOf(43) == -1 && s.indexOf(37) == -1) {
            return s;
        }
        return SASURI.urlDecode(s);
    }

    private static void manglePropertyNames(Properties p) {
        String userName = (String)p.remove("username");
        if (userName != null) {
            p.put("userName", userName);
        }
    }
}

