"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Assignment = exports.TargetTypes = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const permissionset_common_1 = require("./private/permissionset-common");
const principal_common_1 = require("./private/principal-common");
var TargetTypes;
(function (TargetTypes) {
    TargetTypes["AWS_ACCOUNT"] = "AWS_ACCOUNT";
})(TargetTypes = exports.TargetTypes || (exports.TargetTypes = {}));
/**
 * The base assignment class
 *
 * Currently this is mostly empty. There isn't any
 * valuable methods to apply here or any resulting
 * attributes to define.
 */
class AssignmentBase extends aws_cdk_lib_1.Resource {
}
;
/**
 * The assignment construct.
 *
 * Has no import method because there is no attributes to import.
 */
class Assignment extends AssignmentBase {
    constructor(scope, id, props) {
        super(scope, id);
        if (props.targetType === TargetTypes.AWS_ACCOUNT) {
            Assignment.validateAwsAccountTargetId(props.targetId);
        }
        principal_common_1.validatePrincipal(props.principal);
        permissionset_common_1.validatePermissionSetArn(props.permissionSet.permissionSetArn);
        const targetType = props.targetType ?? TargetTypes.AWS_ACCOUNT;
        new aws_cdk_lib_1.aws_sso.CfnAssignment(this, 'assignment', {
            instanceArn: props.permissionSet.ssoInstanceArn,
            permissionSetArn: props.permissionSet.permissionSetArn,
            principalId: props.principal.principalId,
            principalType: props.principal.principalType,
            targetId: props.targetId,
            targetType,
        });
    }
    static validateAwsAccountTargetId(targetId) {
        if (!targetId.match(/\d{12}/)) {
            throw new Error(`targetId should be a 12 digit AWS account id: ${targetId}`);
        }
    }
}
exports.Assignment = Assignment;
_a = JSII_RTTI_SYMBOL_1;
Assignment[_a] = { fqn: "@renovosolutions/cdk-library-aws-sso.Assignment", version: "0.1.17" };
//# sourceMappingURL=data:application/json;base64,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